/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index.domain;

import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.index.util.IndexUtil;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class ChnlDocLCListenerForIndex
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify,
IObjectLCListenerOnDel {
    private static Logger logger = Logger.getLogger(ChnlDocLCListenerForIndex.class);

    public boolean needSychroIndex() {
        String isearcherSericeClass = "";
        try {
            isearcherSericeClass = ConfigServer.getServer().getSysConfigValue("TRS_SEARCHER", "SearchBySqlService");
        }
        catch (WCMException e) {
            logger.error((Object)"\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u9879TRS_SEARCHER\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return "SearchByLuceneService".equalsIgnoreCase(isearcherSericeClass.trim());
    }

    @Override
    public void notifyOnAddObj(BaseObj objAdded) {
        if (!this.needSychroIndex()) {
            return;
        }
        new Thread(new IndexRunnable(objAdded, IndexUtil.INDEX_ADD)).start();
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!this.needSychroIndex()) {
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)objModified;
        new Thread(new IndexRunnable(chnlDoc, IndexUtil.INDEX_UPD)).start();
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
        if (!this.needSychroIndex()) {
            return;
        }
        new Thread(new IndexRunnable(objDeleted, IndexUtil.INDEX_DEL)).start();
    }

    private class IndexRunnable
    implements Runnable {
        private BaseObj obj;
        private int operType;

        public IndexRunnable(BaseObj obj, int operType) {
            this.obj = obj;
            this.operType = operType;
        }

        @Override
        public void run() {
            try {
                IndexUtil.makeIndexForListener(this.obj, null, this.operType);
            }
            catch (WCMException e) {
                e.printStackTrace();
            }
        }
    }
}

