/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.update;

import com.trs.db.update.DBUpdateLog;
import com.trs.db.update.DBUpdateLogs;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.database.DBTypes;

public class DBUpdateLogMgr {
    private String[] WCM51_UPDATE_SQLSERVER_SQL = new String[]{"UPDATE WCMDOCUMENT SET DOCSTATUS=18 WHERE DOCSTATUS=19;", "UPDATE WCMCHNLDOC SET DOCSTATUS=18 WHERE DOCSTATUS=19;", "DELETE FROM WCMSTATUS WHERE STATUSID=19;"};
    private String[] WCM51_UPDATE_ORACLE_SQL = new String[]{"UPDATE WCMDOCUMENT SET DOCSTATUS=18 WHERE DOCSTATUS=19;", "UPDATE WCMCHNLDOC SET DOCSTATUS=18 WHERE DOCSTATUS=19;", "DELETE FROM WCMSTATUS WHERE STATUSID=19;"};

    public String getUpdateSql(int _nDBType, String _sOrderField, boolean _bAutoAddCommit, boolean _bAddTitle, boolean _bAuthor, CMyDateTime _dtStart) throws WCMException {
        String sSql;
        String sOrderBy = _sOrderField;
        if (sOrderBy == null) {
            sOrderBy = "CRTIME";
        }
        String sWhere = "";
        if (_dtStart != null && !_dtStart.isNull()) {
            sWhere = "CRTIME>" + DBManager.getDBManager().getDBType().sqlDateTime(_dtStart.toString(), "YYYY-MM-DD HH24:MI:SS");
        }
        if (!CMyString.isEmpty(sWhere)) {
            sWhere = sWhere + " and LogProductor in ('TRS.WCM.V6.1','TRS.WCM.V6.1.Infoview','TRS.WCM.V6.1.MetaData', 'TRS.WCM.V6.1.Pic', 'TRS.WCM.V6.1.Video')";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, sOrderBy, "");
        DBUpdateLogs allLogs = DBUpdateLogs.openWCMObjs(aFilter);
        String string = sSql = _nDBType == 1 ? "set serverout on;\n set escape on;\n" : "";
        if (_dtStart == null || _dtStart.isNull()) {
            sSql = sSql + this.getWCM51UpdateSQL(_nDBType);
        }
        for (int i = 0; i < allLogs.size(); ++i) {
            DBUpdateLog currLog = (DBUpdateLog)allLogs.getAt(i);
            String currSql = currLog.getSQL(_nDBType);
            if (currSql == null) {
                currSql = "";
            }
            if (currLog.getTitle() != null && _bAddTitle) {
                sSql = sSql + "-- " + currLog.getTitle() + "-" + currLog.getId();
                if (_bAuthor) {
                    sSql = sSql + " by " + currLog.getSubmitor() + "@" + currLog.getCrTime();
                }
                sSql = sSql + "\n";
            }
            sSql = sSql + currSql + "\n";
            sSql = sSql + "\n";
            if (_bAutoAddCommit) {
                sSql = sSql + DBUpdateLog.DB_AUTO_COMMIT[_nDBType - 1] + "\n";
            }
            sSql = sSql + "\n";
        }
        sSql = sSql + "INSERT INTO WCMDBUPDATE (updversion, updinfo, upduser, updtime) \n" + I18NMessage.get(DBUpdateLogMgr.class, "DBUpdateLogMgr.label1", "VALUES (1030, 'WCM52\u7684\u6570\u636e\u5e93\u811a\u672c\u5b8c\u5168\u66f4\u65b0', 'WCM Team', ") + DBTypes.getDBType(_nDBType).sqlDateTime(CMyDateTime.now().toString(), "YYYY-MM-DD HH24:MI:SS") + ");\n";
        sSql = sSql + DBUpdateLog.DB_AUTO_COMMIT[_nDBType - 1] + "\n";
        sSql = sSql + (_nDBType == 1 ? "set serverout off;\n" : "");
        return sSql;
    }

    private String getWCM51UpdateSQL(int type) {
        String sResult = "\n---SQL For WCM51 BEGIN----\n";
        String[] pSQL = type == 1 ? this.WCM51_UPDATE_ORACLE_SQL : this.WCM51_UPDATE_SQLSERVER_SQL;
        for (int i = 0; i < pSQL.length; ++i) {
            sResult = sResult + "\n" + pSQL[i];
        }
        sResult = sResult + "\n---SQL For WCM51 END----\n";
        return sResult;
    }
}

