/*
 * Decompiled with CFR 0.152.
 */
package com.trs.db.schema;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.database.DBType;
import com.trs.infra.util.database.DBTypes;
import com.trs.infra.util.database.TableInfo;
import com.trs.infra.util.database.TableInfos;
import com.trs.infra.util.store.FileService;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class TRSDBSchema {
    private static Logger logger = Logger.getLogger(TRSDBSchema.class);
    private DBManager m_oDBMgr = DBManager.getDBManager();
    private int m_nDBType = 0;
    private DBType m_oDBType = null;

    public TRSDBSchema(int _nDBType) {
        this.m_nDBType = _nDBType;
        this.m_oDBType = DBTypes.getDBType(this.m_nDBType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDBDataInsertSQL(String _sFileName) throws Exception {
        String sPath = CMyFile.extractFilePath(_sFileName);
        if (!CMyFile.pathExists(sPath)) {
            CMyFile.makeDir(sPath, true);
        }
        OutputStream fos = new FileService(_sFileName).getOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter(fos, "GBK");
        try {
            TableInfos oTableInfos = this.m_oDBMgr.getTableInfos();
            Enumeration enTableNames = oTableInfos.getTableNames();
            while (enTableNames.hasMoreElements()) {
                String sTableName = (String)enTableNames.nextElement();
                TableInfo tableInfo = oTableInfos.getTableInfo(sTableName);
                if (tableInfo == null) continue;
                this.createTableDataInsertSQL(tableInfo, outWriter);
            }
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label1", "\u4ea7\u751f\u6570\u636e\u7ef4\u62a4\u811a\u672c\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            try {
                if (outWriter != null) {
                    ((Writer)outWriter).flush();
                    ((Writer)outWriter).close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String createTableDataInsertSQL(TableInfo _tableInfo, Writer _writer) throws WCMException {
        Connection oConn = null;
        Statement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        String strSQL = "select * from " + _tableInfo.getTableName();
        try {
            oConn = this.m_oDBMgr.getConnection();
            oStmt = oConn.createStatement();
            rsData = oStmt.executeQuery(strSQL);
            while (rsData.next()) {
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                _writer.write(this.createSQLFromRs(_tableInfo.getTableName(), rsData, rsmdData));
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label2", "\u83b7\u53d6\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".createTableDataInsertSQL)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label2", "\u83b7\u53d6\u6570\u636e\u65f6\u5931\u8d25\uff08") + this.getClass().getName() + ".refresh)\uff1acreateTableDataInsertSQL=" + strSQL, ex);
        }
        finally {
            try {
                if (rsData != null) {
                    rsData.close();
                }
                if (oStmt != null) {
                    oStmt.close();
                }
            }
            catch (Exception exception) {}
            if (oConn != null) {
                this.m_oDBMgr.freeConnection(oConn);
            }
        }
        return null;
    }

    private String createSQLFromRs(String _sTableName, ResultSet _rsData, ResultSetMetaData _rsmdData) throws WCMException {
        String sFieldNames = null;
        String sFieldValues = null;
        try {
            if (_rsData == null) {
                return null;
            }
            String objValue = null;
            ResultSetMetaData rsmdData = _rsmdData != null ? _rsmdData : _rsData.getMetaData();
            int nColCount = rsmdData.getColumnCount();
            block9: for (int i = 1; i <= nColCount; ++i) {
                String sFieldName = rsmdData.getColumnLabel(i).toUpperCase();
                objValue = null;
                switch (rsmdData.getColumnType(i)) {
                    case -6: 
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: {
                        objValue = _rsData.getString(i);
                        if (!_rsData.wasNull()) break;
                        continue block9;
                    }
                    case 12: {
                        String sTemp = _rsData.getString(i);
                        if (_rsData.wasNull() || sTemp == null) continue block9;
                        objValue = '\'' + this.filterForSQLValue(sTemp) + '\'';
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        Date date = _rsData.getDate(i);
                        if (_rsData.wasNull() || date == null) continue block9;
                        objValue = this.m_oDBType.sqlDateTime(new CMyDateTime(date.getTime()).toString("yyyy-MM-dd HH:mm:ss"), "YYYY-MM-DD HH24:MI:SS");
                        break;
                    }
                    case -1: 
                    case 2005: {
                        objValue = "empty_clob()";
                        break;
                    }
                    default: {
                        String sTemp = _rsData.getString(i);
                        if (_rsData.wasNull() || sTemp == null) continue block9;
                        objValue = '\'' + this.filterForSQLValue(sTemp) + '\'';
                        break;
                    }
                }
                if (sFieldNames == null) {
                    sFieldNames = sFieldName;
                    sFieldValues = objValue;
                    continue;
                }
                sFieldNames = sFieldNames + "," + sFieldName;
                sFieldValues = sFieldValues + "," + objValue;
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label3", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".createSQLFromRs).", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(TRSDBSchema.class, "TRSDBSchema.label3", "\u4ece\u6570\u636e\u5e93\u4e2d\u8bfb\u53d6\u5bf9\u8c61\u4fe1\u606f\u65f6\u51fa\u9519\uff08") + this.getClass().getName() + ".createSQLFromRs).", ex);
        }
        if (sFieldNames == null) {
            return null;
        }
        String sInsertSQL = "insert into " + _sTableName + " (" + sFieldNames + ") values(" + sFieldValues + ")";
        if (this.m_nDBType != 2) {
            sInsertSQL = sInsertSQL + ';';
        }
        sInsertSQL = sInsertSQL + '\n';
        return sInsertSQL;
    }

    private String filterForSQLValue(String _sValue) {
        String sValue = _sValue.replaceAll("'", "''");
        return sValue;
    }
}

