/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.database.util.Row;
import com.trs.database.util.Utils;
import java.util.LinkedList;
import java.util.List;

class Plan {
    static List rows = new LinkedList();
    int maxOptLen = 0;
    int maxObjLen = 0;
    int maxCostLen = 0;
    int maxOptimizer = 0;

    Plan() {
    }

    void addRow(Row row) {
        rows.add(row);
        this.maxOptLen = Utils.max(this.maxOptLen, row.optlen);
        this.maxObjLen = Utils.max(this.maxObjLen, row.objlen);
        this.maxCostLen = Utils.max(this.maxCostLen, row.costlen);
    }

    void reset() {
        rows.clear();
        this.maxOptLen = 0;
        this.maxObjLen = 0;
        this.maxCostLen = 0;
        this.maxOptimizer = 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(128);
        Row row = null;
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            row = (Row)rows.get(i);
            buff.append(row.option);
            buff.append(Utils.rpad(this.maxOptLen - row.optlen));
            buff.append('\t');
            buff.append(row.objname);
            buff.append(Utils.rpad(this.maxObjLen - row.objlen));
            buff.append('\t');
            buff.append(row.cost);
            buff.append(Utils.rpad(this.maxCostLen - row.costlen));
            buff.append('\t');
            buff.append(row.optimizer);
            buff.append('\n');
        }
        return buff.toString();
    }
}

