/*
 * Decompiled with CFR 0.152.
 */
package com.trs.database.util;

import com.trs.infra.util.store.FileService;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;

public class IndexDDLMaker {
    private static final String DB_CONF = "/database.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PrintStream oldOut = System.out;
        try {
            InputStream ins = null;
            if (args.length == 0) {
                Class<IndexDDLMaker> clazz = IndexDDLMaker.class;
                ins = clazz.getResourceAsStream(DB_CONF);
                if (ins == null) {
                    ins = clazz.getResourceAsStream(DB_CONF.substring(1));
                }
            } else {
                ins = new FileService(args[0]).getInputStream();
            }
            if (args.length > 1) {
                try {
                    System.setOut(new PrintStream(new FileOutputStream(args[1], true)));
                }
                catch (Exception clazz) {
                    // empty catch block
                }
            }
            Properties props = new Properties();
            try {
                props.load(ins);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
            }
            String user = props.getProperty("sql.dbuser");
            String pwd = props.getProperty("sql.dbpwd");
            String url = props.getProperty("sql.dburl");
            String driver = props.getProperty("sql.dbdriver");
            Class.forName(driver);
            Connection conn = DriverManager.getConnection(url, user, pwd);
            String sql = "select name from sysobjects where upper(name) like '%WCM%' and xtype='U' order by name asc";
            String tableNamePattern = props.getProperty("sql.tableNamePattern");
            if (tableNamePattern != null) {
                sql = sql.replaceAll("WCM", tableNamePattern.toUpperCase());
            }
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery(sql);
            CallableStatement callableStmt = conn.prepareCall("sp_helpindex ?");
            ResultSet temprs = null;
            String tableName = null;
            String indexName = null;
            String indexDesc = null;
            String indexKeys = null;
            String entryKey = null;
            HashSet<String> indexSet = new HashSet<String>(100, 0.2f);
            StringBuffer buff = new StringBuffer(128);
            while (rs.next()) {
                tableName = rs.getString(1).toUpperCase();
                callableStmt.setString(1, tableName);
                try {
                    temprs = callableStmt.executeQuery();
                }
                catch (Exception ex) {
                    continue;
                }
                while (temprs.next()) {
                    int dif;
                    indexName = temprs.getString(1).toUpperCase();
                    indexDesc = temprs.getString(2).toUpperCase();
                    indexKeys = temprs.getString(3).toUpperCase();
                    entryKey = tableName + "(" + indexKeys + ")";
                    if (indexSet.contains(entryKey)) continue;
                    indexSet.add(entryKey);
                    if (indexDesc.indexOf("PRIMARY KEY") != -1) continue;
                    buff.setLength(0);
                    buff.append("create ");
                    if (indexDesc.indexOf("UNIQUE") != -1) {
                        buff.append("UNIQUE ");
                    }
                    if (indexDesc.indexOf("NONCLUSTERED") == -1 && indexDesc.indexOf("CLUSTERED") != -1) {
                        buff.append("CLUSTERED ");
                    }
                    buff.append("index ");
                    if (!indexName.startsWith("IX_")) {
                        indexName = "IX_" + indexName;
                    }
                    if ((dif = indexName.length() - 30) >= 10) {
                        indexName = indexName.substring(0, 28) + dif;
                    } else if (dif > 0) {
                        indexName = indexName.substring(0, 29) + dif;
                    }
                    buff.append(indexName);
                    buff.append(" on ").append(tableName);
                    buff.append('(');
                    indexKeys = indexKeys.replaceAll("\\(-\\)", " desc");
                    buff.append(indexKeys);
                    buff.append(')');
                    buff.append(';');
                    buff.append('\n');
                    System.out.println(buff.toString().toUpperCase());
                }
                temprs.close();
            }
            rs.close();
            stmt.close();
            callableStmt.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                System.setOut(oldOut);
            }
            catch (Exception exception) {}
        }
    }
}

