/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.infoview.db.LetterConvertor;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.controler.JSPRequestProcessor;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class WXAccountGroupServiceProvider
implements ISelfDefinedServiceProvider,
IQueryServiceProvider {
    private static Logger logger = Logger.getLogger(WXAccountGroupServiceProvider.class);
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");

    private Channel findById(int nGroupId) throws Throwable {
        Channel currChannel = Channel.findById(nGroupId);
        return currChannel;
    }

    @Override
    public Object query(MethodContext _methodContext) throws Throwable {
        User currUser = this.getLoginUser();
        int nGroupId = _methodContext.getValue("groupId", -1);
        List<Channel> childChannel = null;
        if (nGroupId < 0 || this.findById(nGroupId) == null) {
            nGroupId = Integer.parseInt(ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", ""));
            WebSite webSite = WebSite.findById(nGroupId);
            childChannel = webSite.getAllChildren(currUser);
        } else {
            if (!this.isWXWebSiteChannel(nGroupId)) {
                return null;
            }
            Channel groupChannel = Channel.findById(nGroupId);
            childChannel = groupChannel.getAllChildren(currUser);
        }
        return childChannel;
    }

    public int saveGroup(MethodContext _methodContext) throws WCMException {
        String sGroupName = _methodContext.getValue("groupName");
        int parentGroupId = _methodContext.getValue("parentGroupId", -1);
        if (!this.isWXWebSiteChannel(parentGroupId) && parentGroupId > 0) {
            return -1;
        }
        User loginUser = this.getLoginUser();
        Channel oChannel = new Channel();
        INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
        int siteId = this.m_WeChatMgr.getWXSite().getId();
        Channel tempChannel = Channel.findByName(siteId, sGroupName);
        if (tempChannel != null) {
            throw new WCMException("\u540d\u79f0\u4e3a[" + sGroupName + "]\u5206\u7ec4\u5df2\u7ecf\u5b58\u5728!");
        }
        oChannel.setName(sGroupName);
        oChannel.setDesc(sGroupName);
        if (parentGroupId < 0) {
            oChannel.setParent(0);
        } else {
            oChannel.setParent(parentGroupId);
        }
        String wxSiteIds = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
        int nWXSiteId = 0;
        nWXSiteId = CMyString.isEmpty((String)wxSiteIds) ? this.m_WeChatMgr.importWXWebSite() : Integer.parseInt(wxSiteIds);
        BaseChannel oHost4Right = Channel.findById(parentGroupId);
        if (oHost4Right == null) {
            oHost4Right = WebSite.findById(nWXSiteId);
        }
        if (!this.m_WeChatMgr.isWXManager(loginUser) && !AuthServer.hasRight(loginUser, (CMSObj)oHost4Right, 11)) {
            throw new WCMException("\u60a8[" + loginUser + "\u6ca1\u6709\u6743\u9650\u5728\u5bf9\u8c61[" + oHost4Right + "]\u4e0a\u521b\u5efa\u5206\u7ec4");
        }
        oChannel.setSite(WebSite.findById(nWXSiteId));
        oChannel.setCanPub(true);
        oChannel.save(loginUser);
        FolderPublishConfig pubConfig = FolderPublishConfig.createNewInstance();
        WCMFilter filter = new WCMFilter("", "FolderType=? and FolderId in(select ChannelId from WCMChannel where SiteId=?)", "");
        filter.addSearchValues(101);
        filter.addSearchValues(nWXSiteId);
        String sDataPath = m_oNameGenerator.generate(pubConfig, "DataPath", LetterConvertor.convertToFirstLetter(sGroupName, false, 30), filter);
        pubConfig.setFolder(101, oChannel.getId());
        pubConfig.setDataPath(sDataPath);
        pubConfig.save(loginUser);
        return oChannel.getId();
    }

    public void removeGroup(MethodContext _methodContext) throws WCMException {
        int groupId = _methodContext.getValue("groupId", -1);
        try {
            if (!this.isWXWebSiteChannel(groupId) || groupId < 0) {
                return;
            }
            HashMap<String, Constable> parameters = new HashMap<String, Constable>();
            JSPRequestProcessor processor = new JSPRequestProcessor();
            parameters.put("OBJECTIDS", Integer.valueOf(groupId));
            parameters.put("DROP", Boolean.valueOf(true));
            processor.excute("wcm6_channel", "delete", parameters);
        }
        catch (Throwable e) {
            throw new WCMException("\u5220\u9664\u516c\u4f17\u53f7\u5206\u7ec4\u5931\u8d25\uff01", e);
        }
    }

    public void updateGroup(MethodContext _methodContext) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        String sGroupName = _methodContext.getValue("groupName");
        String sGroupDesc = _methodContext.getValue("groupDesc");
        int parentGroupId = _methodContext.getValue("parentGroupId", -1);
        int groupId = _methodContext.getValue("groupId", -1);
        try {
            Channel currChannel = this.findById(groupId);
            if (currChannel == null) {
                return;
            }
            currChannel.setName(sGroupName);
            currChannel.setDesc(sGroupDesc);
            if (AuthServer.hasRight(currUser, (CMSObj)currChannel, 13)) {
                currChannel.update();
            }
            if (currChannel.getParentId() == parentGroupId) {
                return;
            }
            HashMap<String, Integer> parameters = new HashMap<String, Integer>();
            JSPRequestProcessor processor = new JSPRequestProcessor();
            if (parentGroupId < 0) {
                parameters.put("SRCCHANNELIDS", groupId);
                String sWXWebSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
                int wxWebSiteId = Integer.parseInt(sWXWebSiteId);
                parameters.put("DSTSITEID", wxWebSiteId);
                processor.excute("wcm6_channel", "moveAsChild", parameters);
            } else {
                if (!this.isWXWebSiteChannel(parentGroupId)) {
                    return;
                }
                parameters.put("SRCCHANNELIDS", groupId);
                parameters.put("DSTCHANNELID", parentGroupId);
                processor.excute("wcm6_channel", "moveAsChild", parameters);
            }
        }
        catch (Throwable e) {
            throw new WCMException("\u66f4\u65b0\u516c\u4f17\u53f7\u5206\u7ec4\u5931\u8d25\uff01", e);
        }
    }

    private boolean isWXWebSiteChannel(int channelId) {
        try {
            String sWXWebSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "0");
            int wxWebSiteId = Integer.parseInt(sWXWebSiteId);
            Channel wxChannel = this.findById(channelId);
            if (wxChannel == null) {
                return false;
            }
            if (wxChannel.getSiteId() == wxWebSiteId) {
                return true;
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    public String showGroups(MethodContext _methodContext) throws WCMException {
        String sWXWebSite = _methodContext.getValue("siteid");
        if (CMyString.isEmpty((String)sWXWebSite)) {
            sWXWebSite = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
        }
        int nWXWebSite = Integer.parseInt(sWXWebSite);
        StringBuffer bJson = new StringBuffer();
        String sWXWebSiteId = null;
        if (nWXWebSite < 0) {
            try {
                sWXWebSiteId = ConfigServer.getServer().getSysConfigValue("WX_SITE_ID", "");
                nWXWebSite = Integer.parseInt(sWXWebSiteId);
            }
            catch (WCMException e) {
                throw new RuntimeException("\u83b7\u53d6\u5fae\u4fe1\u7ad9\u70b9\u51fa\u9519\uff01", e);
            }
        }
        WebSite webSite = WebSite.findById(nWXWebSite);
        bJson.append("{\"root\":[");
        List<Channel> childChannel = webSite.getAllChildren(this.getLoginUser());
        for (int i = childChannel.size() - 1; i >= 0; --i) {
            Channel channel = childChannel.get(i);
            int nRightIndex = 13;
            boolean falg = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, nRightIndex);
            if (falg) continue;
            childChannel.remove(i);
        }
        this.traverse(childChannel, bJson);
        String wechatUrl = ConfigServer.createInstance().getSysConfigValue("WECHAT_URL", "");
        bJson.append("],\"wechatUrl\":\"" + wechatUrl + "\"}");
        return bJson.toString();
    }

    private StringBuffer traverse(List channels, StringBuffer bJson) throws WCMException {
        User currUser = this.getLoginUser();
        if (channels == null || channels.size() <= 0) {
            return null;
        }
        for (int i = 0; i < channels.size(); ++i) {
            Channel channel = (Channel)channels.get(i);
            if (this.m_WeChatMgr.isWXAccountChannel(channel)) continue;
            bJson.append("{\"data-nodeName\": \"").append(channel.getDesc()).append("\" ,\"nodeId\": \"").append(channel.getId()).append("\" ,\"order\": \"").append(channel.getOrder()).append("\"");
            try {
                List<Channel> grandChildChannel = channel.getAllChildren(currUser);
                for (int j = grandChildChannel.size() - 1; j >= 0; --j) {
                    Channel tempChannel = grandChildChannel.get(j);
                    int nRightIndex = 13;
                    boolean falg = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, nRightIndex);
                    if (falg) continue;
                    grandChildChannel.remove(j);
                }
                if (grandChildChannel != null && grandChildChannel.size() > 0) {
                    bJson.append(",\"childNodes\":[");
                    this.traverse(grandChildChannel, bJson);
                    bJson.append("]");
                }
                bJson.append("},");
                continue;
            }
            catch (WCMException e) {
                throw new RuntimeException("\u904d\u5386\u5fae\u4fe1\u7ad9\u70b9\u5206\u7ec4\u51fa\u9519\uff01", e);
            }
        }
        if (bJson.charAt(bJson.length() - 1) == ',') {
            bJson.deleteCharAt(bJson.length() - 1);
        }
        return bJson;
    }
}

