/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wechat.listener;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wechat.IWeChatMgr;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import common.Logger;
import java.util.Iterator;

public class ChannelLCListener4WeChatMenu
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static final Logger log = Logger.getLogger(ChannelLCListener4WeChatMenu.class);
    private IWeChatMgr m_WeChatMgr = (IWeChatMgr)DreamFactory.createObjectById("IWeChatMgr");
    private final int iAddMode = 0;
    private final int iModifyMode = 1;

    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        log.debug((Object)"on modified");
        if (!this.isWxsubMenu(objAdded)) {
            return;
        }
        Channel oChannel = (Channel)objAdded;
        log.debug((Object)("\u53d1\u5e03\u5fae\u4fe1\u81ea\u5b9a\u4e49\u83dc\u5355\u680f\u76ee" + oChannel.getName()));
        this.setChannelMetaViewAndTempalte(oChannel, 0);
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        if (!this.isWxsubMenu(objModified)) {
            return;
        }
        Iterator<String> oIterator = objModified.getNewProperties().keySet().iterator();
        log.debug((Object)"all changed properites");
        while (oIterator.hasNext()) {
            String sKey = oIterator.next();
            log.debug((Object)sKey);
            if (!"METASYNFIELDS".equalsIgnoreCase(sKey)) continue;
            return;
        }
        if (objModified.isChangeProperty("MetaSynFields")) {
            return;
        }
        if (objModified.isChangeProperty("METASYNFIELDS")) {
            return;
        }
        if (objModified.isChangeProperty("metasynfields")) {
            return;
        }
        log.debug((Object)"on modified");
        Channel oChannel = (Channel)objModified;
        if (oChannel.getStatus() >= 0) {
            if (objModified.isChangeProperty("chnlType") || objModified.isChangeProperty("attribute")) {
                this.setChannelMetaViewAndTempalte(oChannel, 1);
            }
            log.debug((Object)("\u53d1\u5e03\u5fae\u4fe1\u81ea\u5b9a\u4e49\u83dc\u5355\u680f\u76ee" + oChannel.getName()));
        }
        this.publishWXCustomMenu(oChannel);
    }

    private boolean isWxsubMenu(BaseObj obj) throws WCMException {
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel oChannel = (Channel)obj;
        log.debug((Object)("\u4fee\u6539\u7684\u680f\u76ee\u662f" + oChannel.getName()));
        WebSite site = oChannel.getSite();
        if (!this.m_WeChatMgr.isWXSite(site)) {
            return false;
        }
        return this.m_WeChatMgr.isWXCustomSubMenu(oChannel);
    }

    private void publishWXCustomMenu(Channel oChannel) throws WCMException {
        while (oChannel != null) {
            if (this.m_WeChatMgr.isWXCustomMenu(oChannel)) {
                IPublishFolder oFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(oChannel);
                PublishServer.getInstance().publishFolder(oFolder, 8);
                break;
            }
            oChannel = oChannel.getParent();
        }
    }

    private void setChannelMetaViewAndTempalte(Channel oChannel, int iType) throws WCMException {
        String sMenuType = null;
        if (iType == 0) {
            sMenuType = oChannel.getAttributeValue("WXMenuChnlType");
        } else if (iType == 1) {
            sMenuType = oChannel.getNewAttributeValue("WXMenuChnlType");
        }
        if ("WB".equalsIgnoreCase(sMenuType)) {
            this.setWBMetaViewAndTemplate(oChannel);
        } else if (oChannel.getType() == 0) {
            this.setTWMetaViewAndTempalte(oChannel);
        }
    }

    private void setTWMetaViewAndTempalte(Channel oChannel) throws WCMException {
        this.m_WeChatMgr.setMetaView(oChannel, "\u5fae\u4fe1\u56fe\u6587");
        this.m_WeChatMgr.setTemplate(oChannel, "\u5fae\u4fe1\u56fe\u6587\u7ec6\u89c8");
        this.m_WeChatMgr.setTemplate(oChannel, "\u5fae\u4fe1\u56fe\u6587\u6982\u89c8");
    }

    private void setWBMetaViewAndTemplate(Channel oChannel) throws WCMException {
        this.m_WeChatMgr.setMetaView(oChannel, "\u5fae\u4fe1\u6587\u672c");
        this.m_WeChatMgr.setTemplate(oChannel, "\u5fae\u4fe1\u6587\u672c\u7ec6\u89c8");
        this.m_WeChatMgr.setTemplate(oChannel, "\u5fae\u4fe1\u6587\u672c\u6982\u89c8");
    }
}

