/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.wcmx.media;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.calendar.Events;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfo;
import com.trs.components.wcm.wcmx.media.MediaRemindedInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class MediaRemindedAgent {
    private Hashtable m_hMediaUsers;
    private Hashtable m_hMediaFreq;
    private Hashtable m_hCurrMediaNewsCount;
    private boolean IS_DEBUG = true;
    private static MediaRemindedAgent m_aSingleInstance = null;

    public MediaRemindedAgent() {
        try {
            this.init();
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label1", "\u521d\u59cb\u5316\u5931\u8d25\uff01"));
            ex.printStackTrace();
        }
    }

    public static synchronized MediaRemindedAgent getInstance() {
        if (m_aSingleInstance == null) {
            m_aSingleInstance = new MediaRemindedAgent();
        }
        return m_aSingleInstance;
    }

    public Sources getSourcesRemided(User _currUser) throws Exception {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label2", "\u6307\u5b9a\u7684\u7528\u6237\u6709\u8bef\uff01(MediaRemindedAgent.getSourcesRemided)"));
        }
        String sWhere = "XWCMMEDIAREMINDEDINFO.UserId=" + _currUser.getId();
        WCMFilter newFilter = new WCMFilter("XWCMMEDIAREMINDEDINFO", sWhere, "", "SOURCEID");
        try {
            Sources aSources = new Sources(_currUser);
            aSources.open(newFilter);
            return aSources;
        }
        catch (Exception ex) {
            System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label3", ":\u67e5\u8be2\u7528\u6237[") + _currUser.getName() + "][" + _currUser.getId() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label4", "]\u5b9a\u5236\u7684\u5a92\u4f53\u63d0\u9192\u5931\u8d25\uff01"));
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label5", "\u67e5\u8be2\u7684\u8bed\u53e5\u4e3a[") + newFilter.toSQL() + "]");
            ex.printStackTrace();
            throw new WCMException(1100, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label6", "\u67e5\u8be2\u7528\u6237[") + _currUser.getName() + "][" + _currUser.getId() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label4", "]\u5b9a\u5236\u7684\u5a92\u4f53\u63d0\u9192\u5931\u8d25\uff01"), ex);
        }
    }

    public int getFreqReminded(int _nUserId) throws Exception {
        if (this.m_hMediaFreq == null) {
            return -2;
        }
        Integer iFreq = (Integer)this.m_hMediaFreq.get(new Integer(_nUserId));
        return iFreq == null ? -1 : iFreq;
    }

    public void setFreqReminded(int _nUserId, int _nFreq) {
        if (this.m_hMediaFreq == null) {
            return;
        }
        this.m_hMediaFreq.put(new Integer(_nUserId), new Integer(_nFreq));
    }

    public synchronized void init() throws Exception {
        try {
            System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label7", ":\u5f00\u59cb\u521d\u59cb\u5316\u5a92\u4f53\u63d0\u9192\u7684\u7f13\u51b2\u533a\uff01"));
            if (this.m_hMediaFreq != null) {
                this.m_hMediaFreq.clear();
            } else {
                this.m_hMediaFreq = new Hashtable();
            }
            if (this.m_hMediaUsers != null) {
                this.m_hMediaUsers.clear();
            } else {
                this.m_hMediaUsers = new Hashtable();
            }
            if (this.m_hCurrMediaNewsCount != null) {
                this.m_hCurrMediaNewsCount.clear();
            } else {
                this.m_hCurrMediaNewsCount = new Hashtable();
            }
            MediaRemindedInfos aMediaRemindedInfos = new MediaRemindedInfos(User.getSystem());
            aMediaRemindedInfos.open(null);
            for (int i = 0; i < aMediaRemindedInfos.size(); ++i) {
                this.putMediaRemindedInfoInCache((MediaRemindedInfo)aMediaRemindedInfos.getAt(i));
            }
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label8", "\u521d\u59cb\u5316\u5a92\u4f53\u9891\u7387\u5931\u8d25\uff01(MediaRemindedAgent.init)"), ex);
        }
        System.out.println(new Date() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label9", ":\u521d\u59cb\u5316\u5a92\u4f53\u63d0\u9192\u7684\u7f13\u51b2\u533a\u5b8c\u6210\uff01"));
    }

    public void putMediaRemindedInfoInCache(MediaRemindedInfo _currInfo) {
        Integer iUserId = new Integer(_currInfo.getUserID());
        this.setFreqReminded(_currInfo.getUserID(), _currInfo.getFreqReminded());
        Integer iSourceId = new Integer(_currInfo.getSourceId());
        Vector<Integer> vTemp = (Vector<Integer>)this.m_hMediaUsers.get(iSourceId);
        if (vTemp == null) {
            vTemp = new Vector<Integer>();
            vTemp.add(iUserId);
            this.m_hMediaUsers.put(iSourceId, vTemp);
        } else if (vTemp.indexOf(iUserId) < 0) {
            vTemp.add(iUserId);
        }
        this.setCurrMediaCount(_currInfo.getSourceId(), _currInfo.getUserID(), 0);
    }

    public Users getUsersByMediaReminded(int _nSourceId) throws Exception {
        Users aUsers = new Users(User.getSystem());
        Vector vUsers = (Vector)this.m_hMediaUsers.get(new Integer(_nSourceId));
        if (vUsers == null) {
            return aUsers;
        }
        for (int i = 0; i < vUsers.size(); ++i) {
            User aUser = User.findById((Integer)vUsers.get(i));
            if (aUser == null) continue;
            aUsers.addElement(aUser);
        }
        return aUsers;
    }

    public int getCurrMediaCount(int _nSourceId, int _nUserId) throws Exception {
        String sKey = _nUserId + "_" + _nSourceId;
        Integer iCount = (Integer)this.m_hCurrMediaNewsCount.get(sKey);
        if (iCount == null) {
            return -1;
        }
        return iCount;
    }

    public void setCurrMediaCount(int _nSourceId, int _nUserId, int _nCount) {
        String sKey = _nUserId + "_" + _nSourceId;
        this.m_hCurrMediaNewsCount.put(sKey, new Integer(_nCount));
    }

    public void removeMediaRemindedInfoFromCache(int _nUserId, int _nSourceId) {
        Integer iUserId = new Integer(_nUserId);
        Integer iSourceId = new Integer(_nSourceId);
        Vector vTemp = (Vector)this.m_hMediaUsers.get(iSourceId);
        if (vTemp != null) {
            vTemp.remove(iUserId);
        }
        String sKey = _nUserId + "_" + _nSourceId;
        this.m_hCurrMediaNewsCount.remove(sKey);
    }

    public void updateMediaRemindedCache(MediaRemindedInfo _aInfo) {
        this.setFreqReminded(_aInfo.getUserID(), _aInfo.getFreqReminded());
    }

    public void addMediaReminded(int _nSourceId) throws Exception {
        Vector vUsers = (Vector)this.m_hMediaUsers.get(new Integer(_nSourceId));
        if (vUsers == null) {
            return;
        }
        for (int i = 0; i < vUsers.size(); ++i) {
            int nUserId = (Integer)vUsers.get(i);
            int nFreq = this.getFreqReminded(nUserId);
            if (nFreq < 0) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label10", "\u7528\u6237[") + nUserId + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label11", "]\u6ca1\u6709\u8bbe\u5b9a\u6307\u5b9a\u5a92\u4f53[") + _nSourceId + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label12", "]\u7684\u63d0\u9192\u9891\u7387\uff01"));
                continue;
            }
            int nCurrCount = this.getCurrMediaCount(_nSourceId, nUserId);
            if (nCurrCount < 0) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label10", "\u7528\u6237[") + nUserId + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label13", "]\u6ca1\u6709\u5728\u6307\u5b9a\u5a92\u4f53[") + _nSourceId + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label14", "]\u6ca1\u6709\u79ef\u7d2f\u7684\u6761\u6570\uff01"));
                continue;
            }
            if (nCurrCount >= nFreq - 1) {
                this.sendRemindMessage(_nSourceId, nUserId);
                this.setCurrMediaCount(_nSourceId, nUserId, 0);
                continue;
            }
            this.setCurrMediaCount(_nSourceId, nUserId, nCurrCount + 1);
        }
    }

    public void sendRemindMessage(int _nSourceId, int _nUserId) throws Exception {
        Source aSource = Source.findById(_nSourceId);
        if (aSource == null) {
            return;
        }
        User aUser = User.findById(_nUserId);
        if (aUser == null) {
            return;
        }
        String sMsg = I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label15", "\u5a92\u4f53\u3010") + aSource.getName() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label16", "\u3011\u6709\u3010") + this.getFreqReminded(_nUserId) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label17", "\u3011\u7bc7\u6587\u6863\u9700\u8981\u5904\u7406\uff01");
        if (this.IS_DEBUG) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label18", "\u7ed9\u7528\u6237\u3010") + aUser.getName() + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label19", "\u3011\u53d1\u9001\u6d88\u606f\uff01"));
        }
        if (this.IS_DEBUG) {
            System.out.println(sMsg);
        }
        Events aEvents = new Events(User.getSystem());
        Event newEvent = (Event)aEvents.addNew();
        CMyDateTime endTime = CMyDateTime.now();
        endTime.dateAdd(4, 8);
        newEvent.setTitle(sMsg);
        newEvent.setDesc(sMsg);
        newEvent.setStartTime(CMyDateTime.now());
        newEvent.setEndTime(endTime);
        newEvent.setAheadRemindTime(0);
        newEvent.setRemindBy(0, true);
        newEvent.setCrUser(User.getSystem());
        newEvent.setOwner(aUser);
        newEvent.setType(9);
        newEvent.setShare(false);
        aEvents.update();
    }

    public static void main(String[] arArgs) {
        try {
            User aUser;
            int i;
            int i2;
            User currUser = User.findByName("admin");
            MediaRemindedAgent aMediaRemindedAgent = MediaRemindedAgent.getInstance();
            Users aUsers = aMediaRemindedAgent.getUsersByMediaReminded(1);
            System.out.println(aUsers.size());
            for (i2 = 0; i2 < aUsers.size(); ++i2) {
                User aUser2 = (User)aUsers.getAt(i2);
                if (aUser2 == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + aUser2.getName());
            }
            for (i2 = 0; i2 < 20; ++i2) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label21", "\u6dfb\u52a0\u4e86\u7b2c[") + (i2 + 1) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label22", "]\u7bc7\u6587\u6863\uff01"));
                aMediaRemindedAgent.addMediaReminded(1);
            }
            Sources aSources = aMediaRemindedAgent.getSourcesRemided(currUser);
            System.out.println(aSources.size());
            MediaRemindedInfo currMediaRemindedInfo = MediaRemindedInfo.findByUserAndSrc(currUser, currUser.getId(), 1);
            currMediaRemindedInfo.canEdit(currUser);
            currMediaRemindedInfo.setFreqReminded(5);
            currMediaRemindedInfo.update(currUser);
            System.out.println(aMediaRemindedAgent.getFreqReminded(currUser.getId()));
            aUsers = aMediaRemindedAgent.getUsersByMediaReminded(1);
            System.out.println(aUsers.size());
            for (i = 0; i < aUsers.size(); ++i) {
                aUser = (User)aUsers.getAt(i);
                if (aUser == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + aUser.getName());
            }
            aUsers = aMediaRemindedAgent.getUsersByMediaReminded(2);
            System.out.println(aUsers.size());
            for (i = 0; i < aUsers.size(); ++i) {
                aUser = (User)aUsers.getAt(i);
                if (aUser == null) continue;
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label20", "\u7528\u6237:") + aUser.getName());
            }
            for (i = 0; i < 20; ++i) {
                System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label21", "\u6dfb\u52a0\u4e86\u7b2c[") + (i + 1) + I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label22", "]\u7bc7\u6587\u6863\uff01"));
                int nSourceId = 1;
                aMediaRemindedAgent.addMediaReminded(nSourceId);
            }
        }
        catch (Exception ex) {
            System.out.println(I18NMessage.get(MediaRemindedAgent.class, "MediaRemindedAgent.label23", "\u6d4b\u8bd5\u4ee3\u7801\u53d1\u751f\u5f02\u5e38\uff01"));
            ex.printStackTrace();
        }
    }
}

