/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version.parser;

import com.trs.cms.ContextHelper;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.ObjAndConfigHandler;
import com.trs.components.wcm.version.config.ObjectVersionConfig;
import com.trs.components.wcm.version.config.RelationObjectVersionConfig;
import com.trs.components.wcm.version.parser.ObjectForElementConverter;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ObjectForXmlCompleteConverter {
    public static ObjAndConfigHandler parseObjData(CMSObj _CMSObj2, ObjectVersionConfig _oConfig) throws WCMException {
        ObjAndConfigHandler handler = new ObjAndConfigHandler();
        Document document = DocumentHelper.createDocument();
        Element oRootElement = DocumentHelper.createElement((String)_CMSObj2.getDbTableName());
        oRootElement.addAttribute("TYPE", _CMSObj2.getClass().getName());
        ObjectForElementConverter.parseCMSObjToElement(oRootElement, _CMSObj2, _oConfig.getExcludeFields());
        List<Map.Entry<String, Object>> hRelationObjConfig = _oConfig.getSortRelations();
        if (hRelationObjConfig == null || hRelationObjConfig.size() == 0) {
            document.add(oRootElement);
            handler.setXmlData(document.asXML());
            return handler;
        }
        Element aRootElement = oRootElement.addElement("RELATION-OBJECTS");
        HashMap<String, CMSBaseObjs> hTempObjsCache = new HashMap<String, CMSBaseObjs>();
        for (int i = 0; i < hRelationObjConfig.size(); ++i) {
            String sKey = hRelationObjConfig.get(i).getKey();
            RelationObjectVersionConfig relationObjectConfig = (RelationObjectVersionConfig)hRelationObjConfig.get(i).getValue();
            if (CMyString.isEmpty(sKey) || relationObjectConfig == null) continue;
            String[] sKeys = sKey.split("\\.");
            WCMFilter afilter = null;
            if (sKeys.length == 1) {
                afilter = new WCMFilter("", relationObjectConfig.getRelationkey().trim().toUpperCase() + "=" + _CMSObj2.getPropertyAsString(sKeys[0], ""), "");
            } else if (sKeys.length > 1) {
                if (sKeys[sKeys.length - 2].equals(_oConfig.getId())) {
                    afilter = new WCMFilter("", relationObjectConfig.getRelationkey().trim().toUpperCase() + "=" + _CMSObj2.getPropertyAsString(sKeys[sKeys.length - 1], ""), "");
                } else {
                    CMSBaseObjs aCMSBaseObjs = (CMSBaseObjs)hTempObjsCache.get(sKeys[sKeys.length - 2]);
                    if (aCMSBaseObjs == null || aCMSBaseObjs.size() == 0) continue;
                    CMSObj aCMSObj = null;
                    String sWhere = "";
                    for (int j = 0; j < aCMSBaseObjs.size(); ++j) {
                        aCMSObj = (CMSObj)aCMSBaseObjs.getAt(j);
                        if (j != 0) {
                            sWhere = sWhere + " or ";
                        }
                        sWhere = sWhere + relationObjectConfig.getRelationkey().trim().toUpperCase() + "=" + aCMSObj.getPropertyAsString(sKeys[sKeys.length - 1], "");
                    }
                    afilter = new WCMFilter("", sWhere, "");
                }
            }
            String sClassName = relationObjectConfig.getClassname();
            CMSBaseObjs relationObjs = CMSBaseObjs.openWCMObjs(ContextHelper.getLoginUser(), sClassName, afilter);
            Element eleTemp = null;
            if (relationObjs.size() == 0) {
                String sIDFieldName;
                Class sClass = CMSBaseObjs.createInstance(ContextHelper.getLoginUser(), sClassName).getElementClass();
                eleTemp = aRootElement.addElement("RELATION-OBJECT");
                eleTemp.addAttribute("TYPE", sClass.getName());
                try {
                    sIDFieldName = (String)sClass.getMethod("getIdFieldName", null).invoke(sClass.newInstance(), null);
                }
                catch (Exception e) {
                    throw new WCMException("\u83b7\u53d6\u5173\u8054\u5bf9\u8c61\u7684\u6570\u636e\u5e93ID\u51fa\u73b0\u5f02\u5e38", e);
                }
                ObjectForElementConverter.parseNULLObjPropertyToElement(eleTemp, sIDFieldName);
            } else {
                for (int k = 0; k < relationObjs.size(); ++k) {
                    eleTemp = aRootElement.addElement("RELATION-OBJECT");
                    CMSObj relationTempObj = (CMSObj)relationObjs.getAt(k);
                    eleTemp.addAttribute("TYPE", relationTempObj.getClassName(true));
                    ObjectForElementConverter.parseCMSObjToElement(eleTemp, relationTempObj, relationObjectConfig.getExcludeFields());
                    handler.getRelationObjs().add(relationTempObj);
                }
            }
            hTempObjsCache.put(relationObjectConfig.getId(), relationObjs);
        }
        document.add(oRootElement);
        handler.setXmlData(document.asXML());
        return handler;
    }

    public static Map<CMSObj, List<CMSObj>> parseXmlData(String _sXml) throws WCMException, DocumentException {
        ArrayList<CMSObj> cmsObjList = new ArrayList<CMSObj>();
        HashMap<CMSObj, List<CMSObj>> hMap = new HashMap<CMSObj, List<CMSObj>>();
        Document document = DocumentHelper.parseText((String)_sXml);
        Element root = document.getRootElement();
        String className = root.attributeValue("TYPE");
        CMSObj cmsObj = (CMSObj)CMSObj.createNewInstance(className);
        ObjectForElementConverter.parseElementToCMSObj(root, cmsObj);
        Iterator it = root.elementIterator();
        while (it.hasNext()) {
            Element eleItem = (Element)it.next();
            String sKey = eleItem.getName();
            if (!sKey.equals("RELATION-OBJECTS")) continue;
            Iterator tempIt = eleItem.elementIterator();
            while (tempIt.hasNext()) {
                Element tempEle = (Element)tempIt.next();
                if (!tempEle.getName().equals("RELATION-OBJECT")) continue;
                String relationObjName = tempEle.attributeValue("TYPE");
                CMSObj relationObj = (CMSObj)CMSObj.createNewInstance(relationObjName);
                ObjectForElementConverter.parseElementToCMSObj(tempEle, relationObj);
                cmsObjList.add(relationObj);
            }
        }
        hMap.put(cmsObj, cmsObjList);
        return hMap;
    }
}

