/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.version;

import com.trs.DreamFactory;
import com.trs.ajaxservice.DocumentBakServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.version.IObjectVersionMgr;
import com.trs.components.wcm.version.ObjectVersion;
import com.trs.components.wcm.version.ObjectVersionMgr;
import com.trs.components.wcm.version.config.ObjectVersionConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.persistent.ObjectTypesFinder;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.Reports;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.lang.reflect.Method;
import java.util.List;

public class ObjectVersionServiceProvider
implements ISelfDefinedServiceProvider,
IQueryServiceProvider {
    private IObjectVersionMgr m_versionMgr = (IObjectVersionMgr)DreamFactory.createObjectById("IObjectVersionMgr");

    public String buildVersion(MethodContext _methodContext) throws WCMException {
        String sObjIds = _methodContext.getValue("ObjIds");
        int nObjType = _methodContext.getValue("ObjType", 0);
        String versionDesc = _methodContext.getValue("versionDesc");
        if (sObjIds == null || nObjType == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        Reports reports = new Reports(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label5", "\u4fdd\u5b58\u7248\u672c"));
        String[] sTempObjIds = sObjIds.split(",");
        for (int i = 0; i < sTempObjIds.length; ++i) {
            int nObjId = Integer.parseInt(sTempObjIds[i]);
            CMSObj cmsObj = this.getCMSObjById(nObjType, nObjId);
            if (cmsObj == null) {
                reports.addFailedReport("\u53c2\u6570\u9519\u8bef", new WCMException("\u4fdd\u5b58\u5bf9\u8c61[id=" + nObjId + I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label10", "]\u7248\u672c\u5931\u8d25\uff01")));
                continue;
            }
            ObjectVersionConfig config = this.getObjectVersionConfig(cmsObj);
            if (!AuthServer.hasRight(this.getLoginUser(), cmsObj, config.getRight())) {
                reports.addFailedReport("\u60a8\u6ca1\u6709\u8be5\u64cd\u4f5c\u6743\u9650", new WCMException("\u4fdd\u5b58\u5bf9\u8c61[id=" + nObjId + I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label10", "]\u7248\u672c\u5931\u8d25\uff01")));
                continue;
            }
            try {
                ObjectVersion objectVersion = this.m_versionMgr.buildVersion(cmsObj, versionDesc);
                reports.addSucessedReport(I18NMessage.get(DocumentBakServiceProvider.class, "DocumentBakServiceProvider.label8", "\u4fdd\u5b58\u5bf9\u8c61[id=") + nObjId + I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label9", "]\u7248\u672c\u6210\u529f\uff01\u7248\u672c\u53f7\u4e3a\uff1a") + objectVersion.getVersionNum());
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label20", "\u4fdd\u5b58\u5bf9\u8c61[id=") + nObjId + I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.label10", "]\u7248\u672c\u5931\u8d25\uff01"), e);
            }
        }
        return reports.toJSONXML();
    }

    public void update(MethodContext _methodContext) throws WCMException {
        int versionId = _methodContext.getValue("ObjectId", 0);
        if (versionId == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersion version = ObjectVersion.findById(versionId);
        if (version == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        CMSObj cmsObj = this.getCMSObjById(version.getObjectType(), version.getObjectId());
        if (cmsObj == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersionConfig config = this.getObjectVersionConfig(cmsObj);
        if (!AuthServer.hasRight(this.getLoginUser(), cmsObj, config.getRight())) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable2", "\u60a8\u6ca1\u6709\u8be5\u5bf9\u8c61\u7684\u64cd\u4f5c\u6743\u9650"));
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        version = (ObjectVersion)WCMAJAXServiceHelper.setWCMObjectProperties(this.getLoginUser(), _methodContext, version, pLogicFields);
        version.update();
    }

    public void recoverVersion(MethodContext _methodContext) throws WCMException {
        int versionId = _methodContext.getValue("VersionId", 0);
        boolean buildCurVersion = _methodContext.getValue("buildCurVersion", false);
        if (versionId == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersion version = ObjectVersion.findById(versionId);
        if (version == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        CMSObj cmsObj = this.getCMSObjById(version.getObjectType(), version.getObjectId());
        if (cmsObj == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersionConfig config = this.getObjectVersionConfig(cmsObj);
        if (!AuthServer.hasRight(this.getLoginUser(), cmsObj, config.getRight())) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable2", "\u60a8\u6ca1\u6709\u8be5\u5bf9\u8c61\u7684\u64cd\u4f5c\u6743\u9650"));
        }
        if (buildCurVersion) {
            this.m_versionMgr.buildVersion(cmsObj, "\u6062\u590d\u7248\u672cv" + version.getVersionNum() + "\u524d\u4fdd\u5b58\u7684\u7248\u672c");
        }
        this.m_versionMgr.recover(version);
    }

    @Override
    public Object query(MethodContext _methodContext) throws WCMException {
        int nObjId = _methodContext.getValue("ObjId", 0);
        int nObjType = _methodContext.getValue("ObjType", 0);
        if (nObjId == 0 || nObjType == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        CMSObj cmsObj = this.getCMSObjById(nObjType, nObjId);
        if (cmsObj == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersionConfig config = this.getObjectVersionConfig(cmsObj);
        if (!AuthServer.hasRight(this.getLoginUser(), cmsObj, config.getRight())) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable2", "\u60a8\u6ca1\u6709\u8be5\u5bf9\u8c61\u7684\u64cd\u4f5c\u6743\u9650"));
        }
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_versionMgr.findObjectVersions(cmsObj, extraFilter);
    }

    public void deleteVersion(MethodContext _methodContext) throws WCMException {
        int versionId = _methodContext.getValue("VersionId", 0);
        if (versionId == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersion version = ObjectVersion.findById(versionId);
        CMSObj cmsObj = this.getCMSObjById(version.getObjectType(), version.getObjectId());
        if (cmsObj == null) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersionConfig config = this.getObjectVersionConfig(cmsObj);
        if (!AuthServer.hasRight(this.getLoginUser(), cmsObj, config.getRight())) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable2", "\u60a8\u6ca1\u6709\u8be5\u5bf9\u8c61\u7684\u64cd\u4f5c\u6743\u9650"));
        }
        this.m_versionMgr.delete(version);
    }

    public Object getCMSObj(MethodContext _methodContext) throws WCMException {
        int versionId = _methodContext.getValue("VersionId", 0);
        if (versionId == 0) {
            throw new WCMException(I18NMessage.get(ObjectVersionServiceProvider.class, "ObjectVersionServiceProvider.lable1", "\u4f20\u9012\u53c2\u6570\u9519\u8bef"));
        }
        ObjectVersion version = ObjectVersion.findById(versionId);
        return this.m_versionMgr.getCMSObjFromVersion(version);
    }

    private ObjectVersionConfig getObjectVersionConfig(CMSObj _CMSObj2) throws WCMException {
        List list = XMLConfigServer.getInstance().getConfigObjects(ObjectVersionConfig.class);
        ObjectVersionConfig config2 = null;
        for (ObjectVersionConfig config2 : list) {
            if (config2 == null || !_CMSObj2.getClassName(true).equals(config2.getClassname())) continue;
            if (!config2.isValid()) {
                throw new WCMException(I18NMessage.get(ObjectVersionMgr.class, "ObjectVersionMgr.label8", "\u8be5\u5bf9\u8c61\u7248\u672c\u7ba1\u7406\u529f\u80fd\u914d\u7f6e\u9519\u8bef"));
            }
            return config2;
        }
        return null;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private CMSObj getCMSObjById(int _nObjType, int _nObjId) throws WCMException {
        CMSObj cmsObj;
        Class currClass = ObjectTypesFinder.findObjectClassByType(_nObjType);
        Method mFindById = null;
        try {
            mFindById = currClass.getMethod("findById", Integer.TYPE);
            cmsObj = (CMSObj)mFindById.invoke(null, _nObjId);
        }
        catch (Exception e) {
            cmsObj = null;
        }
        return cmsObj;
    }
}

