/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.stat.StatFieldMap;
import com.trs.components.wcm.stat.StatFieldMaps;
import com.trs.components.wcm.stat.StatHost;
import com.trs.components.wcm.stat.StatHosts;
import com.trs.components.wcm.stat.StatView;
import com.trs.components.wcm.stat.StatViewRel;
import com.trs.components.wcm.stat.StatViewRels;
import com.trs.components.wcm.stat.StatViews;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.CMyResultSet;
import com.trs.infra.persistent.CMyResultSets;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class StatMgr {
    private static Logger s_logger = Logger.getLogger(StatMgr.class);
    public static final String StatMgrName = "StatMgr";
    private static final String DEF_TEMPDB_ID = "RECID";
    private static final String DEF_STATTIME_FIELD = "STATTIME";
    private static final String START_QUOTE = "[";
    private static final String END_QUOTE = "]";
    private static final String TAG_START_TIME = "$STAT_STARTTIME$";
    private static final String TAG_END_TIME = "$STAT_ENDTIME$";
    private static final String[] DB_NUMBER_TYPE = new String[]{"NUMBER", "INT", "BIGINT", "int", "BIGINT", "BIGINT", "BIGINT"};
    private static final String[] DB_STRING_TYPE = new String[]{"VARCHAR2", "nvarchar", "VARCHAR", "nvarchar", "VARCHAR", "VARCHAR", "nvarchar"};
    private static final String[] DB_DATETIME_TYPE = new String[]{"DATE", "DATETIME", "TIMESTAMP", "datetime", "TIMESTAMP", "TIMESTAMP", "DATETIME"};
    private static final String ORIGINAL_STARTTIME = "2002-01-01 00:00:00";
    private String m_sOriginalStartTime = null;

    public CMyResultSets getStatResult(String _sqlStat, String _sId) throws WCMException {
        CMyResultSets currResults = new CMyResultSets();
        if (this.emptyString(_sqlStat) || this.emptyString(_sId)) {
            return currResults;
        }
        currResults.open(_sqlStat, _sId);
        return currResults;
    }

    public CMyResultSets getStatResult(int _nStatViewId, CMyDateTime _fromDate, CMyDateTime _toDate, String _sqlWhere, String _sqlOrderBy) throws WCMException {
        StatView currStatView = StatView.findById(_nStatViewId);
        this.assertViewFound(_nStatViewId, currStatView);
        if (!this.isTemplateView(currStatView)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label1", "\u8be5\u7edf\u8ba1\u89c6\u56fe\u4e0d\u662f\u4e00\u4e2a\u6a21\u677f\u89c6\u56fe(\u5f53\u524d\u7c7b\u578b\u4e3a:") + currStatView.getViewType() + I18NMessage.get(StatMgr.class, "StatMgr.label2", "),\u65e0\u6cd5\u7ee7\u7eed\u83b7\u5f97\u7edf\u8ba1\u7ed3\u679c!"));
        }
        String statSQL = this.getStatSql(currStatView, _fromDate, _toDate, _sqlWhere, _sqlOrderBy);
        CMyResultSets statResults = new CMyResultSets();
        statResults.open(statSQL, this.getResultId(currStatView));
        return statResults;
    }

    public StatFieldMaps getViewFields(int _nStatViewId) throws WCMException {
        StatView currStatView = StatView.findById(_nStatViewId);
        this.assertViewFound(_nStatViewId, currStatView);
        return this.getViewFields(currStatView);
    }

    public void generateTodayStat(int _nStatViewId) throws WCMException {
        StatView currStatView = StatView.findById(_nStatViewId);
        this.assertViewFound(_nStatViewId, currStatView);
        if (!this.isTemplateView(currStatView)) {
            return;
        }
        String sSql = "SELECT MAX(RECID) AS ID, MAX(STATTIME) AS LAST FROM " + currStatView.getResultTable();
        CMyResultSets aResults = new CMyResultSets();
        aResults.open(sSql, "ID");
        CMyDateTime dtLastStatTime = this.getLastStatTime(aResults);
        CMyDateTime dtNow = CMyDateTime.now();
        CMyDateTime dtStart = (CMyDateTime)dtNow.clone();
        CMyDateTime dtEnd = (CMyDateTime)dtNow.clone();
        try {
            if (aResults.isEmpty() || dtLastStatTime == null) {
                dtStart.setDateTimeWithString(this.getOriginalStart());
            } else {
                this.deleteDataOfLast(currStatView, dtLastStatTime);
                dtStart = dtLastStatTime;
            }
        }
        catch (CMyException e) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label3", "\u83b7\u53d6\u7edf\u8ba1\u7684\u65f6\u95f4\u6bb5\u51fa\u9519,\u7edf\u8ba1\u5f02\u5e38\u4e2d\u6b62!"), e);
        }
        this.generatePeriodStat(currStatView, dtStart, dtEnd);
    }

    private String getOriginalStart() {
        if (this.m_sOriginalStartTime == null) {
            try {
                String startDate = ConfigServer.getServer().getSysConfigValue("STAT_ORIGINAL_STARTDATE", null);
                startDate = startDate == null ? ORIGINAL_STARTTIME : startDate + " 00:00:01";
                this.m_sOriginalStartTime = startDate;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_sOriginalStartTime;
    }

    private void deleteDataOfLast(StatView view, CMyDateTime lastStatTime) throws WCMException {
        StringBuffer sql = new StringBuffer(64);
        sql.append("delete from ");
        sql.append(view.getResultTable());
        sql.append(" where ").append(DEF_STATTIME_FIELD);
        sql.append("=?");
        DBManager manager = DBManager.getDBManager();
        Connection conn = null;
        Statement pstmt = null;
        try {
            conn = manager.getConnection();
            pstmt = conn.prepareStatement(sql.toString());
            lastStatTime.setTimeWithString("12:00:00", 0);
            pstmt.setTimestamp(1, lastStatTime.toTimestamp());
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(StatMgr.class, "StatMgr.label4", "\u6e05\u7406\u7edf\u8ba1\u6570\u636e\u5931\u8d25!"), e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                manager.freeConnection(conn);
            }
        }
    }

    public CMyResultSets getCurrentStatResult(int _nStatViewId, CMyDateTime _fromDate, CMyDateTime _toDate, String _sqlWhere) throws WCMException {
        StatView statview = StatView.findById(_nStatViewId);
        this.assertViewFound(_nStatViewId, statview);
        if (this.isTemplateView(statview)) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label5", "\u6a21\u677f\u7edf\u8ba1\u89c6\u56fe\u4e0d\u80fd\u8fdb\u884c\u5373\u65f6\u7edf\u8ba1!"));
        }
        String sTemp = this.composeFrom(statview.getViewFrom(), _fromDate, _toDate);
        if (this.emptyString(sTemp)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label6", "\u65e0\u6548\u7684\u7edf\u8ba1\u89c6\u56fe,\u6ca1\u6709\u660e\u786e\u7684\u7edf\u8ba1\u5bf9\u8c61!"));
        }
        String sSQL = "SELECT " + statview.getViewSelect() + " FROM " + sTemp;
        sTemp = this.mergeAnd(statview.getViewWhere(), _sqlWhere);
        if (!this.emptyString(sTemp)) {
            sSQL = sSQL + " WHERE " + sTemp;
        }
        if (!this.emptyString(sTemp = statview.getViewGroupBy())) {
            sSQL = sSQL + " GROUP BY " + sTemp;
        }
        if (!this.emptyString(sTemp = statview.getViewOrderBy())) {
            sSQL = sSQL + " ORDER BY " + sTemp;
        }
        sSQL = this.parseDateTime(sSQL, _fromDate, _toDate);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("current stat,querystat sql:" + sSQL));
        }
        CMyResultSets currResults = new CMyResultSets();
        currResults.open(sSQL, this.getResultId(statview));
        return currResults;
    }

    public StatViews getStatViews(String _sStatHostName, int _nStatViewType, WCMFilter _filter) throws WCMException {
        if (this.emptyString(_sStatHostName)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label7", "\u65e0\u6548\u7684\u7edf\u8ba1\u4e3b\u4f53\u540d\u79f0,\u65e0\u6cd5\u83b7\u5f97\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f!"));
        }
        String sWhere = "STATHOST='" + CMyString.filterForSQL(_sStatHostName) + "'";
        if (_nStatViewType != 0) {
            sWhere = sWhere + " AND VIEWTYPE=" + _nStatViewType;
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        return StatViews.openWCMObjs(this.getLoginUser(), aFilter);
    }

    private String convertSqlValueByType(String _sContent, String _sType) {
        if (this.emptyString(_sType)) {
            return "";
        }
        String sType = _sType.trim().toUpperCase();
        boolean bEmptyContent = this.emptyString(_sContent);
        if ("NUMBER".equals(sType)) {
            if (bEmptyContent) {
                return "0";
            }
            return _sContent;
        }
        if ("STRING".equals(sType)) {
            if (bEmptyContent) {
                return "''";
            }
            return "'" + _sContent + "'";
        }
        if ("DATETIME".equals(sType)) {
            if (bEmptyContent) {
                return "";
            }
            return DBManager.getDBManager().getDBType().sqlDateTime(_sContent, "YYYY-MM-DD HH24:MI:SS");
        }
        return "";
    }

    private String mergeAnd(String _sWhere, String _sNewCondition) {
        if (this.emptyString(_sWhere)) {
            return _sNewCondition;
        }
        if (this.emptyString(_sNewCondition)) {
            return _sWhere;
        }
        return "(" + _sWhere + ") AND (" + _sNewCondition + ")";
    }

    private String getResultId(StatView _statview) throws WCMException {
        StatFieldMap field = this.getTopField(_statview);
        if (field == null) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label8", "\u83b7\u53d6\u7edf\u8ba1\u7ed3\u679cId\u5931\u8d25!"));
        }
        return field.getFieldName();
    }

    private StatFieldMap getTopField(StatView _statview) throws WCMException {
        StatFieldMaps fields = new StatFieldMaps(this.getLoginUser());
        WCMFilter filter = new WCMFilter("", "StatViewId=" + _statview.getId() + " AND FieldTop=1", "");
        filter.setMaxRowNumber(1);
        fields.open(filter);
        if (fields.isEmpty()) {
            return null;
        }
        return (StatFieldMap)fields.getAt(0);
    }

    private CMyDateTime getLastStatTime(CMyResultSets _results) {
        CMyDateTime dt;
        CMyResultSet result = (CMyResultSet)_results.getAt(0);
        if (result != null && !(dt = (CMyDateTime)result.getProperty("LAST")).isNull()) {
            return dt;
        }
        return null;
    }

    private void generatePeriodStat(StatView _statview, CMyDateTime _dtStart, CMyDateTime _dtEnd) throws WCMException {
        try {
            _dtStart.setTimeWithString("00:00:00", 0);
            _dtEnd.setTimeWithString("23:59:59", 0);
            long nDiff = _dtEnd.dateDiff(3, _dtStart) + 1L;
            CMyDateTime dtStat = (CMyDateTime)_dtStart.clone();
            int i = 0;
            while ((long)i < nDiff) {
                this.generateOneStatSets(_statview, dtStat);
                dtStat = dtStat.dateAdd(3, 1);
                ++i;
            }
        }
        catch (CMyException ex) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label9", "\u4ea7\u751f\u7279\u5b9a\u65f6\u95f4\u6bb5\u7684\u7edf\u8ba1\u6570\u636e\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u65e0\u6cd5\u4ea7\u751f\u7edf\u8ba1\u7ed3\u679c\uff01"), ex);
        }
    }

    private void generateOneStatSets(StatView _statview, CMyDateTime _currDate) throws WCMException {
        CMyDateTime dtStart = (CMyDateTime)_currDate.clone();
        CMyDateTime dtEnd = (CMyDateTime)_currDate.clone();
        CMyDateTime dtStat = (CMyDateTime)_currDate.clone();
        try {
            dtStart.setTimeWithString("00:00:00", 0);
            dtEnd.setTimeWithString("23:59:59", 0);
            dtStat.setTimeWithString("12:00:00", 0);
        }
        catch (CMyException ex) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label10", "\u683c\u5f0f\u5316\u7edf\u8ba1\u7684\u76f8\u5173\u65f6\u95f4\u5931\u8d25"), ex);
        }
        List resultsetList = this.getNewResultSetList(_statview, dtStart, dtEnd);
        if (!resultsetList.isEmpty()) {
            this.insertResultIntoDb(_statview, resultsetList, dtStat);
        }
    }

    private void insertResultIntoDb(StatView _statview, List _resultsetList, CMyDateTime _dtStatTime) throws WCMException {
        StatFieldMaps fields = this.getViewFields(_statview);
        if (fields.isEmpty()) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label11", "\u65e0\u6cd5\u83b7\u5f97\u7edf\u8ba1\u89c6\u56fe\u5bf9\u5e94\u7684\u5b57\u6bb5\u5217\u8868!"));
        }
        StringBuffer statSqlBuffer = new StringBuffer("INSERT INTO ");
        statSqlBuffer.append(_statview.getResultTable()).append('(');
        statSqlBuffer.append(DEF_TEMPDB_ID).append(',');
        statSqlBuffer.append(DEF_STATTIME_FIELD);
        for (int i = 0; i < fields.size(); ++i) {
            StatFieldMap field = (StatFieldMap)fields.getAt(i);
            if (field == null) continue;
            statSqlBuffer.append(',').append(field.getFieldName());
        }
        statSqlBuffer.append(')').append(" VALUES (");
        String presql = statSqlBuffer.toString();
        statSqlBuffer.setLength(0);
        String[] insertDataSqls = new String[_resultsetList.size()];
        StringBuffer values = statSqlBuffer;
        int nMaxRecId = this.getMaxRecId(_statview);
        DBManager manager = DBManager.getDBManager();
        String sStatDate = manager.getDBType().sqlDateTime(_dtStatTime.toString(), "YYYY-MM-DD HH24:MI:SS");
        for (int i = 0; i < _resultsetList.size(); ++i) {
            CMyResultSet resultset = (CMyResultSet)_resultsetList.get(i);
            if (resultset == null) continue;
            values.setLength(0);
            values.append(presql);
            values.append(++nMaxRecId).append(',').append(sStatDate);
            for (int j = 0; j < fields.size(); ++j) {
                StatFieldMap field = (StatFieldMap)fields.getAt(j);
                if (field == null) continue;
                String sValue = this.convertSqlValueByType(resultset.getPropertyAsString(field.getFieldName()), field.getFieldType());
                values.append(',').append(sValue);
            }
            values.append(')');
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("debug...sql for insert data:" + statSqlBuffer));
            }
            insertDataSqls[i] = values.toString();
        }
        try {
            manager.sqlExecuteUpdate(insertDataSqls);
        }
        catch (WCMException e) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label12", "\u4fdd\u5b58\u7edf\u8ba1\u7ed3\u679c\u5931\u8d25!"), e);
        }
    }

    private List getNewResultSetList(StatView _currSatView, CMyDateTime _dtStart, CMyDateTime _dtEnd) throws WCMException {
        ArrayList<CMyResultSet> resultsetList = new ArrayList<CMyResultSet>();
        StatViews embededViews = this.getEmbeddedViews(_currSatView);
        if (embededViews.isEmpty()) {
            embededViews.addElement(_currSatView);
        }
        String sResultId = null;
        ArrayList<CMyResultSets> resultsetsList = new ArrayList<CMyResultSets>();
        for (int i = 0; i < embededViews.size(); ++i) {
            StatView statview = (StatView)embededViews.getAt(i);
            if (statview == null) continue;
            if (sResultId == null) {
                sResultId = this.getResultId(statview);
            }
            String sStatSql = this.getStatSql(statview, _dtStart, _dtEnd, "", "");
            CMyResultSets resultsets = new CMyResultSets();
            resultsets.open(sStatSql, this.getResultId(statview));
            resultsetsList.add(resultsets);
        }
        int nResultsetsNum = resultsetsList.size();
        int[] nResultPos = new int[nResultsetsNum];
        while (!this.isEOF(resultsetsList, nResultPos)) {
            int nMinimaxId = this.getMinimaxId(resultsetsList, nResultPos, sResultId);
            CMyResultSet resultset = new CMyResultSet();
            for (int i = 0; i < nResultsetsNum; ++i) {
                CMyResultSet currRecord;
                int nCurrId;
                CMyResultSets currSets = (CMyResultSets)resultsetsList.get(i);
                if (currSets.size() <= nResultPos[i] || (nCurrId = (currRecord = (CMyResultSet)currSets.getAt(nResultPos[i])).getPropertyAsInt(sResultId, 0)) != nMinimaxId) continue;
                StatView embededView = (StatView)embededViews.getAt(i);
                StatFieldMaps fields = this.getViewFields(embededView);
                for (int j = 0; j < fields.size(); ++j) {
                    StatFieldMap field = (StatFieldMap)fields.getAt(j);
                    String sName = field.getFieldName();
                    Object sValue = currRecord.getProperty(sName);
                    if (sValue == null) continue;
                    resultset.setProperty(sName, sValue);
                }
                int n = i;
                nResultPos[n] = nResultPos[n] + 1;
            }
            resultsetList.add(resultset);
        }
        return resultsetList;
    }

    private String getStatSql(StatView _statview, CMyDateTime _dtStart, CMyDateTime _dtEnd, String _sWhere, String _sOrder) throws WCMException {
        String statSQL = this.constructStatSql(_statview, _sWhere, _sOrder);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("the row sql: " + statSQL));
        }
        statSQL = this.parseDateTime(statSQL, _dtStart, _dtEnd);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("the actula sql: " + statSQL));
        }
        return statSQL;
    }

    private String constructStatSql(StatView _statview, String _sWhere, String _sOrder) {
        String sSQL = "SELECT " + _statview.getViewSelect() + " FROM " + _statview.getViewFrom();
        String sTemp = this.mergeAnd(_statview.getViewWhere(), _sWhere);
        if (!this.emptyString(sTemp)) {
            sSQL = sSQL + " WHERE " + sTemp;
        }
        if (!this.emptyString(sTemp = _statview.getViewGroupBy())) {
            sSQL = sSQL + " GROUP BY " + sTemp;
        }
        if (this.emptyString(_sOrder)) {
            _sOrder = _statview.getViewOrderBy();
        }
        if (!this.emptyString(_sOrder)) {
            sSQL = sSQL + " ORDER BY " + _sOrder;
        }
        return sSQL;
    }

    private boolean isEOF(List _currResultList, int[] _nCurrPos) {
        for (int i = 0; i < _currResultList.size(); ++i) {
            if (((CMyResultSets)_currResultList.get(i)).size() <= _nCurrPos[i]) continue;
            return false;
        }
        return true;
    }

    private int getMinimaxId(List _currResultList, int[] _nCurrPos, String _sResultId) {
        int nMinId = 0;
        for (int i = 0; i < _currResultList.size(); ++i) {
            CMyResultSets resultSets = (CMyResultSets)_currResultList.get(i);
            if (resultSets.size() <= _nCurrPos[i]) continue;
            CMyResultSet resultset = (CMyResultSet)resultSets.getAt(_nCurrPos[i]);
            int nCurrId = resultset.getPropertyAsInt(_sResultId, 0);
            if (nMinId == 0) {
                nMinId = nCurrId;
                continue;
            }
            if (nMinId <= nCurrId) continue;
            nMinId = nCurrId;
        }
        return nMinId;
    }

    private StatViews getEmbeddedViews(int _nMainStatViewId) throws WCMException {
        String sWhere = "ViewType = 2";
        sWhere = sWhere + " AND EXISTS( Select * From WCMSTATVIEWREL Where WCMSTATVIEWREL.MainViewID=" + _nMainStatViewId + " AND WCMSTATVIEW.StatViewID = WCMSTATVIEWREL.EmbedViewId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return StatViews.openWCMObjs(this.getLoginUser(), aFilter);
    }

    private int getMaxRecId(StatView _statview) throws WCMException {
        String sTable = _statview.getResultTable();
        if (this.emptyString(sTable)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label13", "\u6ca1\u6709\u627e\u5230\u7edf\u8ba1\u89c6\u56fe\u5bf9\u5e94\u7684\u4e34\u65f6\u8868\uff01"));
        }
        String sSql = "SELECT MAX(RECID) AS MAXID FROM " + sTable;
        CMyResultSets resultsets = new CMyResultSets();
        resultsets.open(sSql, "MAXID");
        if (resultsets.isEmpty()) {
            return 0;
        }
        CMyResultSet resultset = (CMyResultSet)resultsets.getAt(0);
        return resultset.getPropertyAsInt("MAXID", 0);
    }

    public StatView findStatViewByName(String _sName) throws WCMException {
        if (this.emptyString(_sName)) {
            return null;
        }
        WCMFilter aFilter = new WCMFilter("", "VIEWNAME='" + CMyString.filterForSQL(_sName) + "'", "");
        StatViews statviews = new StatViews(this.getLoginUser());
        statviews.open(aFilter);
        if (statviews == null || statviews.isEmpty()) {
            return null;
        }
        return (StatView)statviews.getAt(0);
    }

    private String composeFrom(String _sTempFrom, CMyDateTime _fromDateTime, CMyDateTime _toDateTime) throws WCMException {
        if (this.emptyString(_sTempFrom)) {
            return "";
        }
        String sFrom = "";
        int nStartPos = 0;
        String sTempFrom = _sTempFrom + " ,";
        int nEndPos = sTempFrom.indexOf(",", nStartPos);
        while (nEndPos != -1) {
            String sCurrColumn = sTempFrom.substring(nStartPos, nEndPos).trim();
            if ((sCurrColumn = this.parseColumn(sCurrColumn, _fromDateTime, _toDateTime)) != null) {
                sFrom = sFrom + sCurrColumn + ",";
            }
            nStartPos = nEndPos + 1;
            nEndPos = sTempFrom.indexOf(",", nEndPos + 1);
        }
        return sFrom.substring(0, sFrom.length() - 1);
    }

    private String parseColumn(String _sColumnName, CMyDateTime _fromDateTime, CMyDateTime _toDateTime) throws WCMException {
        if (this.emptyString(_sColumnName)) {
            return null;
        }
        if (!START_QUOTE.equals(_sColumnName.substring(0, 1))) {
            return _sColumnName;
        }
        String sColumn = _sColumnName.substring(1, _sColumnName.length() - 1);
        StatView currStatView = this.findStatViewByName(sColumn);
        if (currStatView == null) {
            return null;
        }
        String sFrom = "(SELECT " + currStatView.getViewSelect();
        sFrom = sFrom + " FROM " + currStatView.getViewFrom();
        String sTemp = currStatView.getViewWhere();
        if (!this.emptyString(sTemp)) {
            sFrom = sFrom + " WHERE " + sTemp;
        }
        if (!this.emptyString(sTemp = currStatView.getViewGroupBy())) {
            sFrom = sFrom + " GROUP BY " + sTemp;
        }
        sFrom = sFrom + ") " + currStatView.getViewName();
        sFrom = this.parseDateTime(sFrom, _fromDateTime, _toDateTime);
        return sFrom;
    }

    private StatViews getEmbeddedViewsByFrom(int _nStatViewId) throws WCMException {
        if (_nStatViewId <= 0) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label14", "\u7edf\u8ba1\u89c6\u56fe\u6a21\u677fId\u65e0\u6548\uff0c\u65e0\u6cd5\u5f97\u5230\u5176\u7edf\u8ba1\u5143\u7d20\u4e2a\u6570\uff01"));
        }
        StatView currStatView = StatView.findById(_nStatViewId);
        if (currStatView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label15", "\u65e0\u6cd5\u6839\u636e\u7edf\u8ba1\u89c6\u56fe\u6a21\u677fId\u627e\u5230\u7edf\u8ba1\u6a21\u677f\uff01"));
        }
        if (currStatView.getViewType() != 3) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label16", "\u8be5\u6a21\u677f\u4e0d\u662f\u5373\u65f6\u7edf\u8ba1\u578b\u6a21\u677f\uff0c\u65e0\u6cd5\u8fdb\u884c\u5373\u65f6\u7edf\u8ba1\uff01"));
        }
        String sFromSql = currStatView.getViewFrom();
        StatViews currStatViews = new StatViews(this.getLoginUser());
        int nStartPos = sFromSql.indexOf(START_QUOTE, 0);
        while (nStartPos != -1) {
            int nEndPos = sFromSql.indexOf(END_QUOTE, nStartPos);
            if (nEndPos == -1) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label17", "\u67e5\u627e\u7edf\u8ba1\u6a21\u677f\u4e2d\u7684\u7edf\u8ba1\u5143\u7d20\u65f6\uff0c\u627e\u5230\u6709\u5f00\u59cb\uff0c\u6ca1\u6709\u7ed3\u675f\u7684\u6bb5\u843d\uff01"));
                nStartPos = -1;
                continue;
            }
            String sViewName = sFromSql.substring(nStartPos + 1, nEndPos);
            StatView aStatView = this.findStatViewByName(sViewName);
            if (aStatView == null) {
                s_logger.error((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label18", "\u67e5\u627e\u7edf\u8ba1\u6a21\u677f\u4e2d\u7684\u7edf\u8ba1\u5143\u7d20\u65f6\uff0c\u627e\u5230\u4e00\u4e2a\u7edf\u8ba1\u5143\u7d20\uff08") + sViewName + I18NMessage.get(StatMgr.class, "StatMgr.label19", "\uff09\uff0c\u4f46\u662f\u6570\u636e\u5e93\u4e2d\u6ca1\u6709\u627e\u5230\u8be5\u5143\u7d20\uff01")));
            } else {
                currStatViews.addElement(aStatView);
            }
            nStartPos = sFromSql.indexOf(START_QUOTE, nEndPos + 1);
        }
        return currStatViews;
    }

    public StatView saveStatView(StatView _currStatView, List _fieldMapList) throws WCMException {
        if (_currStatView == null || _fieldMapList == null || _fieldMapList.isEmpty()) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label20", "\u53c2\u6570\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (_currStatView.getStatHost() == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label21", "\u7edf\u8ba1\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (this.statHostNotExists(_currStatView)) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label22", "\u7edf\u8ba1\u4e3b\u4f53\u540d\u79f0\u65e0\u6548\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        if (_currStatView.getViewType() < 1 || _currStatView.getViewType() > 3) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label23", "\u7edf\u8ba1\u89c6\u56fe\u7c7b\u578b\u65e0\u6548\uff0c\u65e0\u6cd5\u4fdd\u5b58\u7edf\u8ba1\u89c6\u56fe\u6a21\u677f\uff01"));
        }
        boolean bNeedCreatTable = false;
        if (this.isTemplateView(_currStatView)) {
            if (_currStatView.isAddMode() || CMyString.isEmpty(_currStatView.getResultTable())) {
                _currStatView.setResultTable(_currStatView.getViewName());
                bNeedCreatTable = true;
            } else if (this.isStructureChanged(_currStatView, _fieldMapList)) {
                String sTableName = _currStatView.getResultTable();
                String sSql = "DROP TABLE " + sTableName;
                DBManager manager = DBManager.getDBManager();
                manager.sqlExecuteUpdate(sSql);
                manager.notifyRemoveTable(sTableName);
                bNeedCreatTable = true;
            }
        }
        _currStatView.save(this.getLoginUser());
        this.saveFieldList(_currStatView, _fieldMapList);
        if (bNeedCreatTable) {
            try {
                this.createStatResultTableIfNecessary(_currStatView, _fieldMapList);
            }
            catch (WCMException e) {
                _currStatView.delete(this.getLoginUser());
                throw e;
            }
        }
        return _currStatView;
    }

    private boolean statHostNotExists(StatView _currStatView) throws WCMException {
        String sName = _currStatView.getStatHost();
        if (sName == null || (sName = sName.trim()).length() == 0) {
            return true;
        }
        WCMFilter aFilter = new WCMFilter("", "HostName='" + CMyString.filterForSQL(sName) + "'", "");
        aFilter.setMaxRowNumber(1);
        return StatHosts.openWCMObjs(this.getLoginUser(), aFilter).isEmpty();
    }

    private void saveFieldList(StatView _currStatView, List _fieldMapList) throws WCMException {
        int i;
        String sUsedIds = "";
        for (int i2 = 0; i2 < _fieldMapList.size(); ++i2) {
            StatFieldMap currFieldMap = (StatFieldMap)_fieldMapList.get(i2);
            if (currFieldMap.isAddMode()) continue;
            sUsedIds = sUsedIds + currFieldMap.getId() + ",";
        }
        String delIds = "";
        if (sUsedIds.length() > 0) {
            sUsedIds = sUsedIds.substring(0, sUsedIds.length() - 1);
            delIds = "STATFIELDMAPID NOT IN (" + sUsedIds + ")";
        }
        StatFieldMaps delMaps = StatFieldMaps.openWCMObjs(this.getLoginUser(), new WCMFilter("", this.mergeAnd(delIds, "STATVIEWID=" + _currStatView.getId()), ""));
        for (i = 0; i < delMaps.size(); ++i) {
            StatFieldMap delField = (StatFieldMap)delMaps.getAt(i);
            delField.delete(this.getLoginUser());
        }
        for (i = 0; i < _fieldMapList.size(); ++i) {
            StatFieldMap currFieldMap = (StatFieldMap)_fieldMapList.get(i);
            if (currFieldMap == null) continue;
            currFieldMap.setStatTempId(_currStatView.getId());
            this.saveFieldMap(_currStatView, currFieldMap);
        }
    }

    private StatFieldMap saveFieldMap(StatView _currStatView, StatFieldMap _currFieldMap) throws WCMException {
        if (_currFieldMap.canEdit(this.getLoginUser())) {
            _currFieldMap.setStatTempId(_currStatView.getId());
        }
        _currFieldMap.save(this.getLoginUser());
        return _currFieldMap;
    }

    public void autorunStat() throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "VIEWTYPE=1", "");
        StatViews tempViews = StatViews.openWCMObjs(this.getLoginUser(), aFilter);
        if (tempViews == null || tempViews.isEmpty()) {
            return;
        }
        for (int i = 0; i < tempViews.size(); ++i) {
            StatView currView = (StatView)tempViews.getAt(i);
            if (currView == null) {
                s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label24", "\u81ea\u52a8\u6267\u884c\u7edf\u8ba1\u6570\u636e\u7684\u4efb\u52a1\u65f6\u627e\u5230\u4e00\u4e2a\u4e3a\u7a7a\u7684\u4efb\u52a1\uff01"));
                continue;
            }
            this.generateTodayStat(currView.getId());
        }
    }

    private void createStatResultTableIfNecessary(StatView _statview, List _fieldMapList) throws WCMException {
        if (!this.isTemplateView(_statview)) {
            return;
        }
        String sTableName = _statview.getResultTable();
        if (sTableName == null) {
            throw new WCMException(1106, I18NMessage.get(StatMgr.class, "StatMgr.label25", "\u7edf\u8ba1\u4e34\u65f6\u8868\u540d\u79f0\u4e3a\u7a7a,\u65e0\u6cd5\u4ea7\u751f\u7edf\u8ba1!"));
        }
        sTableName = sTableName.toUpperCase();
        DBManager manager = DBManager.getDBManager();
        if (manager.getTableInfo(sTableName) != null) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label26", "\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + sTableName + I18NMessage.get(StatMgr.class, "StatMgr.label27", "]\u7684\u7edf\u8ba1\u8868!"));
        }
        String sSql = "CREATE TABLE " + sTableName + "(";
        sSql = sSql + "RECID " + this.getType("NUMBER") + ", ";
        sSql = sSql + "STATTIME " + this.getType("DATETIME");
        for (int i = 0; i < _fieldMapList.size(); ++i) {
            StatFieldMap currField = (StatFieldMap)_fieldMapList.get(i);
            if (currField == null) continue;
            String sFieldName = currField.getFieldName();
            String sFieldType = currField.getFieldType();
            sSql = sSql + ", " + sFieldName + " " + this.getType(sFieldType);
            if (!"STRING".equals(sFieldType.toUpperCase())) continue;
            sSql = sSql + "(200) ";
        }
        sSql = sSql + ")";
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label28", "\u521b\u5efa\u6570\u636e\u5e93\uff1a") + sSql));
        }
        try {
            manager.sqlExecuteUpdate(sSql);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label29", "\u521b\u5efa\u7edf\u8ba1\u6570\u636e\u8868\u5931\u8d25!"), ex);
        }
        manager.notifyAddTable(sTableName);
    }

    public static void main(String[] args) {
        System.out.println("ad");
    }

    private String getType(String _sType) {
        int nDBType = DBManager.getDBManager().getDBTypeAsInt() - 1;
        if ((_sType = _sType.toUpperCase()).equals("NUMBER")) {
            return DB_NUMBER_TYPE[nDBType];
        }
        if (_sType.equals("STRING")) {
            return DB_STRING_TYPE[nDBType];
        }
        if (_sType.equals("DATETIME")) {
            return DB_DATETIME_TYPE[nDBType];
        }
        return "";
    }

    public final Reports deleteStatView(StatView _delStatview) throws WCMException {
        if (_delStatview == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label30", "\u7edf\u8ba1\u89c6\u56fe\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664\uff01"));
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("be going to delete a statview \uff1a" + _delStatview.getViewName()));
        }
        Reports currReports = new Reports(I18NMessage.get(StatMgr.class, "StatMgr.label31", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe"));
        try {
            this.deleteFieldMapsOf(_delStatview);
            this.deleteStatResultTableIfTemplateView(_delStatview);
            this.deleteEmbedViews(_delStatview);
            this.deleteStatViewRelations(_delStatview);
            _delStatview.delete(this.getLoginUser());
        }
        catch (Exception e) {
            currReports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label32", "\u5220\u9664[") + _delStatview + I18NMessage.get(StatMgr.class, "StatMgr.label33", "]\u5931\u8d25."), e);
        }
        currReports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label32", "\u5220\u9664[") + _delStatview + I18NMessage.get(StatMgr.class, "StatMgr.label34", "]\u6210\u529f."));
        return currReports;
    }

    private void deleteFieldMapsOf(StatView _delStatview) throws WCMException {
        StatFieldMaps delMaps = this.getViewFields(_delStatview.getId());
        if (delMaps != null && !delMaps.isEmpty()) {
            for (int i = 0; i < delMaps.size(); ++i) {
                StatFieldMap currField = (StatFieldMap)delMaps.getAt(i);
                if (currField == null) {
                    s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label35", "\u5220\u9664\u5b57\u6bb5\u6620\u5c04\u8868\u65f6\u53d1\u73b0\u4e00\u4e2a\u7a7a\u7684\uff01\u7ee7\u7eed\u6267\u884c\u3002"));
                    continue;
                }
                currField.delete(this.getLoginUser());
            }
        }
    }

    private void deleteStatResultTableIfTemplateView(StatView _delStatview) throws WCMException {
        if (!CMyString.isEmpty(_delStatview.getResultTable())) {
            String sDropSql = "DROP TABLE " + _delStatview.getResultTable();
            DBManager manager = DBManager.getDBManager();
            manager.sqlExecuteUpdate(sDropSql);
            manager.notifyRemoveTable(_delStatview.getResultTable());
        }
    }

    private void deleteEmbedViews(StatView _statView) throws WCMException {
        if (this.isTemplateView(_statView)) {
            StatViews embedViews = this.getEmbeddedViews(_statView.getId());
            for (int i = 0; i < embedViews.size(); ++i) {
                StatView view = (StatView)embedViews.getAt(i);
                if (view == null) continue;
                this.deleteStatView(view);
            }
        }
    }

    private void deleteStatViewRelations(StatView _delStatview) throws WCMException {
        String sSql = "DELETE FROM WCMSTATVIEWREL WHERE ";
        sSql = this.isTemplateView(_delStatview) ? sSql + "MainViewId=" + _delStatview.getId() : sSql + "EmbedViewId=" + _delStatview.getId();
        DBManager.getDBManager().sqlExecuteUpdate(sSql);
    }

    private boolean isTemplateView(StatView _statView) {
        int viewType = _statView.getNewPropertyAsInt("VIEWTYPE", 0) == 0 ? _statView.getViewType() : _statView.getNewPropertyAsInt("VIEWTYPE", 0);
        return 1 == viewType;
    }

    public void setStatViewRelation(StatView _mainView, StatViews _embeddedViews) throws WCMException {
        int i;
        if (_mainView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label36", "\u7edf\u8ba1\u89c6\u56fe\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u5173\u8054\u5173\u7cfb\uff01"));
        }
        if (_embeddedViews == null || _embeddedViews.isEmpty()) {
            return;
        }
        String sWhere = "MAINVIEWID=" + _mainView.getId();
        StatViewRels delRels = StatViewRels.openWCMObjs(this.getLoginUser(), new WCMFilter("", sWhere, ""));
        for (i = 0; i < delRels.size(); ++i) {
            StatViewRel currRel = (StatViewRel)delRels.getAt(i);
            if (currRel == null) continue;
            currRel.delete(this.getLoginUser());
        }
        for (i = 0; i < _embeddedViews.size(); ++i) {
            StatView currEmbView = (StatView)_embeddedViews.getAt(i);
            if (currEmbView == null) continue;
            StatViewRel newRel = new StatViewRel();
            newRel.setMainViewId(_mainView.getId());
            newRel.setEmbedViewId(currEmbView.getId());
            newRel.save(this.getLoginUser());
        }
    }

    private String parseDateTime(String _sSqlStr, CMyDateTime _fromDate, CMyDateTime _toDate) throws WCMException {
        String sResultSql = _sSqlStr;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("start: " + _fromDate));
            s_logger.debug((Object)("end: " + _toDate));
        }
        String dtStart = this.getStartTime(_fromDate);
        sResultSql = CMyString.replaceStr(sResultSql, TAG_START_TIME, dtStart);
        String dtEnd = this.getEndTime(_toDate);
        sResultSql = CMyString.replaceStr(sResultSql, TAG_END_TIME, dtEnd);
        return sResultSql;
    }

    private String getStartTime(CMyDateTime _dtStart) throws WCMException {
        if (this.isInvalidDateTime(_dtStart)) {
            try {
                _dtStart = CMyDateTime.now();
                _dtStart.setDateTimeWithString(this.getOriginalStart());
            }
            catch (CMyException e) {
                throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label37", "\u83b7\u53d6\u7edf\u8ba1\u8d44\u6e90\u7684\u8d77\u59cb\u65f6\u95f4\u51fa\u9519!"), e);
            }
        }
        return this.toSqlDate(_dtStart);
    }

    private String getEndTime(CMyDateTime _dtEnd) {
        if (this.isInvalidDateTime(_dtEnd)) {
            _dtEnd = CMyDateTime.now();
            try {
                _dtEnd.setTimeWithString("23:59:59", 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.toSqlDate(_dtEnd);
    }

    private String toSqlDate(CMyDateTime _currDateTime) {
        return DBManager.getDBManager().getDBType().sqlDateTime(_currDateTime.toString(), "YYYY-MM-DD HH24:MI:SS");
    }

    private boolean isInvalidDateTime(CMyDateTime _datetime) {
        return _datetime == null || _datetime.isNull();
    }

    public StatViews getEmbeddedViews(StatView _mainView) throws WCMException {
        if (_mainView == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label38", "\u7edf\u8ba1\u6a21\u677f\u4e3a\u7a7a\uff01"));
        }
        if (_mainView.getViewType() == 3) {
            return this.getEmbeddedViewsByFrom(_mainView.getId());
        }
        return this.getEmbeddedViews(_mainView.getId());
    }

    private boolean isStructureChanged(StatView _currStatView, List _fieldMapList) throws WCMException {
        if (_currStatView.isAddMode()) {
            return false;
        }
        if (_currStatView.isChangeProperty("VIEWNAME")) {
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label39", "\u4e34\u65f6\u7edf\u8ba1\u8868\u540d\u79f0\u53d8\u5316\u4e86\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        for (int i = 0; i < _fieldMapList.size(); ++i) {
            StatFieldMap currField = (StatFieldMap)_fieldMapList.get(i);
            if (currField == null) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label40", "\u5b57\u6bb5\u5217\u8868\u4e2d\u6709\u4e00\u4e2a\u4e3a\u7a7a\uff01"));
                continue;
            }
            if (currField.isAddMode()) {
                s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label41", "\u65b0\u589e\u4e86\u5b57\u6bb5\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
                return true;
            }
            if (!currField.isChangeProperty("FIELDPOS") && !currField.isChangeProperty("FIELDNAME") && !currField.isChangeProperty("FIELDTYPE")) continue;
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label42", "\u5b57\u6bb5\u6620\u5c04\u8868\u4e2d\u7684\u5173\u952e\u4fe1\u606f\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        if (this.getViewFields(_currStatView.getId()).size() != _fieldMapList.size()) {
            s_logger.debug((Object)I18NMessage.get(StatMgr.class, "StatMgr.label43", "\u5b57\u6bb5\u6570\u76ee\u53d1\u751f\u4e86\u53d8\u5316\uff0c\u7ed3\u6784\u53d8\u5316\u4e86\u3002"));
            return true;
        }
        return false;
    }

    public void clearStatResult(int _nStatViewId) throws WCMException {
        StatView currStatView = StatView.findById(_nStatViewId);
        if (currStatView == null) {
            throw new WCMException(200006, I18NMessage.get(StatMgr.class, "StatMgr.label44", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684[id=") + _nStatViewId + I18NMessage.get(StatMgr.class, "StatMgr.label45", "]\u7684\u7edf\u8ba1\u89c6\u56fe!"));
        }
        if (currStatView.getViewType() != 1) {
            s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label46", "\u5f53\u524d\u7edf\u8ba1\u89c6\u56fe\u4e0d\u662f\u6a21\u677f\u578b\uff0c\u4e0d\u9700\u8981\u5220\u9664\u6570\u636e\uff01"));
            return;
        }
        String sSql = "DELETE FROM " + currStatView.getResultTable();
        s_logger.debug((Object)(I18NMessage.get(StatMgr.class, "StatMgr.label47", "\u5220\u9664\u4e34\u65f6\u8868\u4e2d\u7684\u6570\u636e\uff1a") + sSql));
        try {
            DBManager.getDBManager().sqlExecuteUpdate(sSql);
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(StatMgr.class, "StatMgr.label48", "\u5220\u9664\u4e34\u65f6\u8868\u4e2d\u7684\u6570\u636e\u65f6\u5931\u8d25\uff1aSQL=\u3010") + sSql + "\u3011", ex);
        }
    }

    public Reports deleteStatHost(StatHost _delStatHost) throws WCMException {
        if (_delStatHost == null) {
            throw new WCMException(10, I18NMessage.get(StatMgr.class, "StatMgr.label49", "\u5f53\u524d\u7edf\u8ba1\u4e3b\u4f53\u4e3a\u7a7a,\u65e0\u6548\u7684\u7edf\u8ba1\u4e3b\u4f53,\u65e0\u6cd5\u5220\u9664!"));
        }
        Reports currReports = new Reports(I18NMessage.get(StatMgr.class, "StatMgr.label50", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53"));
        StatViews delStatViews = this.getStatViews(_delStatHost.getHostName(), 0, null);
        for (int i = 0; i < delStatViews.size(); ++i) {
            StatView delStatView = (StatView)delStatViews.getAt(i);
            if (delStatView == null) {
                s_logger.error((Object)I18NMessage.get(StatMgr.class, "StatMgr.label51", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe\u65f6\u6709\u4e00\u4e2a\u4e3a\u7a7a\uff01"));
                currReports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label52", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe\u65f6\u6709\u4e00\u4e2a\u4e3a\u7a7a"), null);
                continue;
            }
            try {
                this.deleteStatView(delStatView);
                currReports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label53", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe[") + delStatView.getViewName() + I18NMessage.get(StatMgr.class, "StatMgr.label54", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception ex) {
                currReports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label53", "\u5220\u9664\u7edf\u8ba1\u89c6\u56fe[") + delStatView.getViewName() + I18NMessage.get(StatMgr.class, "StatMgr.label55", "]\u5931\u8d25\uff01"), ex);
            }
        }
        try {
            _delStatHost.delete(this.getLoginUser());
            currReports.addSucessedReport(I18NMessage.get(StatMgr.class, "StatMgr.label56", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53[") + _delStatHost.getHostName() + I18NMessage.get(StatMgr.class, "StatMgr.label54", "]\u6210\u529f\uff01"));
        }
        catch (Exception ex) {
            currReports.addFailedReport(I18NMessage.get(StatMgr.class, "StatMgr.label56", "\u5220\u9664\u7edf\u8ba1\u4e3b\u4f53[") + _delStatHost.getHostName() + I18NMessage.get(StatMgr.class, "StatMgr.label55", "]\u5931\u8d25\uff01"), ex);
        }
        return currReports;
    }

    public StatFieldMaps getStatFieldsByView(int _nStatViewId) throws WCMException {
        StatView currStatView = StatView.findById(_nStatViewId);
        this.assertViewFound(_nStatViewId, currStatView);
        String sWhere = "STATVIEWID = " + _nStatViewId;
        WCMFilter mapFilter = new WCMFilter("", sWhere, "FIELDTOP DESC, FIELDPOS ASC");
        return StatFieldMaps.openWCMObjs(this.getLoginUser(), mapFilter);
    }

    private StatFieldMaps getViewFields(StatView _statview) throws WCMException {
        String sWhere = "STATVIEWID = " + _statview.getId();
        WCMFilter mapFilter = new WCMFilter("", sWhere, "FIELDTOP DESC, FIELDPOS ASC");
        return StatFieldMaps.openWCMObjs(this.getLoginUser(), mapFilter);
    }

    private boolean emptyString(String _string) {
        return _string == null || _string.trim().length() == 0;
    }

    private void assertViewFound(int _nStatViewId, StatView _statview) throws WCMException {
        if (_statview == null) {
            throw new WCMException(200006, I18NMessage.get(StatMgr.class, "StatMgr.label57", "\u6ca1\u6709\u627e\u5230[id=") + _nStatViewId + I18NMessage.get(StatMgr.class, "StatMgr.label58", "]\u7684\u7edf\u8ba1\u5b9e\u89c6\u56fe!"));
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

