/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.recent;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.recent.Recent;
import com.trs.components.wcm.recent.Recents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class RecentMgr {
    public boolean add(int _nObjType, int _nObjId) throws WCMException {
        CMSObj currObj = this.getWCMObj(_nObjType, _nObjId);
        if (currObj == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label1", "\u6ca1\u6709\u627e\u5230\u5f53\u524d\u5bf9\u8c61\uff0c\u65e0\u6cd5\u8bb0\u5f55\u5230\u6700\u8fd1\u8bbf\u95ee\u7684\u5bf9\u8c61\u8bb0\u5f55\u4e2d\uff01"));
        }
        Recent currRecent = this.prepareAdd(currObj);
        currRecent = this.save(currRecent);
        return true;
    }

    private CMSObj getWCMObj(int _nObjType, int _nObjId) throws WCMException {
        switch (_nObjType) {
            case 103: {
                return WebSite.findById(_nObjId);
            }
            case 101: {
                return Channel.findById(_nObjId);
            }
            case 605: {
                return Document.findById(_nObjId);
            }
            case 102: {
                return Template.findById(_nObjId);
            }
            case 614: {
                return ChnlDoc.findById(_nObjId);
            }
        }
        throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label2", "\u4f20\u5165\u7684\u5bf9\u8c61\u7c7b\u578b[") + _nObjType + I18NMessage.get(RecentMgr.class, "RecentMgr.label3", "]\u4e0d\u652f\u6301\uff01"));
    }

    private Recent prepareAdd(CMSObj _currObj) throws WCMException {
        if (_currObj == null) {
            return null;
        }
        Recents currRecents = this.getRecents(_currObj.getWCMType());
        Recent currRecent = null;
        if (currRecents == null) {
            currRecent = new Recent();
            currRecent.setObj(_currObj);
            return currRecent;
        }
        if (currRecents.indexOf(this.getRecent(_currObj)) >= 0) {
            currRecent = this.getRecent(_currObj);
            currRecent.canEdit(this.getLoginUser());
            currRecent.setProperty("CRTIME", CMyDateTime.now());
            return currRecent;
        }
        if (currRecents.size() >= Recent.getMaxNum()) {
            currRecent = (Recent)currRecents.getAt(currRecents.size() - 1);
            if (currRecent == null) {
                throw new WCMException(20, I18NMessage.get(RecentMgr.class, "RecentMgr.label4", "\u4ece\u96c6\u5408\u4e2d\u53d6\u5f97\u6700\u8fd1\u8bbf\u95ee\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
            }
            currRecent.canEdit(this.getLoginUser());
            currRecent.setObj(_currObj);
            currRecent.setProperty("CRTIME", CMyDateTime.now());
            return currRecent;
        }
        currRecent = new Recent();
        currRecent.setObj(_currObj);
        return currRecent;
    }

    private Recents getRecents(int _nObjType) throws WCMException {
        if (_nObjType < 0) {
            return null;
        }
        String sWhere = "CrUser='" + this.getLoginUserNameForSql() + "' AND OBJTYPE=" + _nObjType;
        WCMFilter aFilter = new WCMFilter("", sWhere, "CrTime Desc");
        return Recents.openWCMObjs(this.getLoginUser(), aFilter);
    }

    private Recent save(Recent _currRecent) throws WCMException {
        if (_currRecent == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label5", "\u6700\u8fd1\u8bbf\u95ee\u7684\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fdd\u5b58\uff01"));
        }
        _currRecent.save(this.getLoginUser());
        return _currRecent;
    }

    private Recent getRecent(CMSObj _currObj) throws WCMException {
        if (_currObj == null) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label6", "\u5f53\u524d\u8bbf\u95ee\u5bf9\u8c61\u4e3a\u7a7a\uff01"));
        }
        String sWhere = "CrUser='" + this.getLoginUserNameForSql() + "' AND OBJTYPE=" + _currObj.getWCMType() + " AND OBJID=" + _currObj.getId();
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        Recents currRecents = Recents.openWCMObjs(this.getLoginUser(), aFilter);
        if (currRecents == null || currRecents.isEmpty()) {
            return null;
        }
        return (Recent)currRecents.getAt(0);
    }

    public String getIds(int _nObjTypeId) throws WCMException {
        if (_nObjTypeId < 0) {
            throw new WCMException(10, I18NMessage.get(RecentMgr.class, "RecentMgr.label7", "\u5bf9\u8c61\u7c7b\u578b\u65e0\u6548\uff0c\u65e0\u6cd5\u5f97\u5230\u6700\u8fd1\u8bbf\u95ee\u5217\u8868\uff01"));
        }
        Recents currRecents = this.getRecents(_nObjTypeId);
        if (currRecents == null || currRecents.isEmpty()) {
            return null;
        }
        return currRecents.getIdListAsString();
    }

    public Documents getDocuments(WCMFilter _aFilter, boolean _bIncludeDeleted) throws WCMException {
        String sFrom = "WCMDOCUMENT, WCMRECENT";
        String sWhere = "WCMDOCUMENT.DOCID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=605 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!_bIncludeDeleted) {
            sWhere = sWhere + " AND WCMDOCUMENT.DOCSTATUS>0";
        }
        String sOrder = "WCMRECENT.CRTIME DESC";
        WCMFilter aFilter = new WCMFilter(sFrom, sWhere, sOrder);
        aFilter.mergeWith(_aFilter);
        return Documents.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public Channels getChannels(WCMFilter _aFilter, boolean _bIncludeDeleted) throws WCMException {
        String sFrom = "WCMCHANNEL, WCMRECENT";
        String sWhere = "WCMCHANNEL.CHANNELID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=101 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!_bIncludeDeleted) {
            sWhere = sWhere + " AND WCMCHANNEL.STATUS=0";
        }
        String sOrder = "WCMRECENT.CRTIME DESC";
        WCMFilter aFilter = new WCMFilter(sFrom, sWhere, sOrder);
        aFilter.mergeWith(_aFilter);
        return Channels.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public Templates getTemplates(WCMFilter _aFilter) throws WCMException {
        String sFrom = "WCMTEMPLATE, WCMRECENT";
        String sWhere = "WCMTEMPLATE.TEMPID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=102 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        String sOrder = "WCMRECENT.CRTIME DESC";
        WCMFilter aFilter = new WCMFilter(sFrom, sWhere, sOrder);
        aFilter.mergeWith(_aFilter);
        return Templates.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public WebSites getWebSites(WCMFilter _aFilter) throws WCMException {
        String sFrom = "WCMWEBSITE, WCMRECENT";
        String sWhere = "WCMWEBSITE.SITEID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=103 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        String sOrder = "WCMRECENT.CRTIME DESC";
        WCMFilter aFilter = new WCMFilter(sFrom, sWhere, sOrder);
        aFilter.mergeWith(_aFilter);
        return WebSites.openWCMObjs(this.getLoginUser(), aFilter);
    }

    public ChnlDocs getChnlDocs(WCMFilter _aFilter, boolean _bIncludeDeleted) throws WCMException {
        String sFrom = "WCMCHNLDOC, WCMRECENT";
        String sWhere = "WCMCHNLDOC.RECID=WCMRECENT.OBJID AND WCMRECENT.OBJTYPE=614 AND WCMRECENT.CRUSER='" + this.getLoginUserNameForSql() + "'";
        if (!_bIncludeDeleted) {
            sWhere = sWhere + " AND (WCMCHNLDOC.DOCSTATUS>0 AND WCMCHNLDOC.CHNLID>0)";
        }
        String sOrder = "WCMRECENT.CRTIME DESC";
        WCMFilter aFilter = new WCMFilter(sFrom, sWhere, sOrder);
        aFilter.mergeWith(_aFilter);
        return ChnlDocs.openWCMObjs(this.getLoginUser(), aFilter);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private String getLoginUserNameForSql() {
        return CMyString.filterForSQL(this.getLoginUser().getName());
    }
}

