/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSObjsImpl;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.NamesRegister;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class WCMTagParserRelNews
implements ITagParser,
ITagParser4List {
    private static Logger logger = Logger.getLogger(WCMTagParserRelNews.class);
    private static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    private static HashMap FIELDS_MAP;
    private TagItem m_tagItem = null;
    private IPublishElements m_contents;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private static NamesRegister s_oNameRegister;
    private static TagBeanInfo s_TagBeanInfo;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_RELNEWS");
            tbi.setDesc("TRS_RELNEWS");
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_blank");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MODE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"USERDEF", "KEYWORDS", "ALL"});
            tbai.setDefaultValue("USERDEF");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("MULTISITE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHNLID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
        this.m_tagItem = _item;
    }

    public void clear() {
        if (this.m_contents != null) {
            this.m_contents.clear();
        }
        if (this.m_nextRecordContext != null) {
            this.m_nextRecordContext = null;
        }
        if (this.m_tagItem != null) {
            this.m_tagItem = null;
        }
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        Document doc = null;
        IPublishElement upperHost = _context.getUpperHost();
        if (!(upperHost instanceof IPublishContent)) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label1", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[") + upperHost.getInfo() + "]");
        }
        try {
            doc = (Document)upperHost.getSubstance();
        }
        catch (ClassCastException ex) {
            throw new WCMException(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label2", "TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[") + upperHost.getSubstance() + "]", ex);
        }
        String sMode = _context.getAttribute("MODE");
        if (sMode == null || (sMode = sMode.trim()).length() == 0) {
            sMode = "USERDEF";
        }
        int nGetRelateMode = s_oNameRegister.lookup(sMode.toUpperCase(), 30);
        boolean bMultiSite = _context.getAttribute("MULTISITE", false);
        String sChnlId = _context.getAttribute("CHNLID");
        int nChannelId = 0;
        if ("SELF".equalsIgnoreCase(sChnlId)) {
            nChannelId = doc.getChannelId();
        } else if (!CMyString.isEmpty(sChnlId)) {
            try {
                nChannelId = Integer.parseInt(sChnlId);
            }
            catch (Exception ex) {
                nChannelId = 0;
            }
        }
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        String sSelectFields = this.getSelectFields(_context);
        WCMFilter filter = new WCMFilter("", "DocStatus=10 and DocChannel>0", "", sSelectFields);
        int nMaxNum = _context.getAttribute("NUM", 20);
        if (nChannelId > 0) {
            nMaxNum += 30;
        }
        filter.setMaxRowNumber(nMaxNum);
        Documents relateDocs = documentMgr.getRelatedDocuments(doc, nGetRelateMode, filter, true, bMultiSite);
        relateDocs.setMaxBufferSize(nMaxNum);
        if (nChannelId != 0) {
            for (int i = relateDocs.size() - 1; i >= 0; --i) {
                Document tmpDoc = (Document)relateDocs.getAt(i);
                if (tmpDoc.getChannelId() == nChannelId) continue;
                relateDocs.removeAt(i, false);
            }
        }
        this.m_contents = new PublishElementsCMSObjsImpl(relateDocs);
        if (this.m_contents == null || this.m_contents.isEmpty()) {
            return null;
        }
        this.m_nextRecordContext = new PublishTagContext(_context, this.m_tagItem, this);
        String[] results = TagParseHelper.parse4List(this.m_tagItem, _context, this);
        return results;
    }

    @Override
    public int getRecordSize() {
        return this.m_contents == null ? 0 : this.m_contents.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            content.setFolder(content.getOriginalHome());
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(content);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            IPublishContent content = (IPublishContent)this.m_contents.get(this.m_nCurrPos++);
            content.setFolder(content.getOriginalHome());
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(content);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
        if (sSelectFields == null) {
            TagItem tagItem = this.m_tagItem;
            synchronized (tagItem) {
                sSelectFields = this.m_tagItem.getExtraAttributeValue("SELECT");
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_tagContext);
                    this.m_tagItem.setExtraAttribute("SELECT", sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = (String)FIELDS_DEFAULT_LIST.get(0);
        int nSize = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + ",WCMDocument." + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(this.m_tagItem, "TRS_DOCUMENT");
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(sFieldName) >= 0) continue;
            String sMapField = (String)FIELDS_MAP.get(sFieldName);
            if (sMapField != null) {
                sFieldName = sMapField;
            }
            try {
                if (dbMgr.getFieldInfo("WCMDOCUMENT", sFieldName) == null) {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label3", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label4", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label5", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(WCMTagParserRelNews.class, "WCMTagParserRelNews.label6", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + ",WCMDocument." + sFieldName;
        }
        return sSelectFields;
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCSTATUS");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_DEFAULT_LIST.add("DOCRELTIME");
        FIELDS_DEFAULT_LIST.add("DOCPUBTIME");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_oNameRegister = new NamesRegister();
        s_oNameRegister.register("USERDEF", 30);
        s_oNameRegister.register("RELWORDS", 20);
        s_oNameRegister.register("KEYWORDS", 10);
        s_oNameRegister.register("ALL", 0);
        s_TagBeanInfo = null;
    }
}

