/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfoHelper;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.domain.DocumentsGetHelper;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.tagparser.WCMTagParserHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.util.List;
import org.apache.log4j.Logger;

public class WCMTagParserChannel
extends TagParserFolderBase {
    private static Logger logger = Logger.getLogger(WCMTagParserChannel.class);
    private static boolean SUPPORT_CHNLLOG_PROPERTY = true;
    private static int MAX_NUM_CHNLLOG = 10;
    private static final int CHNL_DESC = 100;
    private static final int DATA_COUNT = 101;
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TBI tbi = new TBI();
            tbi.setName("TRS_CHANNEL");
            tbi.setDesc("TRS_CHANNEL");
            tbi.setType(TagBeanInfo.BodyType.IGNORE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ID");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("OWNER");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("CHILDINDEX");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("-1");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FIELD");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("CHNLDESC");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("DATEFORMAT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("yyyy-MM-dd HH:mm:ss");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMAT");
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOFORMATTYPE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"HTML", "HTMLValue", "JAVASCRIPT", "JS", "XML", "JSON"});
            tbai.setDefaultValue("HTML");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("AUTOLINK");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TARGET");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("_self");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("EXTRA");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("COUNTWHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKALT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKALTTEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("LINKTEXT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TRUNCATEDFLAG");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("...");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TemplateName");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("FromSite");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("ALL");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("INCLUDECHILDREN");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("COUNTWHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("TODAY");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setEnumValue(new String[]{"true", "false"});
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        boolean bMustBeChannel = !_context.getAttribute("FromSite", false);
        BaseChannel oChannelOrSite = WCMTagParserHelper.findFolderHost(this.m_tagItem, _context, bMustBeChannel);
        if (bMustBeChannel || oChannelOrSite == null) {
            return oChannelOrSite;
        }
        return oChannelOrSite.getSite();
    }

    @Override
    protected String getDefaultField() {
        return "CHNLDESC";
    }

    @Override
    protected boolean mayAutoLink(PublishTagContext _context) {
        if (!(this.m_host instanceof Channel)) {
            return false;
        }
        Channel channel = (Channel)this.m_host;
        if (channel == null) {
            return false;
        }
        int iType = channel.getType();
        if (iType == 2 || iType == 1) {
            return false;
        }
        return super.mayAutoLink(_context);
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("CHNLDESC", 100);
        this.registerHostSpecialProperty("_DATACOUNT", 101);
        for (int i = 0; SUPPORT_CHNLLOG_PROPERTY && i < MAX_NUM_CHNLLOG; ++i) {
            this.registerHostSpecialProperty("CHNLLOG" + i, i + 1);
        }
    }

    @Override
    protected String[] parseHostSpecialProperty(int _nPropertyId, PublishTagContext _context) throws WCMException {
        if (this.m_host == null) {
            logger.error((Object)(_context.getTagItem() + I18NMessage.get(WCMTagParserChannel.class, "WCMTagParserChannel.label1", "\u89e3\u6790\u5931\u8d25\uff01\u76f8\u5173\u9891\u9053\u6ca1\u6709\u627e\u5230\uff01")));
            return null;
        }
        Channel channel = (Channel)this.m_host;
        switch (_nPropertyId) {
            case 100: {
                String sDesc = channel.getDesc();
                if (sDesc == null || (sDesc = sDesc.trim()).length() <= 0) {
                    sDesc = channel.getName();
                }
                return this.parseProperty(sDesc, _context);
            }
            case 101: {
                return this.parseDataCount(_context, channel);
            }
        }
        if (_nPropertyId > 0 && _nPropertyId <= MAX_NUM_CHNLLOG) {
            return new String[]{this.m_host.getAttributeValue("CHNLLOG" + (_nPropertyId - 1))};
        }
        return null;
    }

    protected String[] parseDataCount(PublishTagContext _context, Channel channel) throws WCMException {
        WCMFilter extraFitler = null;
        if (_context.getAttribute("ALL", false)) {
            extraFitler = null;
        } else {
            extraFitler = new WCMFilter("", "", "");
            String sExtraWhere = _context.getAttribute("COUNTWHERE");
            if (CMyString.isEmpty(sExtraWhere)) {
                extraFitler.setWhere("WCMCHNLDOC.DOCSTATUS=?");
                extraFitler.addSearchValues(10);
            } else {
                extraFitler.setWhere(sExtraWhere);
            }
        }
        if (_context.getAttribute("Today", false)) {
            String sWhere;
            if (extraFitler == null) {
                extraFitler = new WCMFilter();
            }
            if (!CMyString.isEmpty(sWhere = extraFitler.getWhere())) {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "(WCMChnlDoc.DocRelTime>=? and WCMChnlDoc.DocRelTime<=?)";
            extraFitler.setWhere(sWhere);
            CMyDateTime dtEnd = CMyDateTime.now();
            CMyDateTime dtStart = new CMyDateTime();
            try {
                dtStart.setDateTimeWithString(dtEnd.toString("yyyy-MM-dd 00:00:00"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            extraFitler.addSearchValues(dtStart);
            extraFitler.addSearchValues(dtEnd);
        }
        WCMFilter filter = DocumentsGetHelper.makeChannelFilter(channel, extraFitler);
        DBManager dbman = DBManager.getDBManager();
        int nResult = dbman.sqlExecuteCountQuery(filter);
        if (_context.getAttribute("INCLUDECHILDREN", false)) {
            nResult += this.getChildrenCount(dbman, channel, extraFitler);
        }
        return new String[]{String.valueOf(nResult)};
    }

    private int getChildrenCount(DBManager dbman, Channel channel, WCMFilter extraFitler) throws WCMException {
        List<Channel> children = channel.getChildren(null);
        if (children == null || children.isEmpty()) {
            return 0;
        }
        int len = children.size() - 1;
        int nResult = 0;
        if (extraFitler == null) {
            for (int i = len; i >= 0; --i) {
                Channel child = children.get(i);
                if (child == null) continue;
                WCMFilter filter = DocumentsGetHelper.makeChannelFilter(child, null);
                nResult += dbman.sqlExecuteCountQuery(filter);
                nResult += this.getChildrenCount(dbman, child, extraFitler);
            }
        } else {
            for (int i = len; i >= 0; --i) {
                Channel child = children.get(i);
                if (child == null) continue;
                WCMFilter filter = DocumentsGetHelper.makeChannelFilter(child, new WCMFilter(extraFitler));
                nResult += dbman.sqlExecuteCountQuery(filter);
                nResult += this.getChildrenCount(dbman, child, extraFitler);
            }
        }
        return nResult;
    }

    private class TBI
    extends TagBeanInfo {
        @Override
        public void checkSemantic(IPublishFolder _folder, TagItem _tagItem, StringBuffer _sbResult) {
            TagBeanInfoHelper.checkChannelName(_folder, _tagItem, _sbResult);
        }
    }
}

