/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.domain.IPreNextDocuments;
import com.trs.components.wcm.publish.domain.PreNextDocumentsImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public abstract class BaseWCMTagParserPreNextDocuments
extends BaseTagParser4List {
    private static Logger logger = Logger.getLogger(BaseWCMTagParserPreNextDocuments.class);
    public static ArrayList FIELDS_DEFAULT_LIST = new ArrayList(16);
    public static HashMap FIELDS_MAP;
    protected static TagBeanInfo s_TagBeanInfo;
    public static final int MODE_PRE = 0;
    public static final int MODE_NEXT = 1;

    protected abstract int getCurrMode();

    protected abstract String getCurrTagName();

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanAttrInfo tbai = null;
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName(this.getCurrTagName());
            tbi.setDesc(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label1", "\u83b7\u53d6\u524d\u540e\u6587\u6863"));
            tbi.setType(TagBeanInfo.BodyType.TAMPLATE);
            tbai = new TagBeanAttrInfo();
            tbai.setName("STARTPOS");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("NUM");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("SELECT");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            tbai = new TagBeanAttrInfo();
            tbai.setName("WHERE");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        String sKey;
        if (_context.isPreview() && (_context.getPageElement().getId() <= 0 || _context.getPageElement().getSubstance().isAddMode())) {
            return new Documents(null);
        }
        PublishTaskContext taskContext = _context.getPageContext().getTaskContext();
        IPreNextDocuments oPreNextDocuments = (IPreNextDocuments)taskContext.getCachObject(sKey = "IPreNextDocuments");
        if (oPreNextDocuments == null) {
            oPreNextDocuments = new PreNextDocumentsImpl();
            taskContext.putInCache(sKey, oPreNextDocuments);
        }
        IPublishContent content = (IPublishContent)_context.getUpperHost();
        IPublishFolder folder = content.getFolder();
        if (content.getModal() != 1 && content.getModal() != 3) {
            folder = content.getOriginalHome();
        }
        this.m_oCurrFolder = folder;
        Channel channel = (Channel)folder.getSubstance();
        int nNum = _context.getAttribute("NUM", 1);
        String sWhere = _context.getAttribute("where");
        Documents[] pResult = oPreNextDocuments.getPreNextDocuments(channel, (Document)content.getSubstance(), nNum, sWhere);
        Documents documents = null;
        if (pResult != null) {
            documents = pResult[this.getCurrMode()];
            documents.setSelect(this.getSelectFields(_context));
        } else {
            documents = new Documents(null);
        }
        return documents;
    }

    @Override
    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj content = upperHost.getSubstance();
        return content instanceof Document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getSelectFields(PublishTagContext _tagContext) {
        TagItem m_tagItem = _tagContext.getTagItem();
        String sSelectFields = m_tagItem.getExtraAttributeValue("SELECT");
        if (sSelectFields == null) {
            TagItem tagItem = m_tagItem;
            synchronized (tagItem) {
                sSelectFields = m_tagItem.getExtraAttributeValue("SELECT");
                if (sSelectFields == null) {
                    sSelectFields = this.makeSelectFields(_tagContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("SelectFields:" + sSelectFields));
                    }
                    m_tagItem.setExtraAttribute("SELECT", sSelectFields);
                }
            }
        }
        return sSelectFields;
    }

    private String makeSelectFields(PublishTagContext _tagContext) {
        String sSelectFields = (String)FIELDS_DEFAULT_LIST.get(0);
        int nSize = FIELDS_DEFAULT_LIST.size();
        for (int i = 1; i < nSize; ++i) {
            sSelectFields = sSelectFields + "," + FIELDS_DEFAULT_LIST.get(i);
        }
        ArrayList listChildFields = TagParseHelper.makeSelectFields(_tagContext.getTagItem(), "TRS_DOCUMENT");
        DBManager dbMgr = DBManager.getDBManager();
        int nSize2 = listChildFields.size();
        for (int i = 0; i < nSize2; ++i) {
            String sFieldName = (String)listChildFields.get(i);
            if (FIELDS_DEFAULT_LIST.indexOf(sFieldName) >= 0) continue;
            String sMapField = (String)FIELDS_MAP.get(sFieldName);
            if (sMapField != null) {
                sFieldName = sMapField;
            }
            try {
                if (dbMgr.getFieldInfo("WCMDOCUMENT", sFieldName) == null) {
                    _tagContext.addWarning(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label2", "TRS_DOCUMENT\u7f6e\u6807\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label3", "]\u5728WCMDocument\u8868\u4e2d\u4e0d\u5b58\u5728\uff01"));
                    continue;
                }
            }
            catch (WCMException ex) {
                ex.printStackTrace();
                try {
                    _tagContext.addWarning(I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label4", "\u83b7\u53d6\u6307\u5b9a\u7684Field[") + sFieldName + I18NMessage.get(BaseWCMTagParserPreNextDocuments.class, "BaseWCMTagParserPreNextDocuments.label5", "]\u4eceWCMDocument\u8868\u4e2d\u53d1\u751f\u5f02\u5e38\uff01") + CMyException.getStackTraceText(ex));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            sSelectFields = sSelectFields + "," + sFieldName;
        }
        return sSelectFields;
    }

    static {
        FIELDS_DEFAULT_LIST.add("DOCID");
        FIELDS_DEFAULT_LIST.add("DOCCHANNEL");
        FIELDS_DEFAULT_LIST.add("DOCTYPE");
        FIELDS_DEFAULT_LIST.add("DOCTITLE");
        FIELDS_DEFAULT_LIST.add("CRUSER");
        FIELDS_DEFAULT_LIST.add("CRTIME");
        FIELDS_DEFAULT_LIST.add("DocFlag");
        FIELDS_DEFAULT_LIST.add("DocKind");
        FIELDS_DEFAULT_LIST.add("TITLECOLOR");
        FIELDS_DEFAULT_LIST.add("DOCLINK");
        FIELDS_DEFAULT_LIST.add("DOCFILENAME");
        FIELDS_DEFAULT_LIST.add("DOCVERSION");
        FIELDS_MAP = new HashMap(3);
        FIELDS_MAP.put("DOCFROM", "DOCSOURCE");
        FIELDS_MAP.put("DOCHTMLCON", "DOCPUBHTMLCON");
        FIELDS_MAP.put("DOCHTMLCONTENT", "DOCPUBHTMLCON");
        s_TagBeanInfo = null;
    }
}

