/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.region;

import com.trs.ajaxservice.xmlconvertors.XMLToCMSObj;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.region.CellInfo;
import com.trs.components.wcm.publish.region.CellInfos;
import com.trs.components.wcm.publish.region.RegionInfo;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class CellServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _oContext) throws Throwable {
    }

    @Override
    public Object query(MethodContext _oContext) throws Throwable {
        int nRegionInfoId = _oContext.getValue("RegionInfoId", 0);
        RegionInfo regionInfo = RegionInfo.findById(nRegionInfoId);
        if (regionInfo == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + nRegionInfoId + "]");
        }
        User loginUser = ContextHelper.getLoginUser();
        this.validRight(loginUser, regionInfo);
        return CellInfos.findCellInfos(regionInfo, _oContext.getExtraWCMFilter());
    }

    @Override
    public int save(MethodContext _oContext) throws Throwable {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCells(MethodContext _oContext) throws Throwable {
        int nRegionInfoId = _oContext.getValue("RegionInfoId", 0);
        RegionInfo regionInfo = RegionInfo.findById(nRegionInfoId);
        if (regionInfo == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bfc\u8bfb\u4e0d\u5b58\u5728[ID=" + nRegionInfoId + "]");
        }
        User loginUser = ContextHelper.getLoginUser();
        this.validRight(loginUser, regionInfo);
        XMLToCMSObj xmlToCMSObj = new XMLToCMSObj(loginUser, new CellInfo());
        xmlToCMSObj.parse(_oContext.getValue("CellsXML"));
        String sObjectIds = xmlToCMSObj.getObjectIds();
        if (CMyString.isEmpty(sObjectIds)) {
            throw new WCMException("\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u5bfc\u8bfb\u5185\u5bb9\uff1f");
        }
        WCMFilter filter = new WCMFilter("", "CELLINFOID not in(" + sObjectIds + ")", "");
        CellInfos cellInfos = CellInfos.findCellInfos(regionInfo, filter, loginUser);
        cellInfos.removeAll(true);
        boolean bException = true;
        try {
            int nSize = xmlToCMSObj.getCMSObjs().length;
            for (int i = 0; i < nSize; ++i) {
                CellInfo cellInfo = (CellInfo)xmlToCMSObj.getCMSObjs()[i];
                if (cellInfo == null) continue;
                if (cellInfo.isAddMode()) {
                    cellInfo.setRegionInfoId(nRegionInfoId);
                }
                cellInfo.save(loginUser);
            }
            bException = false;
        }
        finally {
            if (bException) {
                xmlToCMSObj.cancelUpdate();
            }
        }
    }

    private void validRight(User loginUser, RegionInfo _oRegionInfo) throws WCMException {
        int nChannelId = _oRegionInfo.getChannelId();
        int nWebSiteId = _oRegionInfo.getWebSiteId();
        Channel channel = Channel.findById(nChannelId);
        WebSite website = WebSite.findById(nWebSiteId);
        BaseChannel baseChannel = channel;
        if (baseChannel == null) {
            baseChannel = website;
        }
        if (baseChannel != null) {
            if (!AuthServer.hasRight(loginUser, (CMSObj)baseChannel, 48)) {
                throw new WCMException("\u60a8[" + loginUser.getName() + "]\u6ca1\u6709\u6743\u9650\u7ba1\u7406[" + baseChannel + "]\u7684\u5bfc\u8bfb\uff01");
            }
        } else {
            throw new WCMException("\u6307\u5b9a\u5bfc\u8bfb\u6240\u5728\u7684\u680f\u76ee[ID=" + nChannelId + "]\u548c\u7ad9\u70b9[ID=" + nWebSiteId + "\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public Object findById(MethodContext _oContext) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext _oContext) throws Throwable {
        return null;
    }
}

