/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.element;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.taskdispatch.IPublishElementsIterator;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementsCMSListImpl;
import com.trs.components.common.publish.persistent.element.PublishFolderImplBase;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.element.PublishElementsIteratorDocumentsImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PublishFolderWebSiteImpl
extends PublishFolderImplBase {
    private static Logger logger = Logger.getLogger(PublishFolderWebSiteImpl.class);
    private WebSite m_site = null;

    public PublishFolderWebSiteImpl() {
    }

    public PublishFolderWebSiteImpl(WebSite _site) {
        this.setSubstance(_site);
    }

    @Override
    public int getType() {
        return 103;
    }

    @Override
    public CMSObj getSubstance() {
        return this.m_site;
    }

    @Override
    public void setSubstance(CMSObj _cmsObj) {
        this.m_site = (WebSite)_cmsObj;
    }

    @Override
    public boolean loadById(int _nId) throws WCMException {
        this.m_site = WebSite.findById(_nId);
        return this.m_site != null;
    }

    @Override
    public IPublishElements getIncreasedContents(WCMFilter _filter) throws Exception {
        return null;
    }

    @Override
    public IPublishElements getPublishedContents(WCMFilter _filter) throws Exception {
        return null;
    }

    @Override
    public IPublishElements getAllContents(WCMFilter _filter) throws Exception {
        return null;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public String getLinkUrl() {
        return null;
    }

    @Override
    public int getId() {
        return this.m_site == null ? 0 : this.m_site.getId();
    }

    @Override
    public boolean isRoot() {
        return true;
    }

    @Override
    public IPublishFolder getRoot() {
        if (this.m_site == null) {
            return null;
        }
        return new PublishFolderWebSiteImpl(this.m_site);
    }

    @Override
    public void makeFrom(CMSObj _cmsObj) {
        this.m_site = (WebSite)_cmsObj;
    }

    @Override
    public IPublishFolder getParent() {
        return null;
    }

    @Override
    public IPublishElements getChildren() throws WCMException {
        List<Channel> children = this.m_site.getChildren(ContextHelper.getLoginUser());
        if (children == null) {
            return null;
        }
        return new PublishElementsCMSListImpl(children);
    }

    @Override
    public int getSiblingIndex() throws WCMException {
        return this.m_site.getSiblingIndex();
    }

    @Override
    public boolean validateCanDoPub() throws WCMException {
        FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
        if (folderConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label1", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label2", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
        return true;
    }

    @Override
    public boolean canDoOutlinePageTask() {
        return this.m_site != null && !this.m_site.isDeleted();
    }

    @Override
    public boolean canDoDetailPageTask() {
        return true;
    }

    @Override
    public boolean isValidElement() {
        try {
            this.validateCanDoPub();
        }
        catch (WCMDatainvalidException e) {
            return false;
        }
        catch (WCMException e) {
            logger.error((Object)(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label3", "\u5224\u65ad\u53d1\u5e03\u5143\u7d20:") + this.getInfo() + I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label4", "\u7684\u6709\u6548\u6027\u5931\u8d25!")), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void validateCanDoPreview() throws WCMException {
        FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
        if (folderConfig == null) {
            throw new WCMDatainvalidException(200001, CMyString.format(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label1", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u53d1\u5e03\u5c5e\u6027!"), new String[]{this.getInfo()}));
        }
        Templates templates = this.getOutlineTemplates();
        if (templates == null || templates.isEmpty()) {
            throw new WCMDatainvalidException(200002, CMyString.format(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label2", "[{0}]\u6ca1\u6709\u8bbe\u7f6e\u6982\u89c8\u6a21\u677f\uff01"), new String[]{this.getInfo()}));
        }
    }

    @Override
    public boolean canDoPreview() {
        try {
            FolderPublishConfig folderConfig = FolderPublishConfig.findOf(this);
            if (folderConfig == null) {
                return false;
            }
            return !this.getOutlineTemplates().isEmpty();
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label5", "\u5224\u65ad ") + this.getInfo() + I18NMessage.get(PublishFolderWebSiteImpl.class, "PublishFolderWebSiteImpl.label6", " \u662f\u5426\u53ef\u4ee5\u9884\u89c8\u53d1\u751f\u5f02\u5e38\uff01")), (Throwable)e);
            return false;
        }
    }

    @Override
    public IPublishElementsIterator getIncreasedContentsIterator(WCMFilter _filter) throws Exception {
        String sWhere = "exists(select ChannelId from WCMChannel where WCMDocument.DocChannel=WCMChannel.Channelid and SiteId=?) and DocStatus>0";
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", sWhere, "", "*");
        filter.addSearchValues(0, this.getId());
        return new PublishElementsIteratorDocumentsImpl(filter);
    }

    @Override
    public IPublishElementsIterator getPublishedContentsIterator(WCMFilter _filter) throws Exception {
        String sWhere = "exists(select ChannelId from WCMChannel where WCMDocument.DocChannel=WCMChannel.Channelid and SiteId=?) and DocStatus=Status.STATUS_ID_PUBLISHED";
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", sWhere, "", "*");
        filter.addSearchValues(0, this.getId());
        return new PublishElementsIteratorDocumentsImpl(filter);
    }

    @Override
    public IPublishElementsIterator getAllContentsIterator(WCMFilter _filter) throws Exception {
        String sWhere = "exists(select ChannelId from WCMChannel where WCMDocument.DocChannel=WCMChannel.Channelid and SiteId=?)";
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", sWhere, "", "*");
        filter.addSearchValues(0, this.getId());
        return new PublishElementsIteratorDocumentsImpl(filter);
    }

    @Override
    public boolean canDoBatchDetailPageTask() {
        return true;
    }

    @Override
    public boolean isCanDoSave(User _loginUser) throws WCMException {
        return AuthServer.hasRight(_loginUser, (CMSObj)this.m_site, 1);
    }

    @Override
    public boolean isDeleted() {
        return this.m_site.isDeleted();
    }

    @Override
    public Collection getFoldersQuotingMe() {
        return null;
    }

    @Override
    public void setPublishStatus(int _nStatus) throws WCMException {
        if (_nStatus == 10) {
            String sUpdatePublishedDocumentDocChannel = "update WCMDocument set DocStatus=? where exists(select ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ChannelId=WCMDocument.DocChannel) and DocStatus=?";
            String sUpdatePublishedChnlDocChnlId = "update WCMChnlDoc set DocStatus=?, PubStatus = ? where exists(select ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ChannelId=WCMChnlDoc.ChnlId) and DocStatus=?";
            String sUpdateChnlDocDocChannel = "update WCMChnlDoc set DocStatus=?, PubStatus = ? where exists(select ChannelId from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ChannelId=WCMChnlDoc.DocChannel) and DocStatus=?";
            int[] documentParams = new int[]{16, this.m_site.getId(), 10};
            int[] chnlDocParams = new int[]{16, MetaDataConstants.PubStatusEnum.NOTPUBLISHED.value, this.m_site.getId(), 10};
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdatePublishedDocumentDocChannel}, documentParams);
            DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdatePublishedChnlDocChnlId, sUpdateChnlDocDocChannel}, chnlDocParams);
        }
    }
}

