/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.domain.job;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.BaseStatefulScheduleWorker;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.LogServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.log4j.Logger;

public class WithDrawJobWorker
extends BaseStatefulScheduleWorker {
    private static final Logger logger = Logger.getLogger(WithDrawJobWorker.class);
    private static int m_nWorkerId = 0;
    private int m_nSenderType;
    private int m_nSenderId;
    private User m_oScheduleUser;

    protected boolean analyzeParams() {
        try {
            this.m_nSenderType = Integer.parseInt(this.getArgAsString("SenderType"));
            this.m_nSenderId = Integer.parseInt(this.getArgAsString("SenderId"));
            String userName = this.getArgAsString("CrUser");
            ContextHelper.initContext(User.getSystem());
            this.m_oScheduleUser = User.findByName(userName);
            if (this.m_oScheduleUser == null) {
                this.m_oScheduleUser = User.getSystem();
            }
            ContextHelper.setLoginUser(this.m_oScheduleUser);
            return true;
        }
        catch (Exception ex) {
            logger.error((Object)"excute schedule publish failed", (Throwable)ex);
            return false;
        }
    }

    @Override
    protected void execute() throws WCMException {
        if (!this.analyzeParams()) {
            throw new WCMException(1100, "analyze fail");
        }
        ContextParameters.set(7, Boolean.TRUE);
        ContextHelper.setArg(LogServer.CONTEXT_INDEX_IP, "127.0.0.1");
        PublishServer server = PublishServer.getInstance();
        IPublishElement element = PublishElementFactory.lookupElement(this.m_nSenderType, this.m_nSenderId);
        if (element == null) {
            logger.error((Object)"publish failed,no element to publish!");
            return;
        }
        logger.info((Object)("auto withdraw[" + element.getInfo() + "] begin...."));
        if (element instanceof IPublishContent) {
            try {
                IPublishContent content = (IPublishContent)element;
                IPublishElements contents = PublishElementFactory.lookupElements(this.m_nSenderType, String.valueOf(this.m_nSenderId));
                IPublishFolder folder = content.getOriginalHome();
                server.deleteContents(contents, folder, this.getQuotedFolders());
            }
            catch (Exception e) {
                logger.error((Object)("schedule publish[" + element.getInfo() + "] failed!"), (Throwable)e);
                throw new WCMException(1100, "Failed to revoke on schedule", e);
            }
        } else if (element instanceof IPublishFolder) {
            IPublishFolder folder = (IPublishFolder)element;
            if (folder.isDeleted()) {
                return;
            }
            try {
                server.publishFolder(folder, 7);
                server.deleteFolder(folder, true);
            }
            catch (Exception e) {
                logger.error((Object)("schedule publish[" + element.getInfo() + "] failed!"), (Throwable)e);
                throw new WCMException(1100, "Failed to revoke on schedule", e);
            }
        } else {
            logger.error((Object)("schedule publish[" + element.getInfo() + "] failed,not a valid element!"));
        }
        logger.info((Object)("auto withdraw[" + element.getInfo() + "] end."));
        this.clearSchedule(element.getSubstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IPublishElements getQuotedFolders() {
        String sql = "select chnlid from wcmchnldoc where docid=? and modal>=2";
        StringBuffer buff = new StringBuffer(32);
        buff.append(',');
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        DBManager dbmanager = DBManager.getDBManager();
        try {
            conn = dbmanager.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, this.m_nSenderId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                buff.append(rs.getInt(1)).append(',');
            }
            if (buff.length() > 1) {
                Channels channels = Channels.findByIds(this.m_oScheduleUser, buff.substring(1));
                IPublishElements iPublishElements = PublishElementFactory.makeElementsFrom(channels);
                return iPublishElements;
            }
        }
        catch (Exception ex) {
            logger.warn((Object)"get quoted folders fail.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbmanager.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private void clearSchedule(BaseObj sender) {
        try {
            Schedule schedule;
            if (sender == null) {
                return;
            }
            if (m_nWorkerId == 0) {
                JobWorkerType worker = JobWorkerType.findByClassName(WithDrawJobWorker.class.getName());
                if (worker == null) {
                    return;
                }
                m_nWorkerId = worker.getId();
            }
            if ((schedule = Schedule.findBySender(m_nWorkerId, sender)) != null) {
                schedule.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

