/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class WCMFolderPublishConfigLCListener
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(WCMFolderPublishConfigLCListener.class);

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (this.isListening(_oObjModified)) {
            int nFolderType = _oObjModified.getWCMType();
            int nFolderId = _oObjModified.getId();
            WCMFolderPublishConfig conf = WCMFolderPublishConfig.findOf(_oObjModified.getWCMType(), _oObjModified.getId());
            int nParentId = _oObjModified.getNewPropertyAsInt("PARENTID", 0);
            if (conf != null) {
                Templates templates;
                IPublishFolder folder = (IPublishFolder)PublishElementFactory.lookupElement(nFolderType, nFolderId);
                String sFolderIds = this.getParentIdChain(nParentId) + nFolderId;
                TemplateEmployMgr employMgr = conf.getTemplateEmployMgr();
                DBManager dbmanager = DBManager.getDBManager();
                Template detail = employMgr.getDetailTemplate(folder);
                if (detail != null && !this.isExistsTemplate(sFolderIds, detail, dbmanager)) {
                    employMgr.setDetailTemplate(folder, 0, true);
                }
                if ((templates = employMgr.getOutlineTemplates(folder)).isEmpty()) {
                    return;
                }
                String outlines = "";
                boolean zChanged = false;
                for (int i = 0; i < templates.size(); ++i) {
                    Template template = (Template)templates.getAt(i);
                    if (this.isExistsTemplate(sFolderIds, template, dbmanager)) {
                        outlines = outlines + "," + template.getId();
                        continue;
                    }
                    zChanged = true;
                }
                if ("".equals(outlines)) {
                    outlines = "0";
                    zChanged = true;
                }
                if (zChanged) {
                    employMgr.setOutlineTemplates(folder, outlines, true);
                }
            }
        }
    }

    private boolean isExistsTemplate(String _sFolderIds, Template _template, DBManager _manager) {
        if (_template == null) {
            return false;
        }
        try {
            if (_template.getFolder().isRoot()) {
                return true;
            }
            String sSql = "SELECT TEMPID FROM WCMTEMPLATE WHERE TEMPID=" + _template.getId() + " and FolderType=" + 101 + " and FolderId in(" + _sFolderIds + ")";
            return _manager.sqlExecuteIntQuery(sSql) > 0;
        }
        catch (Exception e) {
            s_logger.error((Object)"template exists checked failed", (Throwable)e);
            return false;
        }
    }

    private boolean isListening(BaseObj _obejct) {
        return this.isValidInstance(_obejct) && this.isNotifyNeeded((Channel)_obejct);
    }

    private boolean isValidInstance(BaseObj _obejct) {
        return _obejct != null && _obejct instanceof Channel;
    }

    private boolean isNotifyNeeded(Channel _channel) {
        return _channel.isChangeProperty("PARENTID") && !this.isSpecial(_channel);
    }

    private boolean isSpecial(Channel _channel) {
        return 1 == _channel.getType() || 2 == _channel.getType();
    }

    private String getParentIdChain(int _nChildId) throws WCMException {
        String ids = "";
        if (_nChildId != 0) {
            Channel channel = Channel.findById(_nChildId);
            ids = ids + _nChildId + "," + this.getParentIdChain(channel.getParentId());
        }
        return ids;
    }

    public static void main(String[] args) {
        WCMFolderPublishConfigLCListener l = new WCMFolderPublishConfigLCListener();
        try {
            System.out.println("test:" + l.getParentIdChain(12));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

