/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class WCMFolderLCListener
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(WCMFolderLCListener.class);

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        if (!(_oObjDeleted instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label2", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        BaseChannel baseChannel = (BaseChannel)_oObjDeleted;
        try {
            WCMPubStatusConfig statusConfig = WCMPubStatusConfig.findOf(baseChannel.getWCMType(), baseChannel.getId());
            if (statusConfig != null) {
                statusConfig.delete(ContextHelper.getLoginUser());
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label3", "\u5220\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label4", "]\u53ef\u53d1\u5e03\u72b6\u6001\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!")), e);
        }
        try {
            User currUser = User.getSystem();
            try {
                currUser = ContextHelper.getLoginUser();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Schedules schedules = new Schedules(currUser);
            WCMFilter filter = new WCMFilter("", "", "");
            filter.setWhere("SENDERTYPE=? and SENDERID=?");
            filter.addSearchValues(baseChannel.getWCMType());
            filter.addSearchValues(baseChannel.getId());
            schedules.open(filter);
            schedules.removeAll(true);
        }
        catch (Throwable e) {
            logger.error((Object)"clear schedule on object delete failed.", e);
        }
        if (baseChannel.isDeleted()) {
            return;
        }
        try {
            PageDestroyer.withdraw((IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel), null);
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label5", "\u540c\u6b65\u64a4\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label6", "]\u53d1\u5e03\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff01")), e);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
        if (!(_oObjModified instanceof BaseChannel)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label7", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        BaseChannel baseChannel = (BaseChannel)_oObjModified;
        int nNewStatus = baseChannel.getNewPropertyAsInt("STATUS", 0);
        boolean bLogicDelete = nNewStatus == -1;
        boolean bMoveToOtherSite = baseChannel.isChangeProperty("SITEID");
        IPublishFolder folder = null;
        try {
            folder = (IPublishFolder)PublishElementFactory.makeElementFrom(baseChannel);
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label8", "\u6784\u9020[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label9", "]Folder\u51fa\u73b0\u5f02\u5e38\uff01")), e);
        }
        try {
            if (bLogicDelete || bMoveToOtherSite) {
                PublishServer.getInstance().deleteFolder(folder, false);
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label5", "\u540c\u6b65\u64a4\u9664[") + baseChannel.getInfo() + I18NMessage.get(WCMFolderLCListener.class, "WCMFolderLCListener.label6", "]\u53d1\u5e03\u76ee\u5f55\u51fa\u73b0\u5f02\u5e38\uff01")), e);
        }
    }
}

