/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class DocumentLCListenerForPublish
implements IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForPublish.class);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (_oObjModified == null || !(_oObjModified instanceof Document)) {
            return;
        }
        Document document = (Document)_oObjModified;
        this.changeStatusIfNesscerray(document);
    }

    private void changeStatusIfNesscerray(Document _document) throws WCMException {
        if (_document.isModified() && (_document.isChangeProperty("FLOWOPERATIONMARK") || _document.isChangeProperty("FLOWOPERATIONMARK") || _document.isChangeProperty("FLOWOPERATIONMASKENUM"))) {
            return;
        }
        if (_document.isModified() && !_document.isChangeProperty("DocStatus")) {
            int nChannelId = _document.getChannelId();
            if (_document.isChangeProperty("DocChannel")) {
                nChannelId = _document.getNewPropertyAsInt("DocChannel", 0);
            }
            if (nChannelId < 0) {
                return;
            }
            Channel channel = Channel.findById(nChannelId);
            if (channel == null) {
                return;
            }
            if (10 == _document.getStatusId()) {
                int nStatusId = 1027;
                String sUpdateChnlDocSql = "UPDATE WCMChnlDoc SET DocStatus=" + nStatusId + ",DocPubTime=null WHERE DocId=" + _document.getDocId() + " AND DocStatus=" + 10 + " AND ChnlId>0";
                String sUpdateDocumentSql = "UPDATE WCMDocument SET DocStatus=" + nStatusId + ",DocPubTime=null WHERE DocId=" + _document.getDocId();
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocSql, sUpdateDocumentSql});
                String isPageDestroy = ConfigServer.getServer().getSysConfigValue("PageDestroyWhenModifyPublishStatusDoc", "false");
                if (isPageDestroy.equalsIgnoreCase("true") || isPageDestroy.equalsIgnoreCase("1")) {
                    this.onChangePublishedChnlDocStatus(_document);
                }
            }
        }
    }

    private void onChangePublishedChnlDocStatus(Document document) throws WCMException {
        Channel currChannel = document.getChannel();
        Channels needRefreshPubChannels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=1027");
        if (needRefreshPubChannels == null) {
            needRefreshPubChannels = new Channels(null, 1, 1);
        }
        needRefreshPubChannels.addElement(currChannel);
        IPublishContent content = PublishElementFactory.makeContentFrom(document, null);
        int nSize = needRefreshPubChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)needRefreshPubChannels.getAt(i);
            if (channel == null) continue;
            IPublishFolder quotedFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            content.setFolder(quotedFolder);
            try {
                if (content.getModal() != 2) {
                    PageDestroyer.withdraw(content, null);
                }
            }
            catch (Exception ex) {
                logger.error((Object)("withdraw detail fail:" + content.getInfo()), (Throwable)ex);
            }
            PublishServer.getInstance().publishFolder(quotedFolder, 12);
        }
    }
}

