/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.publisher.PageDestroyer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.PreNextPageRefresher;
import com.trs.components.wcm.publish.WCMPubStatusConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ChnlDocLCListnerForPublish
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ChnlDocLCListnerForPublish.class);
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        if (!(_oObjDeleted instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label2", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)_oObjDeleted;
        int nStatusId = chnlDoc.getStatusId();
        if (nStatusId < 0 || nStatusId != 10) {
            return;
        }
        try {
            this.destroyChnlDoc(chnlDoc);
        }
        catch (Throwable e) {
            logger.error((Object)I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label3", "\u6587\u6863\u5220\u9664\u64a4\u56de\u7a3f\u4ef6\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
        if (!(_oObjModified instanceof ChnlDoc)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        ChnlDoc chnlDoc = (ChnlDoc)_oObjModified;
        if (!chnlDoc.isChangeProperty("DOCSTATUS") && !chnlDoc.isChangeProperty("CHNLID")) {
            return;
        }
        this.onMovePublishedChnlDoc(chnlDoc);
        try {
            this.onChangePublishedChnlDocStatus(chnlDoc);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label5", "\u72b6\u6001\u89e6\u53d1\u7684\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\uff01"), (Throwable)e);
        }
        this.refreshPreNextPagesIfNeed(chnlDoc);
    }

    protected void refreshPreNextPagesIfNeed(ChnlDoc chnlDoc) {
        try {
            if (chnlDoc.getModal() == 2 || chnlDoc.isChangeProperty("CHNLID") || !chnlDoc.isPublished() || ContextParameters.get(0, true) == Boolean.TRUE) {
                return;
            }
            PreNextPageRefresher refresher = new PreNextPageRefresher(chnlDoc.getDocument());
            refresher.refresh();
        }
        catch (Exception e) {
            logger.error((Object)"refresh prenext detail pages failed.", (Throwable)e);
        }
    }

    private void onMovePublishedChnlDoc(ChnlDoc _chnlDoc) {
        int nNewChnlId = _chnlDoc.getNewPropertyAsInt("ChnlId", 0);
        if (_chnlDoc.isDeleted() || !_chnlDoc.isChangeProperty("CHNLID") || nNewChnlId <= 0 || !_chnlDoc.isPublished()) {
            return;
        }
        boolean bKeepPublishedStatus = true;
        try {
            bKeepPublishedStatus = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("KEEP_PUBLISH_STATUS_MOVE", "true").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Channel newChannel = Channel.findById(nNewChnlId);
            if (newChannel == null) {
                return;
            }
            Channel oldChannel = _chnlDoc.getChannel();
            if (oldChannel == null) {
                return;
            }
            Document document = null;
            boolean bNeedDeleteDetailPage = false;
            if (_chnlDoc.isEntity() || _chnlDoc.getModal() == 3) {
                document = _chnlDoc.getDocument();
                if (document == null) {
                    return;
                }
                bNeedDeleteDetailPage = true;
                document.getProperties().put("MODAL", _chnlDoc.getProperty("Modal"));
            }
            IPublishFolder newFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(newChannel);
            Channels needRefreshPubChannels = null;
            if (bKeepPublishedStatus && newFolder.canDoDetailPageTask()) {
                if (bNeedDeleteDetailPage) {
                    IPublishContent newContent = PublishElementFactory.makeContentFrom(document, newFolder);
                    PublishServer.getInstance().publishContent(newContent);
                    needRefreshPubChannels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=10");
                    if (needRefreshPubChannels.indexOf(newChannel.getId()) < 0) {
                        needRefreshPubChannels.addElement(newChannel);
                    }
                    this.withdraw(oldChannel, document);
                    if (needRefreshPubChannels.indexOf(oldChannel.getId()) < 0) {
                        needRefreshPubChannels.addElement(oldChannel);
                    }
                } else {
                    needRefreshPubChannels = new Channels(null, 2, 1);
                    needRefreshPubChannels.addElement(oldChannel);
                    needRefreshPubChannels.addElement(newChannel);
                }
            } else {
                if (_chnlDoc.isEntity()) {
                    needRefreshPubChannels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus=10");
                }
                this.changePublishedStatus(_chnlDoc, newChannel.getSiteId());
                if (bNeedDeleteDetailPage) {
                    this.withdraw(oldChannel, document);
                }
                if (needRefreshPubChannels == null) {
                    needRefreshPubChannels = new Channels(null, 1, 1);
                }
                needRefreshPubChannels.addElement(oldChannel);
            }
            int nSize = needRefreshPubChannels.size();
            for (int i = 0; i < nSize; ++i) {
                IPublishFolder quotedFolder;
                Channel channel = (Channel)needRefreshPubChannels.getAt(i);
                if (channel == null || !(quotedFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel)).canDoOutlinePageTask()) continue;
                PublishServer.getInstance().publishFolder(quotedFolder, 12);
            }
        }
        catch (Throwable e) {
            logger.error((Object)(I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label6", "\u79fb\u52a8\u6587\u6863\u65f6\u5019\u540c\u6b65\u53d1\u5e03\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38\uff01[DocId=") + _chnlDoc.getDocId() + ", FromChannel=" + _chnlDoc.getChannelId() + ", ToChannel=" + nNewChnlId + "]"), e);
        }
    }

    private void onChangePublishedChnlDocStatus(ChnlDoc _chnlDoc) throws WCMException {
        if (!_chnlDoc.isChangeProperty("DocStatus")) {
            return;
        }
        Channel currChannel = _chnlDoc.getChannel();
        if (currChannel == null) {
            return;
        }
        if (_chnlDoc.isDeleted()) {
            if (_chnlDoc.getStatusId() == -10) {
                this.changePublishedStatus(_chnlDoc, currChannel.getSiteId());
            }
            return;
        }
        if (!_chnlDoc.isPublished()) {
            return;
        }
        Document document = null;
        document = _chnlDoc.getDocument();
        if (document == null) {
            return;
        }
        boolean bNeedDeleteDetailPage = false;
        if (_chnlDoc.isEntity() || _chnlDoc.getModal() == 3) {
            bNeedDeleteDetailPage = true;
            document.getProperties().put("MODAL", _chnlDoc.getProperty("Modal"));
        }
        BaseObjs needRefreshPubChannels = null;
        if (_chnlDoc.isEntity()) {
            needRefreshPubChannels = this.m_oDocumentMgr.getQutoedChannels(document, 0, "DocStatus in(10,-10)", true);
        }
        if (bNeedDeleteDetailPage) {
            try {
                this.withdraw(currChannel, document);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to delete file.", (Throwable)e);
            }
        }
        if (needRefreshPubChannels == null) {
            needRefreshPubChannels = new Channels(null, 1, 1);
        }
        needRefreshPubChannels.addElement(currChannel);
        boolean zEntity = _chnlDoc.isEntity();
        IPublishContent content = PublishElementFactory.makeContentFrom(document, null);
        int nSize = needRefreshPubChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)needRefreshPubChannels.getAt(i);
            if (channel == null) continue;
            IPublishFolder quotedFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
            PublishServer.getInstance().publishFolder(quotedFolder, 12);
            if (!zEntity) continue;
            content.setFolder(quotedFolder);
            try {
                if (content.getModal() == 2) continue;
                PageDestroyer.withdraw(content, null);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)("withdraw detail fail:" + content.getInfo()), (Throwable)ex);
            }
        }
    }

    private void withdraw(Channel _oldChannel, Document _document) throws WCMException, Exception {
        IPublishFolder oldFolder = (IPublishFolder)PublishElementFactory.makeElementFrom(_oldChannel);
        IPublishContent oldContent = PublishElementFactory.makeContentFrom(_document, oldFolder);
        PageDestroyer.withdraw(oldContent, null);
    }

    private void changePublishedStatus(ChnlDoc _chnlDoc, int _nSitId) throws WCMException {
        int nTemp;
        WCMPubStatusConfig config = WCMPubStatusConfig.findOf(103, _nSitId);
        int nNewStatusId = 2;
        if (config != null && (nTemp = config.getStatusIdAfterModify()) != 0) {
            nNewStatusId = nTemp;
        }
        String sUpdateChnlDocSql = null;
        String sUpdateDocumentSql = null;
        int[] pParameters = null;
        if (_chnlDoc.isEntity()) {
            sUpdateChnlDocSql = "UPDATE WCMChnlDoc SET DocStatus=?,DocPubTime=null WHERE DocId=? and DocStatus=?";
            sUpdateDocumentSql = "UPDATE WCMDocument SET DocStatus=?,DocPubTime=null WHERE DocId=? and DocStatus=?";
            pParameters = new int[]{nNewStatusId, _chnlDoc.getDocId(), 10};
        } else {
            sUpdateChnlDocSql = "UPDATE WCMChnlDoc SET DocStatus=?,DocPubTime=null WHERE RecId=? and DocStatus=?";
            pParameters = new int[]{nNewStatusId, _chnlDoc.getId(), 10};
        }
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdateChnlDocSql, sUpdateDocumentSql}, pParameters);
    }

    private void destroyChnlDoc(ChnlDoc _chnlDoc) throws WCMException, Exception {
        if (_chnlDoc.getChannelId() < 0) {
            return;
        }
        Channel docChannel = _chnlDoc.getChannel();
        if (docChannel == null || docChannel.isDeleted()) {
            return;
        }
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.lookupElement(101, _chnlDoc.getChannelId());
        if (folder == null) {
            throw new WCMException(I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label7", "\u6ca1\u6709\u627e\u5230\u6587\u6863[Id=") + _chnlDoc.getDocId() + I18NMessage.get(ChnlDocLCListnerForPublish.class, "ChnlDocLCListnerForPublish.label8", "]\u6307\u5b9a\u7684folder[Id=") + _chnlDoc.getChannelId() + "]!");
        }
        IPublishElements contents = PublishElementFactory.lookupElements(605, String.valueOf(_chnlDoc.getDocId()));
        Channels linkedChannels = null;
        if (_chnlDoc.isEntity()) {
            linkedChannels = new Channels(null);
            StringBuffer sbWhere = new StringBuffer(64);
            sbWhere.append("DocId=").append(_chnlDoc.getDocId());
            sbWhere.append(" AND ChnlId>0 AND (");
            sbWhere.append("DocStatus=").append(10);
            sbWhere.append(" OR ");
            sbWhere.append("DocStatus=-").append(10);
            sbWhere.append(") AND NOT MODAL=").append(1);
            WCMFilter filter = new WCMFilter("WCMChnlDoc", sbWhere.toString(), "", "ChnlId AS ChannelId");
            linkedChannels.open(filter);
            linkedChannels.addElement(docChannel);
        }
        IPublishElements folders = null;
        if (linkedChannels != null && !linkedChannels.isEmpty()) {
            folders = PublishElementFactory.makeElementsFrom(linkedChannels);
            IPublishContent content = (IPublishContent)contents.get(0);
            for (int i = 0; i < folders.size(); ++i) {
                IPublishFolder quoteFolder = (IPublishFolder)folders.get(i);
                content.setFolder(quoteFolder);
                if (Math.abs(content.getModal()) != 3) continue;
                PageDestroyer.withdraw(content, null);
            }
        }
        final IPublishElements ffolders = folders;
        final IPublishFolder ffolder = folder;
        final IPublishElements fcontents = contents;
        final User currentUser = ContextHelper.getLoginUser();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    ContextHelper.setLoginUser(currentUser);
                    PublishServer.getInstance().deleteContents(fcontents, ffolder, ffolders, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.cancel();
            }
        }, 3000L);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        int nTemp;
        if (!this.isListening(_oObjAdded)) {
            return;
        }
        ChnlDoc chnldoc = (ChnlDoc)_oObjAdded;
        if (10 != chnldoc.getStatusId()) {
            return;
        }
        Channel channel = chnldoc.getChannel();
        if (channel == null) {
            return;
        }
        int nSiteId = channel.getSiteId();
        WCMPubStatusConfig config = WCMPubStatusConfig.findOf(103, nSiteId);
        int nStatusId = 2;
        if (config != null && (nTemp = config.getStatusIdAfterModify()) != 0) {
            nStatusId = nTemp;
        }
        String[] sSql = new String[]{"UPDATE WCMCHNLDOC SET DocStatus=" + nStatusId + " WHERE RecId=" + chnldoc.getId(), "UPDATE WCMDOCUMENT SET DocStatus=" + nStatusId + " WHERE DocId=" + chnldoc.getDocId() + " AND DocStatus=" + 10 + " AND DocChannel=" + chnldoc.getChannelId()};
        DBManager.getDBManager().sqlExecuteUpdate(sSql);
    }

    private boolean isListening(BaseObj _object) {
        return _object != null && _object instanceof ChnlDoc;
    }
}

