/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.process;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowEmploy;
import com.trs.cms.process.definition.FlowEmployMgr;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class ChannelLCListenerForFlow
implements IObjectLCListenerOnModify {
    private static Logger s_logger = Logger.getLogger(ChannelLCListenerForFlow.class);
    private FlowServer m_oFlowServer = null;

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!(_oObjModified instanceof Channel)) {
            s_logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(ChannelLCListenerForFlow.class, "ChannelLCListenerForFlow.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(ChannelLCListenerForFlow.class, "ChannelLCListenerForFlow.label2", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        BaseObjs fes = null;
        Channel channel = (Channel)_oObjModified;
        int nNewStatusId = channel.getNewPropertyAsInt("STATUS", 0);
        if (nNewStatusId == -1 || nNewStatusId == -2) {
            fes = this.getFlowEmployMgr().getEmploysOfEmployer(101, channel.getId());
        }
        if (fes == null || fes.size() <= 0) {
            return;
        }
        for (int i = 0; i < fes.size(); ++i) {
            Flow flow;
            FlowEmploy fe = (FlowEmploy)fes.getAt(i);
            if (fe == null || (flow = fe.getFlow()) == null) continue;
            this.deleteFolwDocInFlow(flow, channel.getId());
        }
        this.deleteFolwDocBak(channel.getId());
    }

    private void deleteFolwDocInFlow(Flow flow, int iChannelId) throws WCMException {
        if (flow == null) {
            return;
        }
        String sWhere = "exists(select NodeId from WCMFlowNode where WCMFlowDoc.NodeId=NodeId and FlowId=" + flow.getId() + ")";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        FlowDocs flowDocs = FlowDocs.openWCMObjs(User.getSystem(), aFilter);
        if (flowDocs == null || flowDocs.size() <= 0) {
            return;
        }
        for (int i = 0; i < flowDocs.size(); ++i) {
            FlowDoc flowDoc = (FlowDoc)flowDocs.getAt(i);
            if (flowDoc == null) continue;
            this.deleteFolwDoc(flowDoc, iChannelId);
        }
    }

    private void deleteFolwDoc(FlowDoc flowDoc, int iChannelId) throws WCMException {
        if (flowDoc == null) {
            return;
        }
        IFlowContent content = flowDoc.getFlowContent();
        if (content == null || content.getContentType() != 605) {
            return;
        }
        Document currDocument = (Document)content.getSubinstance();
        if (currDocument == null || currDocument.getChannelId() != iChannelId) {
            return;
        }
        this.getFlowServer().removeFlowDoc(flowDoc.getContentType(), flowDoc.getContentId());
    }

    private void deleteFolwDocBak(int iChannelId) throws WCMException {
        String sSql1 = "DELETE FROM WCMFLOWDOCBAK where EXISTS(SELECT DOCID FROM WCMCHNLDOC WHERE WCMCHNLDOC.DOCID=WCMFLOWDOCBAK.OBJID and WCMCHNLDOC.CHNLID=" + -iChannelId + ")";
        String sSql2 = "DELETE FROM WCMFLOWDOC where EXISTS(SELECT DOCID FROM WCMCHNLDOC WHERE WCMCHNLDOC.DOCID=WCMFLOWDOC.OBJID and WCMCHNLDOC.CHNLID=" + -iChannelId + ")";
        DBManager dbMgr = DBManager.getDBManager();
        dbMgr.sqlExecuteUpdate(new String[]{sSql1, sSql2});
    }

    private FlowEmployMgr getFlowEmployMgr() {
        return (FlowEmployMgr)DreamFactory.createObjectById("FlowEmployMgr");
    }

    private FlowServer getFlowServer() throws WCMException {
        if (this.m_oFlowServer == null) {
            this.m_oFlowServer = FlowServer.getFlowServer();
        }
        return this.m_oFlowServer;
    }
}

