/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.filter;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.publisher.PublishTaskContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagDocumentReader;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.advisor.AdvisorCenterServiceProvider;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.filter.Filter;
import com.trs.components.wcm.filter.FilterExporter;
import com.trs.components.wcm.filter.FilterImporter;
import com.trs.components.wcm.filter.FilterMgr;
import com.trs.components.wcm.filter.FilterOption;
import com.trs.components.wcm.filter.FilterOptionGroup;
import com.trs.components.wcm.filter.FilterOptionGroups;
import com.trs.components.wcm.filter.FilterOptions;
import com.trs.components.wcm.filter.Filters;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class FilterCenterServiceProvider
implements IGlueServiceProvider {
    private FilterMgr m_oFilterMgr = (FilterMgr)DreamFactory.createObjectById("FilterMgr");

    public FilterOptionGroups queryFilterOptionGroupsByFilter(MethodContext context) throws Throwable {
        int nFilterId = context.getObjectId();
        Filter oFilter = Filter.findById(nFilterId);
        if (oFilter == null) {
            throw new WCMException(10, I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label1", "\u8fc7\u6ee4\u5668\u5bf9\u8c61\u65e0\u6548\uff0c\u65e0\u6cd5\u83b7\u53d6\u5176\u9009\u9879\u7ec4\uff01"));
        }
        this.validRight(oFilter, this.getLoginUser(), 14);
        return this.m_oFilterMgr.queryGroupsByFilter(oFilter, null);
    }

    public FilterOptions queryFilterOptionsByGroup(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nGroupId = context.getObjectId();
        FilterOptionGroup oOptionGroup = FilterOptionGroup.findById(nGroupId);
        if (oOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nGroupId), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(oOptionGroup, 0, loginUser, 14);
        return this.m_oFilterMgr.queryFilterOptionsByGroup(oOptionGroup, null);
    }

    public FilterOptions queryOtherOptions(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionId = context.getValue("OptionId", 0);
        FilterOption filterOption = FilterOption.findById(nOptionId);
        int nGroupId = filterOption.getGroupId();
        FilterOptionGroup oOptionGroup = FilterOptionGroup.findById(nGroupId);
        if (oOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nGroupId), WCMTypes.getLowerObjName(1310565549)}));
        }
        int nFilterId = oOptionGroup.getFilterId();
        Filter oFilter = Filter.findById(nFilterId);
        if (oFilter == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nFilterId), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(oFilter, loginUser, 14);
        String sWhere = "FILTEROPTIONID <> ? AND GROUPID IN (SELECT FILTEROPTIONGROUPID FROM XWCMFILTEROPTIONGROUP WHERE FILTERID = ?)";
        WCMFilter filter = new WCMFilter("", sWhere, "GROUPID,FORDER");
        filter.addSearchValues(nOptionId);
        filter.addSearchValues(nFilterId);
        return FilterOptions.openWCMObjs(null, filter);
    }

    public FilterOptions queryOptionsByFilter(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFilterId = context.getValue("FilterId", 0);
        Filter oFilter = Filter.findById(nFilterId);
        if (oFilter == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nFilterId), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(oFilter, loginUser, 14);
        String sWhere = "GROUPID IN (SELECT FILTEROPTIONGROUPID FROM XWCMFILTEROPTIONGROUP WHERE FILTERID = ?)";
        WCMFilter filter = new WCMFilter("", sWhere, "GROUPID,FORDER");
        filter.addSearchValues(nFilterId);
        return FilterOptions.openWCMObjs(null, filter);
    }

    public int saveFilterOptionGroup(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFilterOptionGroupId = context.getObjectId();
        int nFilterId = context.getValue("FilterId", 0);
        FilterOptionGroup group = null;
        group = nFilterOptionGroupId == 0 ? new FilterOptionGroup() : FilterOptionGroup.findById(nFilterOptionGroupId);
        if (nFilterOptionGroupId == 0 && nFilterId == 0) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label2", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570FilterId\uff01"));
        }
        this.validGroup(group, nFilterId, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        group = (FilterOptionGroup)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, group, pLogicFields);
        group.save(loginUser);
        return group.getId();
    }

    public int saveFilter(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFilterId = context.getObjectId();
        Filter filter = nFilterId == 0 ? new Filter() : Filter.findById(nFilterId);
        this.validRight(filter, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        filter = (Filter)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, filter, pLogicFields);
        filter.save(loginUser);
        return filter.getId();
    }

    public int saveFilterOption(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOptionId = context.getObjectId();
        int nFilterOptionGroupId = context.getValue("GroupId", 0);
        FilterOption filterOption = null;
        filterOption = nOptionId == 0 ? new FilterOption() : FilterOption.findById(nOptionId);
        if (nOptionId == 0 && nFilterOptionGroupId == 0) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label3", "\u5fc5\u987b\u4f20\u5165\u53c2\u6570GroupId\uff01"));
        }
        this.validOption(filterOption, nFilterOptionGroupId, loginUser, 13);
        String[] pLogicFields = new String[]{"ObjectId"};
        filterOption = (FilterOption)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, filterOption, pLogicFields);
        filterOption.save(loginUser);
        return filterOption.getId();
    }

    public void deleteFilter(MethodContext context) throws WCMException {
        User loginUser = this.getLoginUser();
        String sFilterIds = context.getValue("FilterIds");
        Filters filters = Filters.findByIds(loginUser, sFilterIds);
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter filter = (Filter)filters.getAt(i);
            if (filter == null) continue;
            this.validRight(filter, loginUser, 13);
            this.m_oFilterMgr.deleteFilter(filter);
        }
    }

    public void deleteFilterOptionGroup(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFilterOptionGroupId = context.getObjectId();
        FilterOptionGroup currFilterOptionGroup = FilterOptionGroup.findById(nFilterOptionGroupId);
        if (currFilterOptionGroup == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nFilterOptionGroupId), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(currFilterOptionGroup, 0, loginUser, 13);
        this.m_oFilterMgr.deleteFilterOptionGroup(currFilterOptionGroup);
    }

    public void deleteFilterOption(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFilterOptionId = context.getObjectId();
        FilterOption currFilterOption = FilterOption.findById(nFilterOptionId);
        if (currFilterOption == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nFilterOptionId), WCMTypes.getLowerObjName(266112697)}));
        }
        this.validOption(currFilterOption, 0, loginUser, 13);
        this.m_oFilterMgr.deleteFilterOption(currFilterOption);
    }

    public void copy(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sFilterIds = context.getValue("FilterIds");
        String sChnlIds = context.getValue("ChannelIds");
        Channels channels = Channels.findByIds(loginUser, sChnlIds);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.validateRight(channel, loginUser, 13);
        }
        Filters filters = Filters.findByIds(loginUser, sFilterIds);
        for (int i = filters.size() - 1; i >= 0; --i) {
            Filter filter = (Filter)filters.getAt(i);
            if (filter == null) continue;
            this.validRight(filter, loginUser, 13);
            this.m_oFilterMgr.copy(filter, channels, loginUser);
        }
    }

    public String export(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sFilterIds = context.getValue("FilterIds");
        Filters filters = Filters.findByIds(loginUser, sFilterIds);
        int nSize = filters.size();
        for (int i = 0; i < nSize; ++i) {
            Filter filter = (Filter)filters.getAt(i);
            if (filter == null) continue;
            this.validRight(filter, loginUser, 14);
        }
        FilterExporter exporter = new FilterExporter();
        return exporter.export(filters);
    }

    public void importFilters(MethodContext context) throws Throwable {
        User loginUser = this.getLoginUser();
        int nImportType = context.getValue("ImportType", 1);
        int nChnlId = context.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChnlId);
        if (channel == null) {
            throw new WCMException("\u4f20\u5165\u7684\u680f\u76eeId[" + nChnlId + "]\u4e0d\u5b58\u5728");
        }
        this.validateRight(channel, loginUser, 13);
        String sImportFile = context.getValue("ImportFile");
        FilterImporter importer = new FilterImporter(nImportType, channel);
        importer.setImportToCurrChnl(context.getValue("ImportToCurrChnl", true));
        importer.importFromZip(sImportFile);
    }

    public void createXMLForFilter(MethodContext context) throws Throwable {
        int nChannelId = context.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChannelId);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelId), WCMTypes.getLowerObjName(101)}));
        }
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)channel, 13);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + nChannelId + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label5", "\u3011\u4e0b\u7684\u64cd\u4f5c\u7b5b\u9009\u5668\u4fe1\u606f\uff01 "));
        }
        String sFilterIds = context.getValue("FilterIds");
        if (CMyString.isEmpty(sFilterIds)) {
            this.createFilterXML(null, nChannelId, context);
            return;
        }
        int[] nFilterIds = CMyString.splitToInt(sFilterIds, ",");
        for (int i = 0; i < nFilterIds.length; ++i) {
            int nFilterId = nFilterIds[i];
            Filter oFilter = Filter.findById(nFilterId);
            this.createFilterXML(oFilter, nChannelId, context);
        }
    }

    protected IPublishElement makeElement(int _channelId) throws WCMException {
        IPublishElement pubElement = null;
        pubElement = PublishElementFactory.lookupElement(101, _channelId);
        if (pubElement == null) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label6", "\u6307\u5b9a\u7684\u680f\u76ee[Id=") + _channelId + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label7", "]\u4e0d\u5b58\u5728\uff01"));
        }
        return pubElement;
    }

    private void createFilterXML(Filter _filter, int _channelId, MethodContext context) throws CMyException {
        String sTemplateContent = "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
        String sFilterName = "";
        if (_filter == null) {
            sTemplateContent = sTemplateContent + "<TRS_FILTER FIELD=\"XML\" DisFile=\"true\"/>";
        } else {
            sFilterName = _filter.getFilterName();
            sTemplateContent = sTemplateContent + "<TRS_FILTER FIELD=\"XML\" name=\"" + sFilterName + "\" DisFile=\"true\"/>";
        }
        String sXMLContent = null;
        PublishTaskContext taskContext = new PublishTaskContext(null, null);
        IPublishElement pagePublishElement = this.makeElement(_channelId);
        PublishPageContext oPageContext = new PublishPageContext(pagePublishElement, taskContext);
        PublishTagContext tagContext = new PublishTagContext(oPageContext);
        PublishPathCompass compass = new PublishPathCompass();
        String sPubUrl = compass.getLocalPath(pagePublishElement, context.getValue("isPreview", true));
        try {
            TagDocument tagDoc = TagDocumentReader.read(sTemplateContent);
            if (tagDoc == null) {
                throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label8", "\u5c06\u6a21\u677f\u5185\u5bb9\u8f6c\u6362\u4e3aTagDocument\u5931\u8d25\uff01"));
            }
            String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
            sXMLContent = results[0];
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label9", "\u89e3\u6790\u7f6e\u6807\u3010TRS_FILTER\u3011\u5931\u8d25\uff01"), e);
        }
        String sFileName = "filter";
        String sPubFilePath = sPubUrl + sFileName + ".xml";
        CMyFile.writeFile(sPubFilePath, sXMLContent, CMyString.GET_ENCODING_DEFAULT);
        tagContext.getFileDistributeShip().distributeFile(sPubFilePath, pagePublishElement, null, false);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void validOption(FilterOption _option, int _nGroupId, User _currUser, int _rightIndex) throws WCMException {
        int nGroupId = _nGroupId;
        FilterOptionGroup group = null;
        if (nGroupId == 0) {
            nGroupId = _option.getGroupId();
        }
        if ((group = FilterOptionGroup.findById(nGroupId)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nGroupId), WCMTypes.getLowerObjName(1310565549)}));
        }
        this.validGroup(group, 0, _currUser, _rightIndex);
    }

    private void validGroup(FilterOptionGroup _group, int _nFilterId, User _currUser, int _rightIndex) throws WCMException {
        int nFilterId = _nFilterId;
        Filter filter = null;
        if (nFilterId == 0) {
            nFilterId = _group.getFilterId();
        }
        if ((filter = Filter.findById(nFilterId)) == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nFilterId), WCMTypes.getLowerObjName(1852535607)}));
        }
        this.validRight(filter, _currUser, _rightIndex);
    }

    private void validRight(Filter _filter, User _currUser, int _rightIndex) throws WCMException {
        int nChannelId = _filter.getChannelId();
        Channel oChannel = Channel.findById(nChannelId);
        if (oChannel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nChannelId), WCMTypes.getLowerObjName(101)}));
        }
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)oChannel, _rightIndex);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + nChannelId + I18NMessage.get(FilterCenterServiceProvider.class, "FilterCenterServiceProvider.label5", "\u3011\u4e0b\u7684\u64cd\u4f5c\u7b5b\u9009\u5668\u4fe1\u606f\uff01 "));
        }
    }

    private void validateRight(Channel _channel, User _currUser, int _rightIndex) throws WCMException {
        boolean bHasRight = AuthServer.hasRight(this.getLoginUser(), (CMSObj)_channel, _rightIndex);
        if (!bHasRight) {
            throw new WCMException(I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u3010id=") + _channel.getId() + I18NMessage.get(AdvisorCenterServiceProvider.class, "AdvisorCenterServiceProvider.label3", "\u3011\u4e0b\u7684\u64cd\u4f5c\u987e\u95ee\u4fe1\u606f\uff01 "));
        }
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }
}

