/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.epress;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.persistent.publisher.FolderPublishConfig;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.epress.EPressConf;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.log.LogServer;
import com.trs.infra.util.CMyString;
import org.apache.log4j.Logger;

public class EPressChannelWrapper {
    private static final String ROLLBACK_PUBCONFS = "DELETE FROM wcmfolderpublishconfig WHERE EXISTS(SELECT channelid FROM wcmchannel WHERE (parentid=? OR channelid=?) AND channelid=folderid and foldertype=101)";
    private static final String ROLLBACK_CHANNELS = "DELETE FROM wcmchannel WHERE parentid=? OR channelid=?";
    private static final String[] ROLLBACK_SQL = new String[]{"DELETE FROM wcmfolderpublishconfig WHERE EXISTS(SELECT channelid FROM wcmchannel WHERE (parentid=? OR channelid=?) AND channelid=folderid and foldertype=101)", "DELETE FROM wcmchannel WHERE parentid=? OR channelid=?"};
    private static Logger s_logger = Logger.getLogger(EPressChannelWrapper.class);
    private Channel m_oCchannel;
    private int m_nPageNums;
    private String m_sUid;
    private String m_sParentName;
    private User m_oUser;
    private int m_nSiteId;
    private String m_sCoverPageName;
    private boolean m_zHasCoverPage;

    public EPressChannelWrapper(int _nPageNums, String _sUid) {
        this.m_nPageNums = _nPageNums;
        this.m_sUid = _sUid;
    }

    public Channel save(User _user, Channel _channel) throws Exception {
        if (_channel == null) {
            throw new WCMException(10, "\u65e0\u6548\u7684\u9891\u9053\u5bf9\u8c61[null]\uff01");
        }
        if (!_channel.isAddMode()) {
            return _channel;
        }
        ContextHelper.initContext(_user);
        this.m_oUser = _user;
        ChannelMgr manager = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
        String sLogDesc = "\u4fdd\u5b58\u7535\u5b50\u62a5\u9891\u9053[" + _channel.getDesc() + "]";
        long lStartTime = LogServer.startRecord(_user.getName(), "CHANNEL_ADD", sLogDesc, _user);
        try {
            _channel.setCanPub(true);
            _channel.setAttribute("EPressUID", this.m_sUid);
            _channel.setAttribute("hascoverpage", String.valueOf(this.m_zHasCoverPage));
            this.m_oCchannel = (Channel)manager.save(_channel);
            this.m_sParentName = this.m_oCchannel.getName();
        }
        catch (Throwable t) {
            LogServer.endRecordFailedOperation(lStartTime, t);
            throw new WCMException(1100, "\u4fdd\u5b58\u7535\u5b50\u62a5\u9891\u9053\u5931\u8d25\uff01", t);
        }
        boolean zRollBack = false;
        try {
            this.m_nSiteId = this.m_oCchannel.getSiteId();
            this.makeChildren();
            EPressConf.instance().add(this.m_sUid, this.m_oCchannel.getId());
        }
        catch (Exception e) {
            zRollBack = true;
            throw e;
        }
        finally {
            if (zRollBack) {
                this.rollback();
            }
        }
        LogServer.endRecordSucceedOperation(lStartTime);
        return this.m_oCchannel;
    }

    private void makeChildren() throws WCMException {
        Channel channel = null;
        String sCoverPageName = this.m_sCoverPageName;
        boolean zHasCoverPage = this.m_zHasCoverPage;
        for (int i = 0; i < this.m_nPageNums; ++i) {
            channel = new Channel();
            int pageNum = zHasCoverPage ? i : i + 1;
            channel.setName(this.makeName(pageNum));
            String desc = pageNum == 0 ? sCoverPageName : this.makeDesc(pageNum);
            channel.setDesc(desc);
            channel.setCanPub(true);
            channel.setParent(this.m_oCchannel);
            channel.setProperty("CHNLORDER", this.m_nPageNums - i);
            channel.setSite(this.m_nSiteId);
            channel.insert(this.m_oUser);
            this.setPublishConf(channel, this.makeDataPath(pageNum));
        }
    }

    private String makeDataPath(int _pageNum) {
        return "page_" + _pageNum;
    }

    private void setPublishConf(Channel _channel, String _dataPath) throws WCMException {
        FolderPublishConfig conf = new FolderPublishConfig();
        conf.setDataPath(_dataPath);
        conf.setFolder(101, _channel.getId());
        conf.insert(this.m_oUser);
    }

    private String makeName(int _pageNum) {
        return this.m_sParentName + "_" + _pageNum;
    }

    private String makeDesc(int _pageNum) {
        return "\u7b2c" + ChineseNumber.format(_pageNum) + "\u7248";
    }

    private void rollback() {
        block2: {
            try {
                int id = this.m_oCchannel.getId();
                DBManager dbmanager = DBManager.getDBManager();
                dbmanager.sqlExecuteUpdate(ROLLBACK_SQL, new int[]{id, id});
            }
            catch (Exception e) {
                if (!s_logger.isDebugEnabled()) break block2;
                s_logger.error((Object)"fail to rollback when create epress failed", (Throwable)e);
            }
        }
    }

    public void setCoverPageName(String _sCoverPageName) {
        this.m_sCoverPageName = _sCoverPageName;
        this.m_zHasCoverPage = !CMyString.isEmpty(this.m_sCoverPageName);
    }

    public static void main(String[] args) {
        EPressChannelWrapper wrapper = new EPressChannelWrapper(10, "trs");
        Channel chnl = new Channel();
        try {
            User user = User.findById(1);
            chnl.setParent(0);
            chnl.setName("trs");
            chnl.setSite(5);
            chnl.setDesc("trs");
            wrapper.save(user, chnl);
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static class ChineseNumber {
        private static final String CN_ZERO = "\u96f6";
        private static final char[] CN_NUMBER = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341'};
        private static final char[] BASE_UNIT = new char[]{'\u96f6', '\u5341', '\u767e', '\u5343'};
        private static final char[] TEN_UNIT = new char[]{'\u4e07', '\u4ebf', '\u4e07', '\u5146'};

        private ChineseNumber() {
        }

        static String format(int src) {
            if (src == 0) {
                return CN_ZERO;
            }
            int[] srcInput = new int[32];
            StringBuffer sbReturn = new StringBuffer(32);
            int iDigitCount = 0;
            while (src > 0) {
                srcInput[iDigitCount++] = src % 10;
                src /= 10;
            }
            boolean zLastIsZero = false;
            boolean zHasNonZero = false;
            while (iDigitCount > 0) {
                int iDigit = srcInput[--iDigitCount];
                int iLevel = iDigitCount;
                boolean zTenkExist = iLevel >= 4;
                boolean zTenkPlace = iLevel % 4 == 0;
                int iBaseLevel = iLevel % 4;
                int iTenkLevel = (iLevel / 4 - 1) % 4;
                if (iDigit == 0) {
                    if (zTenkExist && zTenkPlace && zHasNonZero) {
                        sbReturn.append(TEN_UNIT[iTenkLevel]);
                        continue;
                    }
                    zLastIsZero = true;
                    continue;
                }
                zHasNonZero = true;
                if (zLastIsZero) {
                    zLastIsZero = false;
                    sbReturn.append(CN_NUMBER[0]);
                }
                sbReturn.append(CN_NUMBER[iDigit]);
                if (!zTenkPlace) {
                    sbReturn.append(BASE_UNIT[iBaseLevel]);
                    continue;
                }
                if (!zTenkExist) continue;
                sbReturn.append(TEN_UNIT[iTenkLevel]);
            }
            return sbReturn.toString();
        }
    }
}

