/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.trsserver;

import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.trsserver.ChannelsWithRightMaker;
import com.trs.components.wcm.content.trsserver.TRSSearchUtil;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;
import com.trs.presentation.util.RequestHelper;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TRSSearcher {
    public static final int SEARCHSCOPE_CONTAINSCHILDREN = 1;
    public static final int SEARCHSCOPE_SINGLE = 0;
    private String m_SearchWord = null;
    private RequestHelper m_RequestHelper = null;
    private String m_Option = null;
    private String m_Extension = null;
    private String m_SearchType = null;
    private String m_LastSearch = null;
    private String m_CurrSearch = null;
    private String m_StartTime = null;
    private String m_EndTime = null;
    private int m_PageSize = 10;
    private int m_PageIndex = 1;
    private int m_DetailOpenType = -1;
    private String m_OrderBy = null;
    private String m_Where = null;
    private String m_DateType = null;
    private String m_ChannelIds = null;
    private String m_SiteIds = null;
    private int m_SearchScope = 1;
    private User m_LoginUser = null;

    private TRSSearcher() {
    }

    public static TRSSearcher getTRSSearcher(RequestHelper _currRequestHelper, User _loginUser) {
        TRSSearcher newSearcher = new TRSSearcher();
        newSearcher.m_RequestHelper = _currRequestHelper;
        newSearcher.m_LoginUser = _loginUser;
        return newSearcher;
    }

    public String getSearchWord() {
        return this.m_SearchWord;
    }

    public String getOption() {
        return this.m_Option;
    }

    public String getExtension() {
        return this.m_Extension;
    }

    public String getSearchType() {
        return this.m_SearchType;
    }

    public String getLastSearch() {
        return this.m_LastSearch;
    }

    public String getStartTime() {
        return this.m_StartTime;
    }

    public String getEndTime() {
        return this.m_EndTime;
    }

    public int getPageSize() {
        return this.m_PageSize;
    }

    public int getPageIndex() {
        return this.m_PageIndex;
    }

    public int getDetailOpenType() {
        return this.m_DetailOpenType;
    }

    public String getOrderBy() {
        return this.m_OrderBy;
    }

    public String getWhere() {
        return this.m_Where;
    }

    public String getDateType() {
        return this.m_DateType;
    }

    public String getChannelIds() {
        return this.m_ChannelIds;
    }

    public String getCurrSearch() {
        return this.m_CurrSearch;
    }

    public void buildSearcher() throws WCMException {
        HashMap favoriteInfo;
        try {
            favoriteInfo = TRSSearchUtil.getFavorite(this.m_RequestHelper.getRequest());
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label1", "\u83b7\u53d6\u7528\u6237\u7684\u5b58\u50a8\u504f\u597d\u65f6\u53d1\u751f\u9519\u8bef\u3002"), e);
        }
        if (this.m_RequestHelper == null) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label2", "\u4f20\u5165\u7684requestHelper\u65e0\u6548"));
        }
        this.m_Option = this.m_RequestHelper.getString("Option");
        this.m_Extension = this.m_RequestHelper.getString("Extension");
        this.m_DateType = CMyString.showNull(this.m_RequestHelper.getString("DateType"), "");
        this.m_StartTime = CMyString.showNull(this.m_RequestHelper.getString("StartTime"), "");
        this.m_EndTime = CMyString.showNull(this.m_RequestHelper.getString("EndTime"), "");
        String sSearchType = this.m_RequestHelper.getString("SearchType");
        if (sSearchType == null) {
            sSearchType = (String)favoriteInfo.get("SearchType");
        }
        if (sSearchType == null) {
            sSearchType = "";
        }
        this.m_SearchType = sSearchType;
        String sSearchScope = this.m_RequestHelper.getString("SearchScope");
        int nSearchScope = 1;
        try {
            nSearchScope = Integer.parseInt(sSearchScope);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_SearchScope = nSearchScope;
        int nPageSize = this.m_RequestHelper.getInt("PageSize", -1);
        if (nPageSize < 0) {
            try {
                nPageSize = Integer.parseInt((String)favoriteInfo.get("PageSize"));
            }
            catch (Exception ex) {
                nPageSize = 20;
            }
        }
        this.m_PageSize = nPageSize;
        this.m_PageIndex = this.m_RequestHelper.getInt("PageIndex", 1);
        int nDetailOpenType = this.m_RequestHelper.getInt("DetailOpenType", -1);
        if (nDetailOpenType < 0) {
            try {
                nDetailOpenType = Integer.parseInt((String)favoriteInfo.get("DetailOpenType"));
            }
            catch (Exception ex) {
                nDetailOpenType = 1;
            }
        }
        this.m_DetailOpenType = nDetailOpenType;
        String sOrderBy = this.m_RequestHelper.getString("OrderBy");
        if (sOrderBy == null) {
            sOrderBy = "RELEVANCE";
        }
        this.m_OrderBy = sOrderBy;
        String sWhere = "";
        this.m_SearchWord = CMyString.showNull(this.m_RequestHelper.getString("SearchWord"), "").trim();
        this.m_LastSearch = CMyString.showNull(this.m_RequestHelper.getString("LastSearch"), "").trim();
        if (this.m_LastSearch != null && this.m_LastSearch.length() > 0) {
            sWhere = this.m_LastSearch;
        }
        if (this.m_SearchWord != null && this.m_SearchWord.trim().length() > 0) {
            sWhere = sWhere.length() > 0 ? "(" + sWhere + ") and (" + this.dowithBlank(this.m_SearchWord) + ")" : this.dowithBlank(this.m_SearchWord);
        }
        this.m_CurrSearch = sWhere;
        if (this.m_CurrSearch.trim().length() <= 0) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label3", "\u6ca1\u6709\u4f20\u5165\u6709\u6548\u7684\u68c0\u7d22\u6761\u4ef6"));
        }
        String sChannelIds = this.m_RequestHelper.getString("ChannelId");
        if (sChannelIds == null || sChannelIds.trim().equals("")) {
            sChannelIds = (String)favoriteInfo.get("ChannelId");
        }
        if (sChannelIds == null || sChannelIds.trim().equals("0")) {
            sChannelIds = "";
        }
        this.m_ChannelIds = sChannelIds;
        String sSiteIds = this.m_RequestHelper.getString("SiteId");
        if (sSiteIds == null || sSiteIds.trim().equals("0")) {
            sSiteIds = "";
        }
        this.m_SiteIds = sSiteIds;
        ChannelsWithRightMaker oChannelsWithRightMaker = new ChannelsWithRightMaker(this.m_LoginUser, 30);
        if (sChannelIds == null || sChannelIds.trim().equals("")) {
            if (sSiteIds == null || sSiteIds.trim().equals("")) {
                sChannelIds = oChannelsWithRightMaker.getChannelIdsWithRight();
            }
        } else if (nSearchScope == 1) {
            sChannelIds = oChannelsWithRightMaker.getChannelIdsWithRight(sChannelIds);
        }
        if (sChannelIds == null) {
            throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u68c0\u7d22\uff01"));
        }
        if (sChannelIds != null && !sChannelIds.trim().equals("") && sChannelIds.length() < 500) {
            sWhere = "(" + sWhere + ") and docchannel=" + sChannelIds;
        }
        if (sSiteIds != null && !sSiteIds.trim().equals("")) {
            sWhere = "(" + sWhere + ") and siteid=" + sSiteIds;
        }
        if (!this.m_DateType.equals("")) {
            String sSearchDate = "";
            try {
                String sTempStartTime;
                if (this.m_DateType.equals("lastweek")) {
                    sTempStartTime = CMyDateTime.now().dateAdd(12, -1).toString("yyyy-MM-dd HH:mm");
                    sSearchDate = sSearchDate + "crtime>='" + sTempStartTime + "'";
                }
                if (this.m_DateType.equals("lastmonth")) {
                    sTempStartTime = CMyDateTime.now().dateAdd(2, -1).toString("yyyy-MM-dd HH:mm");
                    sSearchDate = sSearchDate + "crtime>='" + sTempStartTime + "'";
                }
                if (this.m_DateType.equals("lastyear")) {
                    sTempStartTime = CMyDateTime.now().dateAdd(1, -1).toString("yyyy-MM-dd HH:mm");
                    sSearchDate = sSearchDate + "crtime>='" + sTempStartTime + "'";
                }
            }
            catch (CMyException ex) {
                throw new WCMException(I18NMessage.get(TRSSearcher.class, "TRSSearcher.label5", "\u6784\u9020\u65e5\u671f\u68c0\u7d22\u6761\u4ef6\u65f6\u53d1\u751f\u9519\u8bef"), ex);
            }
            if (this.m_DateType.equals("special")) {
                if (this.m_StartTime != null && !this.m_StartTime.trim().equals("")) {
                    sSearchDate = sSearchDate + "crtime>='" + this.m_StartTime + "'";
                }
                if (this.m_EndTime != null && !this.m_EndTime.trim().equals("")) {
                    sSearchDate = sSearchDate.trim().equals("") ? sSearchDate + "crtime<='" + this.m_EndTime + "'" : sSearchDate + "and crtime<='" + this.m_EndTime + "'";
                }
            }
            sWhere = sWhere.equals("") ? sSearchDate : "(" + sWhere + ") and (" + sSearchDate + ")";
        }
        if (this.m_SearchType.equalsIgnoreCase("docparent")) {
            sWhere = sWhere.trim().equals("") ? "(docparentid=0 or docparentid =DATA())" : "(" + sWhere + ") and (docparentid=0 or docparentid =DATA())";
        }
        this.m_Where = sWhere;
    }

    private String dowithBlank(String searchWord) {
        String sResult = searchWord;
        if (sResult == null || searchWord.length() == 0) {
            return sResult;
        }
        String sPattern = "([()\\[\\],/@=><!&\\*\\^\\-\\+]+)";
        Pattern currPattern = Pattern.compile(sPattern);
        Matcher currMatch = currPattern.matcher(sResult);
        if (currMatch.find()) {
            return sResult;
        }
        sResult = sResult.replaceAll("(\\s+)", "\\*");
        return sResult;
    }

    public String getDefaultCols() {
        String strDefautCols = "doctitle;doccontent;cruser;doctags";
        String sSearchType = this.m_SearchType;
        if (sSearchType.trim().equalsIgnoreCase("TITLE")) {
            strDefautCols = "doctitle";
        } else if (sSearchType.trim().equalsIgnoreCase("content")) {
            strDefautCols = "doccontent";
        } else if (sSearchType.trim().equalsIgnoreCase("author")) {
            strDefautCols = "cruser";
        }
        return strDefautCols;
    }

    public int getSearchScope() {
        return this.m_SearchScope;
    }

    public String getSiteIds() {
        return this.m_SiteIds;
    }
}

