/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;

public class Channels
extends CMSBaseObjs {
    public Channels(User _currUser) {
        super(_currUser);
    }

    public Channels(User _currUser, int initialCapacity, int capacityIncrement) {
        super(_currUser, initialCapacity, capacityIncrement);
    }

    @Override
    protected String getDbTableName() {
        return "WCMCHANNEL";
    }

    @Override
    public String getIdFieldName() {
        return "CHANNELID";
    }

    @Override
    public Class getElementClass() {
        return Channel.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new Channels(this.currUser);
    }

    public synchronized Channels getChildrenOf(int _parentId) throws WCMException {
        return this.getSubChannelsByParentId(_parentId);
    }

    public synchronized Channels getSubChannelsByParentId(int _parentId) throws WCMException {
        Channels subChannels = null;
        Channel channel = null;
        int nOldPos = this.currIndex;
        try {
            subChannels = new Channels(this.currUser);
            for (int i = 0; i < this.size(); ++i) {
                channel = (Channel)this.getAt(i);
                if (channel == null || channel.getParentId() != _parentId) continue;
                subChannels.addElement(channel);
            }
            this.currIndex = nOldPos;
            return subChannels;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(Channels.class, "Channels.label1", "\u83b7\u53d6\u9891\u9053\u5b50\u96c6\u65f6\u5931\u8d25(Channels.getSubChannelsByParentId)"), ex);
        }
    }

    public static final Channels findByIds(User _currUser, String _sIds) throws WCMException {
        if (_sIds == null || _sIds.length() <= 0) {
            return Channels.createNewInstance(_currUser);
        }
        return (Channels)CMSBaseObjs.findWCMObjsByIds(_currUser, Channels.class, _sIds);
    }

    public static final Channels openWCMObjs(User _currUser, WCMFilter _filter) throws WCMException {
        return (Channels)CMSBaseObjs.openWCMObjs(_currUser, Channels.class, _filter);
    }

    public static Channels createNewInstance(User _currUser) throws WCMException {
        return (Channels)CMSBaseObjs.createInstance(_currUser, Channels.class);
    }
}

