/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ChannelContentLink
extends CMSObj {
    public static final int OBJ_TYPE = 1952046669;
    public static final String DB_TABLE_NAME = "WCMCHANNELCONTENTLINK";
    public static final String DB_ID_NAME = "LINKID";
    private static final int DIRECTION_MOVE_FORWARD = 1;
    private static final int DIRECTION_MOVE_BACK = -1;
    private static final int DIRECTION_MOVE_NO = 0;

    @Override
    public int getWCMType() {
        return 1952046669;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public boolean isValid() throws WCMException {
        String sLinkName = null;
        if (this.isAddMode()) {
            if (this.getProperty("LINKNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label1", "\u5c5e\u6027LINKNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("CHANNELID") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label2", "\u5c5e\u6027CHANNELID\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("LINKURL") == null) {
                throw new WCMException(1106, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label3", "\u5c5e\u6027LINKURL\u6ca1\u6709\u8bbe\u7f6e"));
            }
            sLinkName = this.getPropertyAsString("LINKNAME");
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ContentLink.isValid)"));
            }
            if (this.isChangeProperty("LINKNAME")) {
                sLinkName = this.getNewPropertyAsString("LINKNAME");
            }
        }
        if (!CMyString.isEmpty(sLinkName)) {
            sLinkName = sLinkName.toUpperCase();
            this.setProperty("LINKNAME", sLinkName);
            StringBuffer buff = new StringBuffer(64);
            buff.append("LinkName='").append(sLinkName).append("'");
            if (this.getSiteId() == 0) {
                buff.append(" AND ChannelId=").append(this.getChnlId());
            } else {
                buff.append(" AND SiteId=").append(this.getSiteId());
            }
            buff.append(" AND NOT LinkId=").append(this.id);
            if (this.checkExists(buff.toString())) {
                throw new WCMException(1108, I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label5", "\u5df2\u5b58\u5728\u540d\u79f0\u4e3a[") + sLinkName + I18NMessage.get(ChannelContentLink.class, "ChannelContentLink.label6", "]\u7684\u70ed\u8bcd!"));
            }
        }
        this.changeOrder();
        return true;
    }

    private void changeOrder() throws WCMException {
        int nMaxOrder;
        int nNewOrder;
        int nStartPoint = 0;
        int nEndPoint = 0;
        int nDirection = 0;
        int nOrder = this.getOrder();
        if (this.isAddMode()) {
            nNewOrder = nOrder;
            nMaxOrder = this.getMaxOrder();
            if (nNewOrder == -1) {
                nNewOrder = nMaxOrder + 1;
            } else {
                nDirection = 1;
                nEndPoint = nMaxOrder;
                nStartPoint = nNewOrder;
            }
        } else {
            if (!this.isChangeProperty("LinkOrder")) {
                return;
            }
            nNewOrder = this.getNewPropertyAsInt("LinkOrder", -1);
            if (nNewOrder == -1) {
                nMaxOrder = this.getMaxOrder();
                if (nMaxOrder == nOrder) {
                    nNewOrder = nOrder;
                } else {
                    nDirection = -1;
                    nEndPoint = nMaxOrder;
                    nStartPoint = nOrder + 1;
                    nNewOrder = nMaxOrder;
                }
            } else if (nNewOrder > nOrder) {
                nDirection = -1;
                nEndPoint = --nNewOrder;
                nStartPoint = nOrder + 1;
            } else {
                nDirection = 1;
                nEndPoint = nOrder - 1;
                nStartPoint = nNewOrder;
            }
        }
        StringBuffer buff = new StringBuffer(128);
        buff.append("UPDATE ").append(DB_TABLE_NAME);
        buff.append(" SET LinkOrder=LinkOrder+(");
        buff.append(nDirection);
        buff.append(")");
        buff.append(" WHERE ");
        buff.append("LinkOrder>=").append(nStartPoint);
        buff.append(" AND LinkOrder<=").append(nEndPoint);
        buff.append(" AND ChannelId=").append(this.getChnlId());
        DBManager.getDBManager().sqlExecuteUpdate(buff.toString());
        this.setOrder(nNewOrder);
    }

    private synchronized int getMaxOrder() throws WCMException {
        int nChnlId = this.getChnlId();
        StringBuffer buff = new StringBuffer("SELECT MAX(LinkOrder) FROM ");
        buff.append(DB_TABLE_NAME);
        buff.append(" WHERE ChannelId=");
        buff.append(nChnlId);
        return DBManager.getDBManager().sqlExecuteIntQuery(buff.toString());
    }

    public boolean setName(String _name) throws WCMException {
        return this.setPropertyWithString("LINKNAME", _name);
    }

    public String getName() {
        return this.getPropertyAsString("LINKNAME");
    }

    public boolean setLinkUrl(String _linkUrl) throws WCMException {
        return this.setPropertyWithString("LINKURL", _linkUrl);
    }

    public String getLinkUrl() {
        return this.getPropertyAsString("LINKURL");
    }

    public boolean setLinkTitle(String _linkTitle) throws WCMException {
        return this.setPropertyWithString("LINKTITLE", _linkTitle);
    }

    public String getLinkTitle() {
        return this.getPropertyAsString("LINKTITLE");
    }

    public int getOrder() {
        return this.getPropertyAsInt("LINKORDER", 0);
    }

    public boolean setOrder(int _order) throws WCMException {
        return this.setProperty("LINKORDER", _order);
    }

    public boolean setChnlId(int _nChannelid) throws WCMException {
        return this.setProperty("CHANNELID", _nChannelid);
    }

    public int getChnlId() {
        return this.getPropertyAsInt("CHANNELID", 0);
    }

    public boolean setSiteId(int _nSiteid) throws WCMException {
        return this.setProperty("SITEID", _nSiteid);
    }

    public int getSiteId() {
        return this.getPropertyAsInt("SITEID", 0);
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChnlId());
    }

    public int getSysContentLinkId() {
        return this.getPropertyAsInt("SYSCONTENTLINKID", 0);
    }

    public boolean setSysContentLinkId(int _nSysId) throws WCMException {
        return this.setProperty("SYSCONTENTLINKID", _nSysId);
    }

    public boolean isUsedInChildren() {
        return this.getPropertyAsBoolean("IsUsedInChildren", false);
    }

    public boolean setUsedInChildren(boolean _bUsedInChildren) throws WCMException {
        return this.setProperty("IsUsedInChildren", _bUsedInChildren);
    }

    public static final ChannelContentLink findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (ChannelContentLink)BaseObj.findById(ChannelContentLink.class, _nId);
    }

    public static final ChannelContentLink createNewInstance() throws WCMException {
        return (ChannelContentLink)BaseObj.createNewInstance(ChannelContentLink.class);
    }

    public static final ChannelContentLink findByKey(Object _oKey) throws WCMException {
        return (ChannelContentLink)BaseObj.findByKey(ChannelContentLink.class, _oKey);
    }

    public static void main(String[] args) {
        System.out.println(ChannelContentLink.class.getName().hashCode());
    }
}

