/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.RightConfigServer;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowServer;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class DocumentAuthServer {
    private static Logger logger = Logger.getLogger(DocumentAuthServer.class);
    public static int[] INDEXES_OWNER_HAS = new int[]{32, 34, 33, 34, 34, 34, WCMRightTypes.DOC_MOVE, 33, 30};
    private static int[] ENTITY_RIGHT_INDEX;
    private static int[] INDEXES_DEFINE_ON_FLOW;

    public static boolean hasRight(User _loginUser, ChnlDoc _chnlDoc, int _nRightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, (BaseChannel)_chnlDoc.getChannel(), _chnlDoc.getDocument(), _nRightIndex);
    }

    public static boolean hasRight(User _loginUser, BaseChannel _oSiteOrChannel, Document _document, int _nRightIndex) throws WCMException {
        boolean bIndexOwnerHas;
        boolean bEditDocumentUseStatusIndex;
        if (_loginUser == null) {
            return false;
        }
        int nRightIndex = _nRightIndex;
        if (_document == null || _document.isAddMode()) {
            if (nRightIndex == 80) {
                nRightIndex = 31;
            }
            if (_loginUser.isAdministrator()) {
                return true;
            }
            Channel currChannel = DocumentAuthServer.findCurrentChannel(_oSiteOrChannel, _document);
            if (_loginUser.getName().equalsIgnoreCase(currChannel.getCrUserName())) {
                return true;
            }
            return AuthServer.hasRight(_loginUser, (CMSObj)currChannel, nRightIndex);
        }
        if (nRightIndex == 80) {
            nRightIndex = 32;
        }
        if (nRightIndex == 32 && (bEditDocumentUseStatusIndex = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("EDIT_DOCUMENT_USE_ST_INDEX", "false")))) {
            switch (_document.getStatusId()) {
                case 10: 
                case 16: 
                case 18: {
                    Status status = Status.findById(16);
                    nRightIndex = status.getRightIndex();
                    break;
                }
            }
        }
        if ((bIndexOwnerHas = DocumentAuthServer.isRightIndexOwnerHas(nRightIndex)) && _loginUser.equals(_document.getCrUser())) {
            return true;
        }
        if (DocumentAuthServer.isDefineRightOnDocument(_document)) {
            RightValue rightValue = new RightValue();
            rightValue.load(_loginUser, 605, _document.getId(), true);
            return rightValue.isHasRight(nRightIndex);
        }
        if (_loginUser.isAdministrator()) {
            return true;
        }
        Channel currChannel = DocumentAuthServer.findCurrentChannel(_oSiteOrChannel, _document);
        if (currChannel.getId() != _document.getChannelId() && !DocumentAuthServer.isRightIndexDefineOnChannel(nRightIndex, currChannel)) {
            currChannel = _document.getChannel();
        }
        if (!AuthServer.hasRight(_loginUser, (CMSObj)currChannel, nRightIndex)) {
            return false;
        }
        return DocumentAuthServer.hasRightByDocLevel(_loginUser, currChannel, _document);
    }

    private static Channel findCurrentChannel(BaseChannel _oSiteOrChannel, Document _document) throws WCMException {
        Channel currChannel = null;
        if (_oSiteOrChannel != null && !_oSiteOrChannel.isSite()) {
            currChannel = (Channel)_oSiteOrChannel;
        } else {
            if (_document == null) {
                throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label1", "hasRight\u65b9\u6cd5\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9,\u5373\u6ca1\u6709\u6587\u6863\u4e5f\u6ca1\u6709\u76f8\u5173\u680f\u76ee![BaseChannel:") + _oSiteOrChannel + "]");
            }
            currChannel = _document.getChannel();
        }
        if (currChannel == null) {
            throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label2", "\u6587\u6863\u76f8\u5173\u680f\u76ee\u4e0d\u5b58\u5728![DocId:") + _document.getId() + ",Title:" + _document.getTitle() + "]");
        }
        return currChannel;
    }

    public static boolean hasRight(User _loginUser, BaseChannel _oSiteOrChannel, Documents _documents, int _nRightIndex) throws WCMException {
        if (_loginUser == null) {
            return false;
        }
        Channel currChannel = null;
        if (_oSiteOrChannel != null && !_oSiteOrChannel.isSite()) {
            currChannel = (Channel)_oSiteOrChannel;
        } else if (_documents == null) {
            throw new WCMException(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label1", "hasRight\u65b9\u6cd5\u4f7f\u7528\u573a\u666f\u4e0d\u5bf9,\u5373\u6ca1\u6709\u6587\u6863\u4e5f\u6ca1\u6709\u76f8\u5173\u680f\u76ee![BaseChannel:") + _oSiteOrChannel + "]");
        }
        if (_documents == null) {
            return AuthServer.hasRight(_loginUser, (CMSObj)currChannel, _nRightIndex);
        }
        int nDocumentsCount = _documents.size();
        ArrayList<Integer> arHasRightChannelIds = new ArrayList<Integer>(nDocumentsCount / 2);
        for (int i = 0; i < nDocumentsCount; ++i) {
            Document _document = (Document)_documents.getAt(i);
            if (_document == null) continue;
            int nCurrChannelId = -1;
            nCurrChannelId = currChannel == null || currChannel.isOnlySearch() ? _document.getChannelId() : (DocumentAuthServer.isRightIndexDefineOnChannel(_nRightIndex, currChannel) ? currChannel.getId() : _document.getChannelId());
            Integer iKey = new Integer(nCurrChannelId);
            if (arHasRightChannelIds.contains(iKey)) continue;
            if (!DocumentAuthServer.hasRight(_loginUser, (BaseChannel)currChannel, _document, _nRightIndex)) {
                return false;
            }
            arHasRightChannelIds.add(iKey);
        }
        return true;
    }

    public static String makeLogicRightValue(User _loginUser, Channel _currChannel, Document _currDocument) throws WCMException {
        if (_loginUser == null) {
            throw new WCMException("The Current User is null!");
        }
        if (_currDocument == null) {
            throw new WCMException("The Current Document is null!");
        }
        if (DocumentAuthServer.isDefineRightOnDocument(_currDocument)) {
            return AuthServer.getRightValue((CMSObj)_currDocument, _loginUser).toString();
        }
        if (_loginUser.isAdministrator()) {
            return RightValue.getAdministratorValues();
        }
        boolean bIsEntityModal = true;
        Channel currChannel = _currChannel;
        Channel docChannel = null;
        if (_currChannel == null || _currChannel.isOnlySearch()) {
            docChannel = currChannel = _currDocument.getChannel();
        } else if (_currChannel.getId() == _currDocument.getId()) {
            docChannel = currChannel;
        } else {
            docChannel = _currDocument.getChannel();
            bIsEntityModal = false;
        }
        if (docChannel == null) {
            logger.warn((Object)(I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label3", "\u6587\u6863[") + _currDocument + I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label4", "]\u6240\u5c5e\u680f\u76ee[Id=") + _currDocument.getChannelId() + I18NMessage.get(DocumentAuthServer.class, "DocumentAuthServer.label5", "]\u4e0d\u5b58\u5728\uff01")));
            return "0";
        }
        RightValue rightValue = AuthServer.getRightValue((CMSObj)docChannel, _loginUser);
        if (bIsEntityModal) {
            return rightValue.toString();
        }
        int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(_currChannel.getSiteId());
        int nRightCount = pRightIndexesOnChannel.length;
        if (nRightCount == 0) {
            return rightValue.toString();
        }
        RightValue currChannelRightValue = AuthServer.getRightValue((CMSObj)currChannel, _loginUser);
        for (int i = 0; i < nRightCount; ++i) {
            int nRightIndexTemp = pRightIndexesOnChannel[i];
            rightValue.setBit(nRightIndexTemp, currChannelRightValue.getBit(nRightIndexTemp));
        }
        return rightValue.toString();
    }

    public static String formatLogicRightValue(User _loginUser, Document _currDocument, String _sLogicValue) {
        if (!_loginUser.equals(_currDocument.getCrUser())) {
            return _sLogicValue;
        }
        StringBuffer sbBuffer = null;
        for (int i = 0; i < ENTITY_RIGHT_INDEX.length; ++i) {
            int nIndex;
            if (ENTITY_RIGHT_INDEX[i] >= _sLogicValue.length() || _sLogicValue.charAt(nIndex = _sLogicValue.length() - ENTITY_RIGHT_INDEX[i] - 1) != '0') continue;
            if (sbBuffer == null) {
                sbBuffer = new StringBuffer(_sLogicValue);
            }
            sbBuffer.setCharAt(nIndex, '1');
        }
        if (sbBuffer != null) {
            return sbBuffer.toString();
        }
        return _sLogicValue;
    }

    public static boolean hasFlowDocRight(User _currUser, Document _document, int _nRightIndex) throws WCMException {
        if (_document.isAddMode()) {
            return false;
        }
        if (!DocumentAuthServer.isRightIndexDefineOnFlow(_nRightIndex)) {
            return false;
        }
        FlowServer sFlowServer = FlowServer.getFlowServer();
        FlowDoc flowdoc = sFlowServer.getFlowDoc(605, _document.getId());
        if (flowdoc == null) {
            return false;
        }
        FlowNode aFlowNode = flowdoc.getNode();
        if (aFlowNode == null) {
            return false;
        }
        Users flowDocUsers = aFlowNode.getOperUsers(_currUser, true);
        boolean bIsDocUser = false;
        for (int i = 0; i < flowDocUsers.size(); ++i) {
            User currUser = (User)flowDocUsers.getAt(i);
            if (currUser == null || _currUser.getId() != currUser.getId()) continue;
            bIsDocUser = true;
            break;
        }
        if (!bIsDocUser) {
            return false;
        }
        if (_nRightIndex == 34) {
            return true;
        }
        if (_nRightIndex == 32 && aFlowNode.canEditDoc()) {
            return true;
        }
        if (_nRightIndex == 33 && aFlowNode.canDelDoc()) {
            return true;
        }
        return _nRightIndex == 39 && aFlowNode.canPubDoc();
    }

    public static boolean isRightIndexOwnerHas(int _nRightIndex) {
        for (int j = 0; j < INDEXES_OWNER_HAS.length; ++j) {
            if (_nRightIndex != INDEXES_OWNER_HAS[j]) continue;
            return true;
        }
        return false;
    }

    public static boolean isRightIndexDefineOnChannel(int _nRightIndex, Channel _currChannel) {
        int[] pRightIndexesOnChannel = RightConfigServer.getInstance().getRightIndexDefineOnCurrChannel(_currChannel.getSiteId());
        for (int j = 0; j < pRightIndexesOnChannel.length; ++j) {
            if (_nRightIndex != pRightIndexesOnChannel[j]) continue;
            return true;
        }
        return false;
    }

    private static boolean isRightIndexDefineOnFlow(int _nRightIndex) {
        for (int j = 0; j < INDEXES_DEFINE_ON_FLOW.length; ++j) {
            if (_nRightIndex != INDEXES_DEFINE_ON_FLOW[j]) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefineRightOnDocument(Document _document) throws WCMException {
        return DocumentAuthServer.isDefineRightOnDocument(_document.getId());
    }

    public static boolean isDefineRightOnDocument(int _nDocId) throws WCMException {
        RightCacheMgr oRightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        return oRightCacheMgr.isExistsRight(605, _nDocId);
    }

    public static boolean hasRightByDocLevel(User _loginUser, Channel _currChannel, Document _currDocument) throws WCMException {
        if (_loginUser == null || _currChannel == null) {
            return false;
        }
        if (_loginUser.isAdministrator() || _loginUser.getName().equalsIgnoreCase(_currChannel.getCrUserName())) {
            return true;
        }
        boolean bUseDocLevel = _currChannel.isUseDocLevel();
        if (!bUseDocLevel) {
            return true;
        }
        DocLevel docLevelOfDocument = _currDocument.getDocLevel();
        int nLValue = docLevelOfDocument.getLValue();
        if (nLValue == 0) {
            return true;
        }
        DocLevel viewDocLevel = _loginUser.getDocLevel();
        int nViewValue = viewDocLevel.getLValue();
        if (nViewValue == 0) {
            return false;
        }
        return nViewValue - nLValue <= 0;
    }

    static {
        try {
            String sRightIndex = ConfigServer.getServer().getSysConfigValue("DOC_CRUSER_HAS_RIGHT_INDEXES", "");
            if (!CMyString.isEmpty(sRightIndex)) {
                INDEXES_OWNER_HAS = CMyString.splitToInt(sRightIndex, ",");
            }
        }
        catch (WCMException exception) {
            logger.error((Object)"exception occurs when initialing the right indexes for document creator from system config.", (Throwable)exception);
        }
        ENTITY_RIGHT_INDEX = new int[]{80, 31, 32, 34};
        INDEXES_DEFINE_ON_FLOW = new int[]{34, 33, 39, 32};
    }
}

