/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.infra.util.CMyString;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WCMDocAppendixesParserForImporter {
    private static final String ELEATTR_NAME = "val";
    private static final String TAG_APPENDIX = "WCMAPPENDIX";
    private static final char CHAR_S = 'S';
    private static final List IMAGE_TYPES = Arrays.asList("JPEG", "GIF", "JPG", "PNG", "BMP", "TIF", "TIFF", "IFF", "PSD", "SGI", "PCX", "TGA", "RAS", "RSB");

    public static Document getAppendixDoc(String _sVal) throws ParserConfigurationException, FactoryConfigurationError {
        Document xmlDoc = CMyJAXPXMLParser.newDocumentBuilderFactory().newDocumentBuilder().newDocument();
        xmlDoc.appendChild(xmlDoc.createElement("WCMAPPENDIXS"));
        String[] arrSins = CMyString.split(_sVal, ";");
        for (int i = 0; i < arrSins.length; ++i) {
            Element appendix = xmlDoc.createElement(TAG_APPENDIX);
            String sSin = arrSins[i].trim();
            String sFileName = sSin.substring(sSin.indexOf("@") + 1, sSin.indexOf("^"));
            String sFileExt = CMyFile.extractFileExt(sFileName);
            String sFileType = sSin.substring(sSin.indexOf("^") + 1, sSin.length());
            Element oFileName = xmlDoc.createElement("APPFILE");
            oFileName.setAttribute(ELEATTR_NAME, sFileName);
            appendix.appendChild(oFileName);
            Element oFileExt = xmlDoc.createElement("FILEEXT");
            oFileExt.setAttribute(ELEATTR_NAME, sFileExt);
            appendix.appendChild(oFileExt);
            Element flag = xmlDoc.createElement("APPFLAG");
            flag.setAttribute(ELEATTR_NAME, WCMDocAppendixesParserForImporter.getFlag(sFileType));
            appendix.appendChild(flag);
            Element version = xmlDoc.createElement("USEDVERSIONS");
            version.setAttribute(ELEATTR_NAME, "1");
            appendix.appendChild(version);
            Element appsern = xmlDoc.createElement("APPSERN");
            appsern.setAttribute(ELEATTR_NAME, "1");
            appendix.appendChild(appsern);
            xmlDoc.getFirstChild().appendChild(appendix);
        }
        return xmlDoc;
    }

    public static NodeList getNodeList(String _sVal) throws Exception {
        return WCMDocAppendixesParserForImporter.getAppendixDoc(_sVal).getChildNodes();
    }

    public static String getDocContentString() throws ParserConfigurationException, FactoryConfigurationError {
        Document doc = WCMDocAppendixesParserForImporter.getAppendixDoc("");
        return doc.toString();
    }

    private static String getFlag(String _sFileType) {
        return IMAGE_TYPES.contains(_sFileType.toUpperCase()) ? "20" : "10";
    }
}

