/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;

public class DocumentMoveListenerForDocSiteRecode
implements IServiceListener {
    private DocumentMgr m_oDocumentMgr;

    @Override
    public void afterServiceExecuted(ServiceListenerConfig _oListenerConfig, MethodContext _oMethodContext, Object _oServiceResult) {
        User loginUser = ContextHelper.getLoginUser();
        this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        try {
            Channel toChannel = Channel.findById(_oMethodContext.getValue("ToChannelId", 0));
            if (toChannel == null) {
                return;
            }
            ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _oMethodContext.getObjectIds());
            for (int i = chnlDocs.size() - 1; i >= 0; --i) {
                int nToSiteId;
                int nCurrSiteId;
                boolean bHasRightValue;
                Document fromDocument;
                Channel fromChannel;
                ChnlDoc chnldoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnldoc == null || (fromChannel = chnldoc.getChannel()) == null || (fromDocument = chnldoc.getDocument()) == null || !(bHasRightValue = DocumentAuthServer.hasRight(loginUser, (BaseChannel)fromChannel, fromDocument, 33)) || (nCurrSiteId = fromDocument.getPropertyAsInt("SiteId", 0)) == (nToSiteId = toChannel.getSiteId())) continue;
                boolean bKeepPublishedStatus = true;
                try {
                    bKeepPublishedStatus = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("KEEP_PUBLISH_STATUS_MOVE", "true").trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int beforeSaveDocumentSiatusId = fromDocument.getStatusId();
                if (beforeSaveDocumentSiatusId == 10 && bKeepPublishedStatus) {
                    DBManager manager = this.getDBManager();
                    String sUpdateDocumentPubTimeSql = "update WCMDocument set SITEID=" + nToSiteId + " where DocId=" + chnldoc.getDocId();
                    manager.sqlExecuteUpdate(sUpdateDocumentPubTimeSql);
                    continue;
                }
                fromDocument.setProperty("SiteId", nToSiteId);
                fromDocument.save();
            }
        }
        catch (WCMException ex) {
            ex.printStackTrace();
        }
    }

    private DBManager getDBManager() throws WCMException {
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null || !currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label76", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(DocumentMgr.class, "DocumentMgr.label77", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        return currDBManager;
    }
}

