/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.ChannelXmlConverter;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyZip;
import org.apache.log4j.Logger;

public class ChannelExporter {
    private static Logger s_logger = Logger.getLogger(ChannelExporter.class);
    private String m_sXMLEncoding = "utf-8";
    private String m_sChannelFieldList = null;
    private String m_sSiteFieldList = null;

    public ChannelExporter() {
    }

    public ChannelExporter(String _sSiteFieldList, String _sChannelFieldList) {
        this.m_sChannelFieldList = _sChannelFieldList;
        this.m_sSiteFieldList = _sSiteFieldList;
    }

    public void setXMLEncoding(String _sXMLEncoding) {
        this.m_sXMLEncoding = _sXMLEncoding;
    }

    public String export(Channels _channels, boolean _bWithChildren, boolean _bWithRelate) throws WCMException {
        return this.export((Object)_channels, _bWithChildren, _bWithRelate);
    }

    public String export(WebSites _sites, boolean _bWithChildren, boolean _bWithRelate) throws WCMException {
        return this.export((Object)_sites, _bWithChildren, _bWithRelate);
    }

    public String export(BaseChannel _siteOrChnl, boolean _bWithChildren, boolean _bWithRelate) throws WCMException {
        return this.export((Object)_siteOrChnl, _bWithChildren, _bWithRelate);
    }

    public String export(Object _object, boolean _bWithChildren, boolean _bWithRelate) throws WCMException {
        return this.export(_object, _bWithChildren, _bWithRelate, false);
    }

    public String exportToXMLContent(Object _object, boolean _bWithChildren, boolean _bWithRelate) throws WCMException {
        return this.export(_object, _bWithChildren, _bWithRelate, true);
    }

    public String export(Object _object, boolean _bWithChildren, boolean _bWithRelate, boolean _bReturnXMLContent) throws WCMException {
        return this.export(_object, _bWithChildren, _bWithRelate, _bReturnXMLContent, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String export(Object _object, boolean _bWithChildren, boolean _bWithRelate, boolean _bReturnXMLContent, boolean _bForcedExportTempInfo) throws WCMException {
        if (_object == null) {
            throw new WCMException(10, I18NMessage.get(ChannelExporter.class, "ChannelExporter.label1", "\u65e0\u6548\u7684\u7ad9\u70b9/\u5bf9\u8c61[null]!"));
        }
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXmlFile = filesMan.getNextFileName("ST", "xml", null, true);
        ChannelXmlConverter converter = new ChannelXmlConverter(this.m_sSiteFieldList, this.m_sChannelFieldList);
        converter.setXmlEncoding(this.m_sXMLEncoding);
        converter.setWithChildren(_bWithChildren);
        converter.setWithExtField(_bWithRelate);
        if (!_bWithRelate && !_bForcedExportTempInfo) {
            converter.setWithTemp(false, null);
            if (_bReturnXMLContent) {
                return converter.toXMLString(_object);
            }
            converter.toXMLFile(_object, sXmlFile);
            return CMyFile.extractFileName(sXmlFile);
        }
        String sTempApdFilePath = CMyFile.extractFilePath(sXmlFile) + System.currentTimeMillis();
        converter.setWithTemp(true, sTempApdFilePath);
        String sZipFile = null;
        try {
            if (_bReturnXMLContent) {
                String string = converter.toXMLString(_object);
                return string;
            }
            converter.toXMLFile(_object, sXmlFile);
            sZipFile = filesMan.getNextFileName("ST", "zip", null, true);
            CMyZip myZip = new CMyZip();
            try {
                myZip.setZipFileName(sZipFile);
                myZip.addToZip(sXmlFile, false);
                if (_object instanceof WebSites || _object instanceof WebSite) {
                    myZip.addToZip(sTempApdFilePath, false);
                }
                myZip.done();
            }
            catch (CMyException e) {
                s_logger.error((Object)"failed to zip files!", (Throwable)e);
                CMyFile.deleteFile(sZipFile);
                throw new WCMException(1100, I18NMessage.get(ChannelExporter.class, "ChannelExporter.label2", "\u538b\u7f29\u6587\u4ef6\u5931\u8d25!"), e);
            }
        }
        finally {
            CMyFile.deleteFile(sXmlFile);
            CMyFile.deleteDir(sTempApdFilePath);
        }
        return CMyFile.extractFileName(sZipFile);
    }
}

