/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.advisor;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;

public class Advisor
extends CMSObj {
    public static final int OBJ_TYPE = 1460271229;
    public static final String DB_TABLE_NAME = "XWCMADVISOR";
    public static final String DB_ID_NAME = "ADVISORID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1460271229;
    }

    public String getAdvisorName() {
        return this.getPropertyAsString("ADVISORNAME");
    }

    public boolean setAdvisorName(String _sAdvisorName) throws WCMException {
        return this.setProperty("ADVISORNAME", _sAdvisorName);
    }

    public String getViewName() {
        return this.getPropertyAsString("VIEWNAME");
    }

    public boolean setViewName(String _sViewName) throws WCMException {
        return this.setProperty("VIEWNAME", _sViewName);
    }

    public int getChannelId() {
        int nChannelId = this.getPropertyAsInt("CHANNELID", 0);
        return nChannelId;
    }

    public boolean setChannelId(int _channelId) throws WCMException {
        return this.setProperty("CHANNELID", _channelId);
    }

    public String getAppendixFileName() {
        return this.getPropertyAsString("APPENDIXFILENAME");
    }

    public boolean setAppendixFileName(String _sAppendixFileName) throws WCMException {
        return this.setProperty("APPENDIXFILENAME", _sAppendixFileName);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("ADVISORNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(Advisor.class, "Advisor.label1", "\u5c5e\u6027AdvisorName\u6ca1\u6709\u8bbe\u7f6e(Advisor.isValid)"));
            }
            String sAppFileName = this.getPropertyAsString("APPENDIXFILENAME");
            if (!CMyString.isEmpty(sAppFileName)) {
                sAppFileName = FilesMan.getFilesMan().moveWCMFile(sAppFileName, "P0", false);
                this.setAppendixFileName(sAppFileName);
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Advisor.class, "Advisor.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Advisor.isValid)"));
            }
            if (this.isChangeProperty("APPENDIXFILENAME")) {
                String sNewFileName = this.getNewPropertyAsString("APPENDIXFILENAME");
                FilesMan filesMan = FilesMan.getFilesMan();
                String sOriginalFileName = this.getAppendixFileName();
                if (!CMyString.isEmpty(sOriginalFileName)) {
                    String sDstFilePath = filesMan.mapFilePath(sOriginalFileName, 0) + sOriginalFileName;
                    CMyFile.deleteFile(sDstFilePath);
                }
                if (!CMyString.isEmpty(sNewFileName)) {
                    sNewFileName = FilesMan.getFilesMan().moveWCMFile(sNewFileName, "P0", false);
                    this.setAppendixFileName(sNewFileName);
                }
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    @Override
    public int delete() throws WCMException {
        this.deleteRelationFiles();
        return super.delete();
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        this.deleteRelationFiles();
        return super.delete(_currUser);
    }

    private void deleteRelationFiles() throws WCMException {
        String sFileName = this.getAppendixFileName();
        if (!CMyString.isEmpty(sFileName)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sDstFilePath = filesMan.mapFilePath(sFileName, 0) + sFileName;
            CMyFile.deleteFile(sDstFilePath);
        }
    }

    public static final Advisor findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Advisor)BaseObj.findById(Advisor.class, _nId);
    }

    public static final Advisor createNewInstance() throws WCMException {
        return (Advisor)BaseObj.createNewInstance(Advisor.class);
    }

    public static final Advisor findByKey(Object _oKey) throws WCMException {
        return (Advisor)BaseObj.findByKey(Advisor.class, _oKey);
    }

    public Channel getChannel() throws WCMException {
        return Channel.findById(this.getChannelId());
    }
}

