/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.stat.IChnlDeptMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.DebugTimer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class DocStatHandlerByChannel
extends BaseStatHandler {
    private static Logger logger = Logger.getLogger(DocStatHandlerByChannel.class);
    private Channels canManagerChannels = new Channels(null);
    private final int error = -2;
    private final int group = -1;
    private User loginUser;
    private IChnlDeptMgr m_oChnlDeptMgr = null;
    private HashMap m_hRelGroupsOfChannel = new HashMap();
    private int nTypeIndex = -1;
    private String sTypeName = "";
    private String acceptType = "";
    private String acceptValue = "";
    private int acceptTypeIndex = -1;
    private int nChannelIndex = -1;
    private int nAddFieldCount = -1;
    private Channels acceptChannels = null;

    public DocStatHandlerByChannel(String sTypeName, String acceptTypeName, String acceptValue, int nAddFieldCount) throws WCMException {
        this.sTypeName = sTypeName;
        this.acceptType = acceptTypeName;
        this.acceptValue = acceptValue;
        this.nAddFieldCount = nAddFieldCount;
        this.m_oChnlDeptMgr = (IChnlDeptMgr)DreamFactory.createObjectById("IChnlDeptMgr");
        Groups canManageGroups = new Groups(null);
        this.loginUser = ContextHelper.getLoginUser();
        Groups relateGroups = this.loginUser.getGroups();
        for (int i = 0; i < relateGroups.size(); ++i) {
            Group oGroup = (Group)relateGroups.getAt(i);
            if (!oGroup.isAdministrator(this.loginUser)) continue;
            canManageGroups.addElement(oGroup);
        }
        if (canManageGroups == null || canManageGroups.size() == 0) {
            return;
        }
        String oChannelIds = this.m_oChnlDeptMgr.getChnlIdsByDepts(canManageGroups);
        this.canManagerChannels = Channels.findByIds(this.loginUser, oChannelIds);
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        this.nTypeIndex = this.getKeyIndex(this.sTypeName, resultSet);
        this.acceptTypeIndex = this.getKeyIndex(this.acceptType, resultSet);
        this.nChannelIndex = this.getKeyIndex("ChnlId", resultSet);
        super.visitStart(resultSet, nSQLIndex);
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int nSQLIndex) throws WCMException {
        try {
            Group _group;
            Channel channel;
            Groups oRelGroups;
            int nDataCount = resultSet.getInt(1);
            if (this.nChannelIndex < 0) {
                throw new WCMException("\u6ca1\u6709\u4f20\u5165\u680f\u76ee\u5b57\u6bb5\u6216\u8005\u680f\u76ee\u5b57\u6bb5\u6709\u8bef");
            }
            int nChannelId = resultSet.getInt(this.nChannelIndex);
            if (this.canManagerChannels.indexOf(nChannelId) < 0) {
                return;
            }
            if (this.acceptTypeIndex > 0 && "ChnlId".equalsIgnoreCase(this.acceptType) && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                int nChnlId = resultSet.getInt(this.acceptTypeIndex);
                boolean isSonChannel = false;
                Channel _chnl = Channel.findById(nChnlId);
                if (_chnl == null) {
                    return;
                }
                while (_chnl != null) {
                    if (_chnl.getId() == Integer.parseInt(this.acceptValue)) {
                        isSonChannel = true;
                        break;
                    }
                    _chnl = _chnl.getParent();
                }
                if (!isSonChannel) {
                    return;
                }
            } else if (this.acceptTypeIndex > 0 && !resultSet.getString(this.acceptTypeIndex).equalsIgnoreCase(this.acceptValue)) {
                return;
            }
            if (this.acceptTypeIndex == -1 && (oRelGroups = this.makeCurrRelGroups(channel = Channel.findById(nChannelId))).indexOf(_group = Group.findById(Integer.parseInt(this.acceptValue))) < 0) {
                return;
            }
            if (this.nTypeIndex > 0) {
                if (this.sTypeName.equalsIgnoreCase("ChnlId") && "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"))) {
                    String Key2 = resultSet.getString(this.nTypeIndex);
                    for (Channel parent = Channel.findById(nChannelId); parent != null; parent = parent.getParent()) {
                        Key2 = parent.getId() + "";
                        String sKey = this.makePrivateKey(Key2, resultSet);
                        int oldValue = this.getValue(nSQLIndex, sKey);
                        this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                        this.addMajorObject(Key2);
                    }
                } else {
                    String Key3 = resultSet.getString(this.nTypeIndex);
                    String sKey = this.makePrivateKey(Key3, resultSet);
                    int oldValue = this.getValue(nSQLIndex, sKey);
                    this.setValue(nSQLIndex, sKey, nDataCount + oldValue);
                    this.addMajorObject(Key3);
                }
            } else {
                channel = Channel.findById(nChannelId);
                if (channel == null) {
                    throw new WCMException("\u672a\u627e\u5230\u6307\u5b9a\u680f\u76ee! [ChannelId = " + nChannelId + "]");
                }
                DebugTimer timerTemp = new DebugTimer();
                timerTemp.start();
                Groups oRelGroups2 = this.makeCurrRelGroups(channel);
                timerTemp.stop();
                logger.debug((Object)("makeCurrRelGroups of channel-" + nChannelId + " use[" + timerTemp.getTime() + "]ms"));
                timerTemp.start();
                int nSize = oRelGroups2.size();
                for (int nRelChannelIndex = 0; nRelChannelIndex < nSize; ++nRelChannelIndex) {
                    Group oRelGroup = (Group)oRelGroups2.getAt(nRelChannelIndex);
                    if (oRelGroup == null) continue;
                    String sGroupId = oRelGroup.getId() + "";
                    String oGroupKey = this.makePrivateKey(sGroupId, resultSet);
                    int iExistsDataCount = this.getValue(nSQLIndex, oGroupKey);
                    int nDataCountOfCurrGroup = nDataCount;
                    this.setValue(nSQLIndex, oGroupKey, nDataCountOfCurrGroup += iExistsDataCount);
                    this.addMajorObject(sGroupId);
                }
            }
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020\u7ed3\u679c\u96c6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    private String makePrivateKey(String Key2, ResultSet resultSet) throws SQLException {
        int nColumnCount = resultSet.getMetaData().getColumnCount();
        if (nColumnCount > 1 + this.nAddFieldCount) {
            String[] sParam = new String[]{Key2, resultSet.getString(nColumnCount)};
            return this.makeKey(sParam);
        }
        return Key2;
    }

    private Groups makeCurrRelGroups(Channel _oChannel) throws WCMException {
        Groups oCurrRelGroups = (Groups)this.m_hRelGroupsOfChannel.get(_oChannel);
        if (oCurrRelGroups != null) {
            return oCurrRelGroups;
        }
        oCurrRelGroups = new Groups(null);
        String _sDepIds = this.m_oChnlDeptMgr.getDepIdsByChannel(_oChannel).toString();
        _sDepIds = _sDepIds.length() <= 2 ? "" : _sDepIds.substring(1, _sDepIds.length() - 1);
        oCurrRelGroups = Groups.findByIds(this.loginUser, _sDepIds.trim());
        int nSize = oCurrRelGroups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)oCurrRelGroups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null && AuthServer.hasRight(this.loginUser, (CMSObj)parent, 13); parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        this.m_hRelGroupsOfChannel.put(_oChannel.getKey(), oCurrRelGroups);
        return oCurrRelGroups;
    }

    private int getKeyIndex(String keyName, ResultSet resultSet) throws WCMException {
        if (keyName == null || keyName == "") {
            return -2;
        }
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int nColumnCount = metaData.getColumnCount();
            for (int i = 1; i <= nColumnCount; ++i) {
                if (!keyName.equalsIgnoreCase(metaData.getColumnName(i))) continue;
                return i;
            }
        }
        catch (SQLException e) {
            throw new WCMException(1100, "\u8bbe\u7f6ecruser\u7684\u7d22\u5f15\u4f4d\u7f6e\u51fa\u73b0\u9519\u8bef", e);
        }
        return -1;
    }
}

