/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.IKeyMaker;
import com.trs.components.stat.IStatHandler;
import com.trs.components.stat.IStatResult;
import com.trs.components.stat.StatResult;
import com.trs.infra.common.WCMException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseStatHandler
implements IStatHandler,
IKeyMaker {
    private static Logger logger = Logger.getLogger(BaseStatHandler.class);
    private static final String KEY_SEPARATOR = "#";
    private List results;
    private List majorObjects;

    @Override
    public void initState() {
        this.results = new ArrayList();
        this.majorObjects = new ArrayList();
    }

    @Override
    public IStatResult getResult() {
        return new StatResult(this.majorObjects, this.results, this);
    }

    protected void addMajorObject(Object majorObject) {
        if (!this.majorObjects.contains(majorObject)) {
            this.majorObjects.add(majorObject);
        }
    }

    protected int getValue(int nSQLIndex, String sKey) {
        int nIndex = nSQLIndex - 1;
        if (nIndex >= this.results.size()) {
            return 0;
        }
        Map result = (Map)this.results.get(nIndex);
        if (result == null) {
            return 0;
        }
        Integer dataCount = (Integer)result.get(sKey);
        if (dataCount == null) {
            return 0;
        }
        return dataCount;
    }

    protected void setValue(int nSQLIndex, String sKey, int nDataCount) {
        int nIndex = nSQLIndex - 1;
        if (nIndex >= this.results.size()) {
            this.results.add(nIndex, new HashMap());
        }
        Map result = (Map)this.results.get(nIndex);
        result.put(sKey, new Integer(nDataCount));
    }

    protected String makeKey(ResultSet resultSet) throws WCMException {
        try {
            int nColumnCount = resultSet.getMetaData().getColumnCount();
            StringBuffer sbKey = new StringBuffer(nColumnCount * 5);
            for (int i = 2; i <= nColumnCount; ++i) {
                sbKey.append(resultSet.getString(i)).append(KEY_SEPARATOR);
            }
            if (sbKey.length() > 0) {
                sbKey.setLength(sbKey.length() - 1);
            }
            return sbKey.toString();
        }
        catch (SQLException e) {
            logger.debug((Object)"\u6784\u9020key\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new WCMException("\u6784\u9020key\u4fe1\u606f\u65f6\u51fa\u73b0\u5f02\u5e38", e);
        }
    }

    @Override
    public String makeKey(String[] keys) {
        StringBuffer sbKey = new StringBuffer(keys.length * 5);
        for (int i = 0; i < keys.length; ++i) {
            sbKey.append(keys[i]).append(KEY_SEPARATOR);
        }
        if (sbKey.length() > 0) {
            sbKey.setLength(sbKey.length() - 1);
        }
        return sbKey.toString();
    }

    @Override
    public String[] makeFields(String sKey) {
        return sKey.split(KEY_SEPARATOR);
    }

    @Override
    public void visitEnd(int nSQLIndex) {
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        this.results.add(new HashMap());
    }
}

