/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.web;

import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.MetaDataType;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.web.impl.AddEditFieldTemplate;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.Config;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CharsetDetector;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class FieldTemplate {
    private static final Logger logger = Logger.getLogger(FieldTemplate.class);
    public static final int otherTableFieldType = -100;
    protected static Map fieldTypeKeys = new HashMap();
    private Map fieldTypeContents = new HashMap();

    public String getTemplateContent(MetaViewField oViewField) throws WCMException {
        Object oFieldType = this.makeKey(oViewField);
        String sContent = (String)this.fieldTypeContents.get(oFieldType);
        if (sContent != null) {
            return sContent;
        }
        String sWcmPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWcmPath = CMyString.setStrEndWith(sWcmPath, File.separatorChar);
        String sPath = this.getTemplatePath();
        sPath = CMyString.setStrEndWith(sPath, File.separatorChar);
        String sFileName = (String)fieldTypeKeys.get(oFieldType);
        String sFullFileName = sWcmPath + sPath + sFileName + ".html";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("sFullFileName1:" + sFullFileName));
        }
        try {
            if (!new FileService(sFullFileName).exists()) {
                MetaDataType dataType = MetaDataConstants.DATA_TYPES.getDataTypeById(oViewField.getType());
                sFileName = dataType.getKey();
                sFullFileName = sWcmPath + sPath + sFileName + ".html";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sFullFileName2:" + sFullFileName));
                }
                if (!new FileService(sFullFileName).exists()) {
                    sFullFileName = sWcmPath + sPath + "default.html";
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("sFullFileName3:" + sFullFileName));
                }
            }
            String sFileEncoding = CharsetDetector.detect(sFullFileName);
            Config config = ConfigServer.getServer().getSysConfig("METADATA_TEMPLATE_ENCODING");
            if (config != null) {
                sFileEncoding = config.getValue();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sFullFileName:" + sFullFileName + ";sFileEncoding:" + sFileEncoding));
            }
            sContent = CMyFile.readFile(sFullFileName, sFileEncoding);
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        this.fieldTypeContents.put(oFieldType, sContent);
        return sContent;
    }

    protected Object makeKey(MetaViewField oViewField) {
        if (this instanceof AddEditFieldTemplate && !oViewField.isFromMainTable()) {
            return new Integer(-100);
        }
        int nFieldType = oViewField.getType();
        if (nFieldType != 1) {
            return new Integer(nFieldType);
        }
        return nFieldType + "_" + oViewField.getDBType();
    }

    protected abstract String getTemplatePath();

    static {
        fieldTypeKeys.put(new Integer(-100), "othertable");
        fieldTypeKeys.put(new Integer(-1), "enum");
        fieldTypeKeys.put(new Integer(8), "appendix");
        fieldTypeKeys.put(new Integer(10), "classinfo");
        fieldTypeKeys.put(new Integer(12), "editor");
        fieldTypeKeys.put(new Integer(14), "relateddoc");
        fieldTypeKeys.put(new Integer(15), "inputselect");
        fieldTypeKeys.put(new Integer(16), "simpleeditor");
        fieldTypeKeys.put(new Integer(17), "suggestion");
        fieldTypeKeys.put(new Integer(6), "radio");
        fieldTypeKeys.put(new Integer(7), "select");
        fieldTypeKeys.put(new Integer(9), "checkbox");
        fieldTypeKeys.put(new Integer(3), "normaltext");
        fieldTypeKeys.put(new Integer(2), "password");
        fieldTypeKeys.put(new Integer(4), "multitext");
        fieldTypeKeys.put(new Integer(5), "trueorfalse");
        fieldTypeKeys.put(new Integer(1), "selfdefine");
        fieldTypeKeys.put(new Integer(11), "timestamp");
        fieldTypeKeys.put(new Integer(18), "link");
        fieldTypeKeys.put(new Integer(19), "bigfile");
        fieldTypeKeys.put(new Integer(20), "masvideo");
        fieldTypeKeys.put(new Integer(21), "maslive");
        fieldTypeKeys.put(new Integer(22), "googlemap");
        fieldTypeKeys.put(new Integer(24), "baidumap");
        fieldTypeKeys.put(new Integer(23), "channeltree");
        fieldTypeKeys.put("1_4", "integer");
        fieldTypeKeys.put("1_6", "float");
        fieldTypeKeys.put("1_8", "double");
        fieldTypeKeys.put("1_12", "normaltext");
        fieldTypeKeys.put("1_93", "timestamp");
        fieldTypeKeys.put("1_2005", "editor");
        fieldTypeKeys.put(29, "keyword");
        fieldTypeKeys.put(31, "relatednews");
        fieldTypeKeys.put(32, "relatedpic");
        fieldTypeKeys.put(33, "relatedvideo");
        fieldTypeKeys.put(34, "summary");
        fieldTypeKeys.put(35, "title");
        fieldTypeKeys.put(39, "shorttitle");
        fieldTypeKeys.put(40, "hiddenfield");
        fieldTypeKeys.put(43, "hiddenfieldclob");
        fieldTypeKeys.put(42, "normalpic");
    }
}

