/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.listener;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.webframework.config.ServiceListenerConfig;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IServiceListener;
import org.apache.log4j.Logger;

public class SaveListenerForMetaViewData
implements IServiceListener {
    private Logger logger = Logger.getLogger(SaveListenerForMetaViewData.class);

    @Override
    public void afterServiceExecuted(ServiceListenerConfig listenerConfig, MethodContext methodContext, Object serviceResult) {
        int docLevelId = methodContext.getValue("DOCLEVEL", 0);
        MetaViewData viewData = (MetaViewData)serviceResult;
        try {
            Document document = viewData.getDocument();
            User user = ContextHelper.getLoginUser();
            document.setDocLevel(docLevelId);
            document.save(user);
            ChnlDoc chnlDoc = ChnlDoc.findByDocument(document);
            chnlDoc.setDocLevel(docLevelId);
            chnlDoc.save(user);
        }
        catch (Exception e) {
            this.logger.error((Object)I18NMessage.get(SaveListenerForMetaViewData.class, "SaveListenerForMetaViewData.label1", "\u4fdd\u5b58\u5143\u6570\u636e\u7684\u5bc6\u7ea7\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
        }
    }
}

