/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ChannelServiceProvider;
import com.trs.ajaxservice.ViewDocumentServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteServiceProvider;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.common.message.MessageServer;
import com.trs.components.common.message.Messages;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaDataCenterHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.service.MetaDataCenterServiceProvider;
import com.trs.components.metadata.service.MetaDataDefServiceProvider;
import com.trs.components.video.VSConfig;
import com.trs.components.wcm.MyPlugin;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.exception.ServiceInvocationException;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PublicResourceServiceProvider
implements ISelfDefinedServiceProvider {
    private static Logger logger = Logger.getLogger(PublicResourceServiceProvider.class);
    private static Map<Integer, String> repositoryTypes = new HashMap<Integer, String>();
    private static String sQueryLeafChannelMode = "QUERY_LEAF_CHANNEL_MODE";
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");
    private DocumentMgr m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
    private IImageLibMgr m_oImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private MetaView findViewById(int _nViewId) throws WCMException {
        MetaView view = MetaView.findById(_nViewId);
        return view;
    }

    private boolean testCanDeleteView(MetaView oView) throws WCMException {
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(oView.getKey());
        String sTestSQL = "select count(DocId) from WCMDocument where Dockind=?";
        int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sTestSQL, parameters);
        return nCount <= 0;
    }

    private BaseChannel getParentChannelOrSite(MethodContext _methodContext) throws WCMException {
        BaseChannel parent;
        int nParentId = _methodContext.getValue("ParentId", 0);
        if (nParentId == 0) {
            int nSiteId = _methodContext.getValue("SiteId", 0);
            if (nSiteId <= 0) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label6", "\u6ca1\u6709\u6307\u5b9aParentId\u6216\u8005SiteId    "));
            }
            parent = WebSite.findById(nSiteId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nSiteId), WCMTypes.getLowerObjName(103)}));
            }
        } else {
            parent = Channel.findById(nParentId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nParentId), WCMTypes.getLowerObjName(101)}));
            }
        }
        return parent;
    }

    private void validateRight(User _loginUser, String _sChnlDocIds, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (ViewDocuments.QUERY_ACCORD_DOCUMENT_RIGHT) {
            ViewDocuments viewDocuments = WCMDocumentHelper.findViewDocumentsByIds(_loginUser, _sChnlDocIds);
            int nSize = viewDocuments.size();
            for (int i = 0; i < nSize; ++i) {
                ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
                if (viewDocument == null) continue;
                String sDocInfo = "DocId=" + viewDocument.getDocId();
                if (viewDocument.hasRight(_loginUser, _nRightIndex)) continue;
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{_loginUser.toString(), sDocInfo, _sOperDesc}));
            }
        } else {
            if (_loginUser.isAdministrator()) {
                return;
            }
            Channels channels = this.findChannelsByChnlDocIds(_loginUser, _sChnlDocIds);
            int nSize = channels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                this.validateRight(_loginUser, channel, _nRightIndex, _sOperDesc);
            }
        }
    }

    private Channels findChannelsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "RecId in(" + _sChnlDocIds + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs(_loginUser, filter);
    }

    private void validateRight(User _loginUser, BaseChannel _oSiteOrChannel, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_oSiteOrChannel, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label56", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label57", "]\u6ca1\u6709\u6743\u9650\u5728(") + _oSiteOrChannel + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label58", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label59", "]\u64cd\u4f5c\uff01"));
        }
    }

    private MetaView findViewByChannel(Channel _channel) throws WCMException {
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(_channel);
        if (view == null) {
            throw new WCMException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label37", "\u6307\u5b9a\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u89c6\u56fe\uff01[\u680f\u76ee\u4fe1\u606f=") + _channel + "]");
        }
        return view;
    }

    public Map<String, Object> createRepository(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        int nViewId = _methodContext.getObjectId();
        try {
            User loginUser = this.getLoginUser();
            int nRepositoryTypeId = _methodContext.getValue("RepositoryTypeId", 0);
            if (!repositoryTypes.containsKey(new Integer(nRepositoryTypeId))) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u8981\u521b\u5efa\u7684\u8d44\u6e90\u5e93\u7c7b\u578b");
            }
            MetaView view = null;
            int nChannelId = _methodContext.getValue("ChannelId", 0);
            if (nViewId == 0) {
                int nOwnerType = _methodContext.getValue("OwnerType", 1);
                int nOwnerId = _methodContext.getValue("OwnerId", 1);
                if (nChannelId > 0) {
                    nOwnerType = 101;
                    nOwnerId = nChannelId;
                }
                CMSObj owner = this.findOwner(nOwnerType, nOwnerId);
                this.validateRight(loginUser, owner);
                int nMainTableId = _methodContext.getValue("MainTableId", 0);
                String sViewName = _methodContext.getValue("ViewDesc");
                MetaDBTable dbMainTable = null;
                if (nMainTableId == 0) {
                    String sTableName = _methodContext.getValue("TableName");
                    dbMainTable = MetaDBTable.createNewInstance();
                    dbMainTable.setAnotherName(sViewName);
                    dbMainTable.setName(sTableName);
                    dbMainTable.setOwner(nOwnerType, nOwnerId);
                    dbMainTable = this.m_oMetaDataDefMgr.save(loginUser, dbMainTable);
                    nMainTableId = dbMainTable.getId();
                } else {
                    dbMainTable = this.findDBTableInfo(nMainTableId);
                }
                view = MetaView.createNewInstance();
                view.setRepositoryIcon(_methodContext.getValue("RepositoryIcon"));
                view.setRepositoryTypeId(_methodContext.getValue("RepositoryTypeId", 0));
                view.setMainTable(dbMainTable);
                view.setOtherTableIds(_methodContext.getValue("OtherTableIds"));
                view.setDesc(sViewName);
                view.setOwner(nOwnerType, nOwnerId);
                view.setTemplatePath(_methodContext.getValue("TemplatePath"));
            } else {
                view = this.findViewById(nViewId);
                if (view == null) {
                    throw new RuntimeException("\u8bf7\u786e\u8ba4\u8981\u7f16\u8f91\u7684\u8d44\u6e90\u5e93");
                }
                if (_methodContext.containsParameter("MainTableId")) {
                    MetaDBTable dbMainTable = this.findDBTableInfo(_methodContext.getValue("MainTableId", 0));
                    view.setMainTable(dbMainTable);
                }
                if (_methodContext.containsParameter("OtherTableIds")) {
                    view.setOtherTableIds(_methodContext.getValue("OtherTableIds"));
                }
                if (_methodContext.containsParameter("ViewDesc")) {
                    view.setDesc(_methodContext.getValue("ViewDesc"));
                }
                if (_methodContext.containsParameter("TemplatePath")) {
                    view.setTemplatePath(_methodContext.getValue("TemplatePath"));
                }
            }
            view = this.m_oMetaDataDefMgr.save(loginUser, view);
            if (nChannelId > 0) {
                Channel channel = this.findChannelById(nChannelId);
                this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
                this.m_oMetaDataDefMgr.createViewRelations(loginUser, view, true);
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("result", view);
            map.put("msg", nViewId == 0 ? "\u521b\u5efa\u8d44\u6e90\u5e93\u6210\u529f" : "\u4fdd\u5b58\u8d44\u6e90\u5e93\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)(nViewId == 0 ? "\u521b\u5efa\u8d44\u6e90\u5e93\u5931\u8d25" : "\u4fdd\u5b58\u8d44\u6e90\u5e93\u5931\u8d25"), (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> queryRepositories(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            int nRepositoryTypeId = _methodContext.getValue("repositoryTypeId", 0);
            if (!repositoryTypes.containsKey(new Integer(nRepositoryTypeId))) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u8981\u67e5\u8be2\u7684\u8d44\u6e90\u5e93\u5206\u7c7b");
            }
            WCMFilter filter = new WCMFilter("", "REPOSITORYTYPEID=?", "");
            filter.addSearchValues(nRepositoryTypeId);
            MetaViews metaViews = MetaViews.openWCMObjs(loginUser, filter);
            HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
            temp.put("items", metaViews);
            temp.put("totalCount", new Integer(metaViews.size()));
            map.put("isSucc", Boolean.TRUE);
            map.put("result", temp);
            map.put("msg", "\u67e5\u8be2\u8d44\u6e90\u5e93\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u8d44\u6e90\u5e93\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> deleteRepositories(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            MetaViews oMetaViews = MetaViews.findByIds(this.getLoginUser(), _methodContext.getObjectIds());
            Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label14", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe"));
            int nSize = oMetaViews.size();
            for (int i = 0; i < nSize; ++i) {
                MetaView oMetaView = (MetaView)oMetaViews.getAt(i);
                if (oMetaView == null) continue;
                this.validateRight(loginUser, oMetaView);
                try {
                    if (!this.testCanDeleteView(oMetaView)) {
                        String sTip = CMyString.format(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u4e0d\u80fd\u5220\u9664\u89c6\u56fe[{0}],\u56e0\u4e3a\u8be5\u89c6\u56fe\u4e0b\u6570\u636e\u4e0d\u4e3a\u7a7a"), new String[]{oMetaView.getDesc()});
                        reports.addFailedReport(sTip, new WCMException(sTip));
                        continue;
                    }
                    this.m_oMetaDataDefMgr.delete(loginUser, oMetaView);
                    reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + oMetaView.getName() + "][" + oMetaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                    continue;
                }
                catch (Exception e) {
                    reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + oMetaView.getName() + "][" + oMetaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
                }
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u5220\u9664\u8d44\u6e90\u5e93\u6210\u529f");
            map.put("result", reports);
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u8d44\u6e90\u5e93\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    private Channel findChannelById(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label20", "\u6307\u5b9a\u7684\u680f\u76ee\u6ca1\u6709\u627e\u5230\uff01[Id=") + _nChannelId + "]");
        }
        return channel;
    }

    private MetaDBTable findDBTableInfo(int _nObjectId) throws WCMException {
        MetaDBTable oDBTableInfo = MetaDBTable.findById(_nObjectId);
        if (oDBTableInfo == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label31", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8868\uff01[Id=") + _nObjectId + "]");
        }
        return oDBTableInfo;
    }

    private CMSObj findOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        switch (_nOwnerType) {
            case 1: {
                return new WCMSystemObject(_nOwnerId);
            }
        }
        CMSObj result = (CMSObj)BaseObj.findById(_nOwnerType, _nOwnerId);
        if (result == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label33", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5bf9\u8c61\uff01[Type=") + _nOwnerType + ", Id=" + _nOwnerId + "]");
        }
        return result;
    }

    private void validateRight(User _loginUser, CMSObj _owner) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        int nRightIndex = -1;
        switch (_owner.getWCMType()) {
            case 101: {
                nRightIndex = 13;
                break;
            }
            case 1: {
                nRightIndex = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label22", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + _owner.getWCMType() + "]");
            }
        }
        if (nRightIndex >= 0) {
            if (!AuthServer.hasRight(_loginUser, _owner, nRightIndex)) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label23", "\u60a8\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
            }
        } else if (!_loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label24", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
        }
    }

    private void validatePluginRight(int _nSiteType) throws Exception {
        switch (_nSiteType) {
            case 1: {
                if (PluginConfig.isStartPhoto()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 2: {
                if (PluginConfig.isStartVideo()) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label2", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u56fe\u7247\u9009\u4ef6\uff01"));
            }
            case 4: {
                CMyBitsValue bitsValue = new CMyBitsValue(MyPlugin.getPluginCode());
                if (bitsValue.getBit(2)) break;
                throw new Exception(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label3", "\u60a8\u6ca1\u6709\u8d2d\u4e70\u5143\u6570\u636e\u7ba1\u7406\u9009\u4ef6\uff01"));
            }
        }
    }

    private Channels makeChannelsWithRightOfChannels(User _loginUser, boolean _bAdminstrator, CMSBaseObjs _channels, int _nRightIndex, boolean _bContainsChildren) throws WCMException {
        Channels oQueryChannels = (Channels)_channels;
        for (int nRemoveChannelIndex = oQueryChannels.size() - 1; nRemoveChannelIndex >= 0; --nRemoveChannelIndex) {
            boolean bSuperManOnTheChannel;
            Channel channel = (Channel)oQueryChannels.getAt(nRemoveChannelIndex);
            if (channel == null) continue;
            boolean bl = bSuperManOnTheChannel = _bAdminstrator || _loginUser.getName().equals(channel.getCrUserName());
            if (bSuperManOnTheChannel) {
                if (!_bContainsChildren) continue;
                this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, oQueryChannels, channel);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)channel, _loginUser);
            if (!rightValue.isHasRight(_nRightIndex)) {
                oQueryChannels.removeAt(nRemoveChannelIndex, false);
            }
            if (rightValue.getValue() <= 0L || !_bContainsChildren) continue;
            this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, oQueryChannels, channel);
        }
        return oQueryChannels;
    }

    private Channels makeChildChannelsWithRightOfSites(User _loginUser, boolean _bAdminstrator, int _nRightIndex, CMSBaseObjs _sites) throws WCMException {
        Channels oQueryChannels = new Channels(null, 200, 1);
        int nSize = _sites.size();
        for (int nSiteIndex = 0; nSiteIndex < nSize; ++nSiteIndex) {
            WebSite site = (WebSite)_sites.getAt(nSiteIndex);
            if (site == null) continue;
            WCMFilter filterChannels = null;
            String sLeafMode = ConfigServer.getServer().getSysConfigValue(sQueryLeafChannelMode, "false");
            if (sLeafMode.equalsIgnoreCase("true") || sLeafMode.equals("1")) {
                String sLeafChannelsWhere = "SiteId=? and not exists(select 1 from WCMChannel b where b.SiteId=? and b.ParentId = a.ChannelId)";
                filterChannels = new WCMFilter("WCMChannel a", sLeafChannelsWhere, "");
                filterChannels.addSearchValues(site.getId());
                filterChannels.addSearchValues(site.getId());
            } else {
                String sChannelsWhere = "SiteId = ?";
                filterChannels = new WCMFilter("", sChannelsWhere, "");
                filterChannels.addSearchValues(site.getId());
            }
            Channels channels = Channels.openWCMObjs(null, filterChannels);
            if (_bAdminstrator || _loginUser.getName().equals(site.getCrUserName())) {
                if (nSiteIndex == 0) {
                    oQueryChannels = channels;
                    continue;
                }
                oQueryChannels.addWith(channels);
                continue;
            }
            int nChannelsSize = channels.size();
            for (int nChannelIndex = 0; nChannelIndex < nChannelsSize; ++nChannelIndex) {
                Channel channel = (Channel)channels.getAt(nChannelIndex);
                if (channel == null || !AuthServer.hasRight(_loginUser, (CMSObj)channel, _nRightIndex) || channel.getStatus() < 0) continue;
                oQueryChannels.addElement(channel);
            }
        }
        return oQueryChannels;
    }

    private void makeChildren(User _loginUser, boolean _bAdminstrator, int _nRightIndex, Channels _oRecordChannels, Channel _parent) throws WCMException {
        List<Channel> lChildren = _parent.getChildren(null);
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Channel child = lChildren.get(i);
            if (child == null) continue;
            if (_bAdminstrator || _loginUser.getName().equalsIgnoreCase(child.getCrUserName())) {
                _oRecordChannels.addElement(child);
                this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, _oRecordChannels, child);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)child, _loginUser);
            if (rightValue.isHasRight(_nRightIndex)) {
                _oRecordChannels.addElement(child);
            }
            if (rightValue.getValue() <= 0L) continue;
            this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, _oRecordChannels, child);
        }
    }

    private static MetaViewData setViewDataProperties(MethodContext _methodContext, MetaViewData _oViewData) throws WCMException {
        Map mapParams = _methodContext.getParams();
        for (String sParamName : mapParams.keySet()) {
            Object value = mapParams.get(sParamName);
            if (value instanceof String) {
                _oViewData.setProperty(sParamName, value.toString().trim());
                continue;
            }
            if (value instanceof String[]) {
                String[] pValues = (String[])value;
                _oViewData.setProperty(sParamName, pValues == null || pValues.length == 0 ? null : pValues[0].trim());
                continue;
            }
            _oViewData.setProperty(sParamName, value);
        }
        return _oViewData;
    }

    public Map<String, Object> queryChannels(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            int siteId = _methodContext.getValue("SITEID", 0);
            if (siteId == 0) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u680f\u76ee\u6240\u5c5e\u7ad9\u70b9");
            }
            int parentId = _methodContext.getValue("PARENTID", 0);
            WCMFilter filter = new WCMFilter("", "SITEID=? and PARENTID=?", "");
            filter.addSearchValues(siteId);
            filter.addSearchValues(parentId);
            Channels channels = Channels.openWCMObjs(this.getLoginUser(), filter);
            for (int i = 0; i < channels.size(); ++i) {
                Channel c = (Channel)channels.getAt(i);
                boolean containsChildren = c.isContainsChildren();
                System.out.println("===========\u5305\u542b\u5b50\u5b59\u8282\u70b9========" + containsChildren);
            }
            HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
            temp.put("ITEMS", channels);
            temp.put("totalCount", new Integer(channels.size()));
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u67e5\u8be2\u8d44\u6e90\u5e93\u4e0b\u5206\u7c7b\u6210\u529f");
            map.put("result", temp);
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u8d44\u6e90\u5e93\u4e0b\u5206\u7c7b\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> createWebSite(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            WebSite site = null;
            int nObjectId = _methodContext.getObjectId();
            if (nObjectId == 0) {
                site = new WebSite();
                if (!loginUser.isAdministrator()) {
                    throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label4", "\u60a8\u4e0d\u662f\u7cfb\u7edf\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u521b\u5efa\u7ad9\u70b9\uff01"));
                }
            } else {
                site = WebSite.findById(nObjectId);
                if (site == null) {
                    throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label5", "\u6307\u5b9a\u7684\u7ad9\u70b9\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
                }
                int nRightIndex = 1;
                if (!AuthServer.hasRight(loginUser, (CMSObj)site, nRightIndex)) {
                    throw new WCMException(I18NMessage.get(WebSiteServiceProvider.class, "WebSiteServiceProvider.label6", "\u60a8\u6ca1\u6709\u4fee\u6539\u7ad9\u70b9![") + site + "]");
                }
                site.validCanEditAndLock(loginUser);
            }
            String[] pLogicFields = new String[]{"ObjectId"};
            site = (WebSite)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, site, pLogicFields);
            this.validatePluginRight(site.getType());
            this.m_oChannelMgr.save(site);
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u521b\u5efa\u7ad9\u70b9\u6210\u529f");
            map.put("result", site);
        }
        catch (Exception e) {
            logger.error((Object)"\u521b\u5efa\u7ad9\u70b9\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> createChannel(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            BaseChannel rightHost;
            User loginUser = this.getLoginUser();
            Channel channel = null;
            BaseChannel parent = null;
            int nObjectId = _methodContext.getObjectId();
            if (nObjectId == 0) {
                channel = new Channel();
                parent = this.getParentChannelOrSite(_methodContext);
            } else {
                channel = Channel.findById(nObjectId);
                if (channel == null) {
                    throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
                }
            }
            int nRightIndex = nObjectId == 0 ? 11 : 13;
            BaseChannel baseChannel = rightHost = nObjectId == 0 ? parent : channel;
            if (!AuthServer.hasRight(loginUser, (CMSObj)rightHost, nRightIndex)) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6216\u8005\u4fee\u6539\u680f\u76ee![ObjectId=") + _methodContext.getObjectId() + "][Host=" + rightHost + "]");
            }
            String[] pLogicFields = new String[]{"ObjectId"};
            if ((channel = (Channel)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, channel, pLogicFields)).isAddMode() && parent != null) {
                channel.setSite(parent.getSiteId());
            }
            if (_methodContext.containsParameter("OnlySearch")) {
                channel.setOnlySearch(_methodContext.getValue("OnlySearch", false));
            }
            if (_methodContext.containsParameter("OnlyManager")) {
                channel.setOnlyManager(_methodContext.getValue("OnlyManager", false));
            }
            if (_methodContext.containsParameter("CanPub")) {
                channel.setCanPub(_methodContext.getValue("CanPub", true));
            }
            if (_methodContext.containsParameter("DoDeptFilter")) {
                channel.setDoDeptFilter(_methodContext.getValue("DoDeptFilter", true));
            }
            this.m_oChannelMgr.save(channel);
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u521b\u5efa\u680f\u76ee\u6210\u529f");
            map.put("result", channel);
        }
        catch (Exception e) {
            logger.error((Object)"\u521b\u5efa\u680f\u76ee\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> setViewToChannels(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            Channel channel;
            int i;
            User loginUser = this.getLoginUser();
            int nViewId = _methodContext.getValue("ViewId", 0);
            MetaView view = null;
            if (nViewId <= 0) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + nViewId + "]");
            }
            view = this.findViewById(nViewId);
            Channels oChannels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
            int[] sChnlIds = CMyString.splitToInt(_methodContext.getObjectIds(), ",");
            for (i = oChannels.size() - 1; i >= 0; --i) {
                channel = (Channel)oChannels.getAt(i);
                if (channel == null) continue;
                boolean bFound = false;
                for (int j = 0; j < sChnlIds.length; ++j) {
                    if (channel.getId() != sChnlIds[j]) continue;
                    sChnlIds[j] = 0;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 13)) {
                    throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
                }
                this.m_oMetaViewEmployerMgr.clearEmployer(loginUser, channel);
            }
            for (i = 0; i < sChnlIds.length; ++i) {
                if (sChnlIds[i] == 0 || Channel.findById(sChnlIds[i]) == null) continue;
                channel = Channel.findById(sChnlIds[i]);
                if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 13)) {
                    throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
                }
                this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
            }
        }
        catch (Exception e) {
            logger.error((Object)"\u5206\u914d\u89c6\u56fe\u5230\u680f\u76ee\u5931\u8d25");
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> queryResources(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        return map;
    }

    public Map<String, Object> queryResourceById(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            int docId = _methodContext.getValue("objectId", 0);
            if (docId == 0) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u8981\u67e5\u770b\u7684\u8d44\u6e90");
            }
            Document doc = Document.findById(docId);
            if (doc == null) {
                throw new RuntimeException("\u67e5\u770b\u7684\u8d44\u6e90\u4e0d\u5b58\u5728");
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u67e5\u770b\u8d44\u6e90\u6210\u529f");
            map.put("result", doc);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> queryResourceTypes(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            int viewid = _methodContext.getValue("viewid", 0);
            int parentId = _methodContext.getValue("parentId", 0);
            if (viewid == 0) {
                throw new Exception("viewid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MetaView metaView = this.findViewById(viewid);
            if (metaView == null) {
                throw new Exception("\u8d44\u6e90\u5e93\u4e0d\u5b58\u5728");
            }
            WCMFilter filter = new WCMFilter("", "PARENTID=?", "");
            filter.addSearchValues(0, parentId);
            Channels oChannels = this.m_oMetaViewEmployerMgr.getEmployers(metaView, filter);
            HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
            ArrayList<Hashtable<String, Object>> items = new ArrayList<Hashtable<String, Object>>();
            for (int i = 0; i < oChannels.size(); ++i) {
                Channel c = (Channel)oChannels.getAt(i);
                int count = c.getChildrenSize(this.getLoginUser());
                Hashtable<String, Object> props = c.getAllProperty();
                props.put("ISPARENT", count > 0);
                items.add(props);
            }
            temp.put("items", items);
            temp.put("totalCount", new Integer(oChannels.size()));
            map.put("isSucc", Boolean.TRUE);
            map.put("result", temp);
            map.put("msg", "\u67e5\u8be2\u8d44\u6e90\u5217\u8868\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u8d44\u6e90\u5217\u8868\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> queryRepositoryFields(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            int objectId = _methodContext.getValue("ObjectId", 0);
            int channelid = _methodContext.getValue("channelId", 0);
            MetaView metaView = null;
            if (objectId != 0) {
                metaView = this.findViewById(objectId);
            } else if (channelid != 0) {
                Channel chnl = Channel.findById(channelid);
                if (null != chnl) {
                    metaView = this.findViewByChannel(chnl);
                }
            } else {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u89c6\u56fe\u6216\u680f\u76eeid");
            }
            if (metaView == null) {
                throw new Exception("\u8d44\u6e90\u5e93\u4e0d\u5b58\u5728");
            }
            _methodContext.setValue("View", metaView);
            MetaViewFields fields = this.m_oMetaDataDefMgr.getViewFields(loginUser, metaView, _methodContext.getExtraWCMFilter());
            if (_methodContext.containsParameter("INOUTLINE") && _methodContext.getValue("INOUTLINE", false)) {
                MetaViewFields result = new MetaViewFields(loginUser);
                for (int i = 0; i < fields.size(); ++i) {
                    MetaViewField field = (MetaViewField)fields.getAt(i);
                    if (!field.isInOutline()) continue;
                    result.addElement(field);
                }
                map.put("result", result);
            } else {
                map.put("result", fields);
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u67e5\u8be2\u8d44\u6e90\u5b57\u6bb5\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u8d44\u6e90\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> queryRelatingResources(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            String objectIds = _methodContext.getValue("resourceIds");
            if (null == objectIds || objectIds.length() < 1) {
                throw new RuntimeException("\u8bf7\u786e\u8ba4\u76f8\u5173\u8d44\u6e90id\u5e8f\u5217");
            }
            MetaViewDatas mvds = MetaViewDatas.findByIds(objectIds);
            if (null == mvds || mvds.size() < 1) {
                throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8d44\u6e90");
            }
            HashMap<String, Serializable> temp = new HashMap<String, Serializable>();
            temp.put("items", mvds);
            temp.put("totalCount", new Integer(mvds.size()));
            map.put("isSucc", Boolean.TRUE);
            map.put("result", temp);
            map.put("msg", "\u67e5\u8be2\u76f8\u5173\u8d44\u6e90\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u76f8\u5173\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> deleteResources(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            ChnlDocs chnldocs;
            User loginUser = this.getLoginUser();
            boolean bDrop = _methodContext.getValue("drop", false);
            int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
            if (nFlowDocId <= 0) {
                this.validateRight(loginUser, _methodContext.getObjectIds(), 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
            }
            ContextParameters.set0((chnldocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds())).size() > 1);
            int nSize = chnldocs.size();
            for (int i = 0; i < nSize; ++i) {
                Document document;
                Channel channel;
                ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (chnldoc == null || (channel = chnldoc.getChannel()) == null || (document = chnldoc.getDocument()) == null) continue;
                if (nFlowDocId > 0) {
                    WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
                }
                this.m_oDocumentMgr.delete(document, channel, bDrop);
                if (document.getType() != 20 || !bDrop) continue;
                this.m_oImageLibMgr.deleteDocumentQuoteImage(document.getId());
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u5220\u9664\u8d44\u6e90\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u5220\u9664\u8d44\u6e90\u5931\u8d25", (Throwable)e);
            map.put("msg", e.getMessage());
            map.put("isSucc", Boolean.FALSE);
        }
        return map;
    }

    public Map<String, Object> saveResource(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            Document document;
            User loginUser = this.getLoginUser();
            Channel channel = null;
            MetaView view = null;
            MetaViewData oMetaViewData = null;
            int nObjectId = _methodContext.getObjectId();
            if (nObjectId == 0) {
                channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
                if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 31)) {
                    throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label2", "]\u4e0b\u65b0\u5efa\u8bb0\u5f55\uff01"));
                }
                view = this.findViewByChannel(channel);
                oMetaViewData = new MetaViewData(view);
            } else {
                oMetaViewData = MetaViewData.findById(nObjectId);
                if (oMetaViewData == null) {
                    throw new WCMException(200006, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label3", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5728\u6307\u5b9a\u89c6\u56fe\u4e0b\u63d0\u4ea4\u7684\u6570\u636e\uff01[Id=") + nObjectId + "]");
                }
                channel = oMetaViewData.getChannel();
                _methodContext.setValue("channelId", channel.getId());
                document = oMetaViewData.getDocument();
                int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
                if (nFlowDocId > 0 && nObjectId > 0) {
                    WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 0, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label4", "\u4fee\u6539"));
                } else if (!DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, document, 32)) {
                    throw new WCMException(1002, I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label1", "\u6ca1\u6709\u6743\u9650\u5728\u5f53\u524d\u680f\u76ee[") + channel.getName() + "][ID=" + channel.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label5", "]\u4e0b\u4fee\u6539\u8bb0\u5f55\uff01"));
                }
                view = oMetaViewData.getMetaView();
                oMetaViewData.validCanEditAndLock(loginUser);
            }
            oMetaViewData = PublicResourceServiceProvider.setViewDataProperties(_methodContext, oMetaViewData);
            MetaDataCenterHelper.renderFields(oMetaViewData);
            MetaDataCenterClassInfoHelper.renderClassInfoFields(oMetaViewData);
            if (_methodContext.getValue("DocStatus", 0) == 1028) {
                oMetaViewData.setSkipValid(true);
            }
            oMetaViewData.save(loginUser);
            if (nObjectId > 0) {
                int nDocStatus = _methodContext.getValue("DocStatus", 0);
                Document document2 = oMetaViewData.getDocument();
                if (nDocStatus == 1 && document2.getStatusId() == 1028) {
                    DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
                    documentMgr.changeStatus(document2, document2.getChannel(), Status.findById(1));
                }
            }
            document = Document.findById(oMetaViewData.getId());
            try {
                WCMProcessServiceHelper.startDocumentInFlow(loginUser, document, _methodContext);
            }
            catch (Throwable ex) {
                ServiceInvocationException exp = new ServiceInvocationException(I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label6", "\u867d\u7136\u5df2\u6210\u529f\u65b0\u589e\u6587\u6863[") + document.getTitle() + "-" + document.getId() + I18NMessage.get(MetaDataCenterServiceProvider.class, "MetaDataCenterServiceProvider.label7", "]\uff0c\u4f46\u5c06\u5176\u6295\u5165\u6d41\u8f6c\u5931\u8d25\uff01"), ex);
                exp.setErrorCode("17080");
                throw exp;
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u4fdd\u5b58\u8d44\u6e90\u8bb0\u5f55\u6210\u529f");
            map.put("result", oMetaViewData);
        }
        catch (Exception e) {
            logger.error((Object)"\u4fdd\u5b58\u8d44\u6e90\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            map.put("msg", e.getMessage());
            map.put("isSucc", Boolean.FALSE);
        }
        return map;
    }

    public Map<String, Object> queryMessages(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            int nReadFlag = _methodContext.getValue("ReadFlag", 1);
            String sMsgTypes = _methodContext.getValue("MsgTypes");
            int[] pMsgType = CMyString.splitToInt(sMsgTypes, ",");
            WCMFilter filter = new WCMFilter();
            StringBuffer sbSQL = new StringBuffer(128);
            sbSQL.append("lower(SendType) like '%message%'");
            if (pMsgType != null) {
                sbSQL.append(" and (");
                sbSQL.append("MsgType=?");
                filter.addSearchValues(0, pMsgType[0]);
                int len = pMsgType.length;
                for (int i = 1; i < len; ++i) {
                    sbSQL.append(" or ");
                    sbSQL.append("MsgType=?");
                    filter.addSearchValues(i, pMsgType[i]);
                }
                sbSQL.append(")");
            }
            filter.setWhere(sbSQL.toString());
            WCMFilter extraFilter = _methodContext.getExtraWCMFilter();
            if (extraFilter != null) {
                filter.mergeWith(extraFilter);
            }
            filter.mergeWith(_methodContext.getExtraWCMFilter());
            Messages messages = MessageServer.getMessages(nReadFlag, loginUser, filter);
            HashMap<String, Serializable> tmp = new HashMap<String, Serializable>();
            tmp.put("items", messages);
            tmp.put("pageIndex", new Integer(_methodContext.getPageIndex()));
            tmp.put("pageSize", new Integer(_methodContext.getPageSize()));
            tmp.put("totalCount", new Integer(messages.size()));
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u67e5\u8be2\u6d88\u606f\u6210\u529f");
            map.put("result", tmp);
        }
        catch (Exception e) {
            logger.error((Object)"\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> docPublish(MethodContext _methodContext) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ViewDocumentServiceProvider vsp = null;
        _methodContext.setReturnJSON(true);
        try {
            vsp = new ViewDocumentServiceProvider();
            Reports reports = vsp.publish(_methodContext);
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u53d1\u5e03\u6210\u529f");
            map.put("result", reports);
        }
        catch (Throwable e) {
            logger.error((Object)"\u53d1\u5e03\u5931\u8d25", e);
            map.put("msg", e.getMessage());
            map.put("isSucc", Boolean.FALSE);
        }
        return map;
    }

    public Map<String, Object> recallPublish(MethodContext _methodContext) throws Throwable {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ViewDocumentServiceProvider vsp = null;
        _methodContext.setReturnJSON(true);
        try {
            vsp = new ViewDocumentServiceProvider();
            vsp.publish(_methodContext);
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u64a4\u7a3f\u6210\u529f");
        }
        catch (Exception e) {
            logger.error((Object)"\u64a4\u7a3f\u5931\u8d25", (Throwable)e);
            map.put("msg", e.getMessage());
            map.put("isSucc", Boolean.FALSE);
        }
        return map;
    }

    public Map<String, Object> findMessagesByIds(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = this.getLoginUser();
            Messages msgs = MessageServer.findByIds(loginUser, _methodContext.getObjectIds());
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u8bfb\u53d6\u6d88\u606f\u6210\u529f");
            map.put("result", msgs);
        }
        catch (Exception e) {
            logger.error((Object)"\u8bfb\u53d6\u6d88\u606f\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> getMasAppKey(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            String appkey = VSConfig.getAppKey();
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u83b7\u53d6\u6210\u529f");
            map.put("result", appkey);
        }
        catch (Exception e) {
            logger.error((Object)"\u83b7\u53d6\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> getLoginUser(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        _methodContext.setReturnJSON(true);
        try {
            User loginUser = ContextHelper.getLoginUser();
            if (null == loginUser) {
                throw new RuntimeException("\u672a\u767b\u5f55");
            }
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u83b7\u53d6\u767b\u5f55\u7528\u6237\u6210\u529f");
            map.put("result", loginUser);
        }
        catch (Exception e) {
            logger.error((Object)"\u672a\u767b\u5f55", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    public Map<String, Object> upload(MethodContext _methodContext) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            HashMap temp = new HashMap();
            map.put("isSucc", Boolean.TRUE);
            map.put("msg", "\u4e0a\u4f20\u6210\u529f");
            map.put("result", temp);
        }
        catch (Exception e) {
            logger.error((Object)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            map.put("isSucc", Boolean.FALSE);
            map.put("msg", e.getMessage());
        }
        return map;
    }

    private boolean isForbidFileExt(String fileName) throws WCMException {
        String strExt = CMyFile.extractFileExt(fileName).toUpperCase();
        if (CMyString.isEmpty(strExt)) {
            return false;
        }
        String strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(strSuffixConfig)) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strAllowExt)) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + strExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + strExt + ",") > 0;
        }
        return true;
    }

    static {
        repositoryTypes.put(new Integer(1), "\u516c\u5171\u8d44\u6e90\u4e2d\u5fc3");
        repositoryTypes.put(new Integer(2), "\u516c\u5171\u8d44\u6e90\u76d1\u63a7");
        repositoryTypes.put(new Integer(3), "\u516c\u5171\u8d44\u6e90\u8fd0\u7ef4");
        repositoryTypes.put(new Integer(4), "\u7528\u6237\u7ba1\u7406");
        repositoryTypes.put(new Integer(5), "\u65e5\u5fd7\u7ba1\u7406");
        repositoryTypes.put(new Integer(6), "\u57fa\u7840\u8d44\u6e90\u5e93");
        repositoryTypes.put(new Integer(7), "\u590d\u5408\u8d44\u6e90\u5e93");
        repositoryTypes.put(new Integer(8), "\u6570\u636e\u7f13\u5b58\u5e93");
    }
}

