/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.components.gkml.sqgk.persistent.MailConfig;
import com.trs.components.gkml.sqgk.persistent.MailConfigs;
import com.trs.infra.common.WCMException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class MailConfigsHelper {
    private static Map configs = null;

    public static void loadConfigs() throws WCMException {
        configs = new HashMap();
        MailConfigs oMailConfigs = MailConfigs.openWCMObjs(null, null);
        int nSize = oMailConfigs.size();
        for (int i = 0; i < nSize; ++i) {
            MailConfig config = (MailConfig)oMailConfigs.getAt(i);
            if (config == null) continue;
            String sParamName = (String)config.getProperty("paramName");
            String sParamValue = (String)config.getProperty("paramValue");
            configs.put(sParamName.toUpperCase(), sParamValue);
        }
        MailConfigsHelper.loadMailTemplates();
    }

    private static void loadMailTemplates() {
        String[][] templateInfos = new String[][]{{"SUBMITMAILBODY", "/mailTemplateOfSQGK/submit.html"}, {"RESULTMAILBODY", "/mailTemplateOfSQGK/result.html"}};
        for (int i = 0; i < templateInfos.length; ++i) {
            MailConfigsHelper.loadMailTemplate(templateInfos[i]);
        }
    }

    private static void loadMailTemplate(String[] _aTemplateInfos) {
        URL url = MailConfigsHelper.class.getResource(_aTemplateInfos[1]);
        if (url == null) {
            return;
        }
        BufferedReader buffReader = null;
        int length = 0;
        char[] buffer = new char[1024];
        StringBuffer buffContent = new StringBuffer();
        try {
            buffReader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            while ((length = buffReader.read(buffer, 0, buffer.length)) > 0) {
                buffContent.append(buffer, 0, length);
            }
            configs.put(_aTemplateInfos[0], buffContent.toString());
        }
        catch (Exception e) {
            configs.put(_aTemplateInfos[0], "");
            e.printStackTrace();
        }
    }

    public static String getConfig(String sConfigName) throws WCMException {
        if (configs == null) {
            MailConfigsHelper.loadConfigs();
        }
        sConfigName = sConfigName.toUpperCase();
        return (String)configs.get(sConfigName);
    }

    public static Map getConfigs() throws WCMException {
        if (configs == null) {
            MailConfigsHelper.loadConfigs();
        }
        return configs;
    }
}

