/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;

public class ClassInfoToGroupCreator {
    public static final String ROLENAME_SFX_MGR = I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label1", "_\u4fe1\u606f\u7ba1\u7406\u4eba\u5458");
    private static IClassInfoMgr m_oClassInfoMgr;
    private static GroupMgr m_oGroupMgr;
    private static StringBuffer m_sbNewUserInfos;

    public ClassInfoToGroupCreator() {
        m_sbNewUserInfos = new StringBuffer();
    }

    public String getNewUserInfos() {
        return m_sbNewUserInfos.toString();
    }

    public void createGroups(ClassInfo _oDeptClassInfoRoot, Group _hostGroup, int _nMaxLevel) throws WCMException {
        if (_oDeptClassInfoRoot == null || _hostGroup == null) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        IClassInfoMgr oClassInfoMgr = this.getClassInfoMgr();
        ClassInfos oChildren = oClassInfoMgr.queryChildren(currUser, _oDeptClassInfoRoot, null);
        int nSize = oChildren.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo child = (ClassInfo)oChildren.getAt(i);
            if (child == null) continue;
            this.createGroups(child, _hostGroup, 1, _nMaxLevel);
        }
    }

    private void createGroups(ClassInfo _oClassInfo, Group _hostGroup, int _nLevel, int _nMaxLevel) throws WCMException {
        if (_oClassInfo == null || _hostGroup == null) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        Group currGroup = this.createGroup(_hostGroup, _oClassInfo.getName(), currUser);
        this.createUser(currUser, _oClassInfo.getName(), currGroup);
        User newUser = this.createUser(currUser, _oClassInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label2", "_\u8d1f\u8d23\u4eba"), currGroup);
        GroupMgr groupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        newUser.setStatus(30);
        newUser.save();
        groupMgr.setGroupManager(newUser, currGroup, true);
        newUser.setStatus(20);
        newUser.save();
        if (_nLevel > 1) {
            this.createUser(currUser, _oClassInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label3", "_\u5ba1\u67e5\u5458"), currGroup);
            this.createUser(currUser, _oClassInfo.getName() + I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label4", "_\u5904\u7406\u5458"), currGroup);
        }
        this.createMgrRoleOnGroup(currGroup);
        if (_nMaxLevel != 0 && _nLevel + 1 > _nMaxLevel) {
            return;
        }
        IClassInfoMgr oClassInfoMgr = this.getClassInfoMgr();
        ClassInfos oChildren = oClassInfoMgr.queryChildren(currUser, _oClassInfo, null);
        int nSize = oChildren.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo oClassInfo = (ClassInfo)oChildren.getAt(i);
            if (oClassInfo == null) continue;
            this.createGroups(oClassInfo, currGroup, _nLevel + 1, _nMaxLevel);
        }
    }

    private void createMgrRoleOnGroup(Group _currGroup) throws WCMException {
        Group parentGroup;
        String sRoleName = _currGroup.getName() + "_" + ROLENAME_SFX_MGR;
        for (parentGroup = _currGroup.getParent(); parentGroup != null && parentGroup.getParentId() > 0; parentGroup = parentGroup.getParent()) {
            sRoleName = parentGroup.getName() + "_" + sRoleName;
        }
        RoleMgr roleMgr = (RoleMgr)DreamFactory.createObjectById("RoleMgr");
        Role role = new Role();
        role.setName(sRoleName);
        role.setRoleRange(1);
        role.setAttribute("govinfo", "1");
        roleMgr.save(role);
        for (parentGroup = _currGroup.getParent(); parentGroup != null && parentGroup.getParentId() > 0; parentGroup = parentGroup.getParent()) {
            Users parentUsers = parentGroup.getUsers(null);
            int nSize = parentUsers.size();
            for (int i = 0; i < nSize; ++i) {
                User parentUser = (User)parentUsers.getAt(i);
                if (parentUser == null) continue;
                roleMgr.addUser(role, -1, parentUser);
            }
        }
    }

    private Group getRootGroup(Group _group) throws WCMException {
        Group parent = null;
        while (_group != null) {
            parent = _group.getParent();
            if (parent == null) {
                return _group;
            }
            if (I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label5", "\u7ec4\u7ec7\u673a\u6784").equals(parent.getName())) {
                return _group;
            }
            _group = parent;
        }
        return _group;
    }

    private User createUser(User _oCrUser, String _sUserName, Group _group) throws WCMException {
        Group root = this.getRootGroup(_group);
        User oUser = User.findByName(_sUserName);
        if (oUser != null) {
            _sUserName = root.getName() + "_" + _sUserName;
            oUser = User.findByName(_sUserName);
        }
        if (oUser == null) {
            oUser = User.createNewInstance();
            oUser.setName(_sUserName);
            String sRandomPassword = String.valueOf(Math.random()).substring(3, 11);
            oUser.setPassword(sRandomPassword);
            oUser.setNickName(_sUserName);
            oUser.setStatus(20);
            oUser.setAttribute("govinfo", "1");
            oUser.save(_oCrUser);
            m_sbNewUserInfos.append(I18NMessage.get(ClassInfoToGroupCreator.class, "ClassInfoToGroupCreator.label6", "\u7528\u6237\u540d/\u5bc6\u7801\uff1a") + _sUserName + "/" + sRandomPassword);
            m_sbNewUserInfos.append('\n');
        } else if (_group != null && oUser.getGroups().indexOf(_group) >= 0) {
            return oUser;
        }
        if (_group != null) {
            this.getGroupMgr().addUser(oUser, _group);
        }
        return oUser;
    }

    private Group createGroup(Group _oParentGroup, String _sGroupName, User _oCrUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ParentId=? and GName=?", "");
        filter.addSearchValues(_oParentGroup.getId());
        filter.addSearchValues(_sGroupName);
        filter.setMaxRowNumber(1);
        Groups groups = Groups.openWCMObjs(null, filter);
        if (!groups.isEmpty()) {
            return (Group)groups.getAt(0);
        }
        Group currGroup = Group.createNewInstance();
        currGroup.setParent(_oParentGroup == null ? 0 : _oParentGroup.getId());
        currGroup.setName(_sGroupName);
        currGroup.setDesc(_sGroupName);
        currGroup.setCrUser(_oCrUser);
        currGroup.setAttribute("govinfo", "1");
        currGroup.save(_oCrUser);
        return currGroup;
    }

    private IClassInfoMgr getClassInfoMgr() {
        if (m_oClassInfoMgr == null) {
            m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
        }
        return m_oClassInfoMgr;
    }

    private GroupMgr getGroupMgr() {
        if (m_oGroupMgr == null) {
            m_oGroupMgr = (GroupMgr)DreamFactory.createObjectById("GroupMgr");
        }
        return m_oGroupMgr;
    }

    static {
        m_sbNewUserInfos = null;
    }
}

