/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.cms.content.CMSBaseObjs;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.BaseTagParser;
import com.trs.components.common.publish.domain.tagparser.ITagParser4List;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.publish.PublishFolderClassImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.html.HtmlUtil;

public class WCMTagParserClassInfos
extends BaseTagParser
implements ITagParser4List {
    private ClassInfo m_oCurrClassInfo = null;
    protected IPublishFolder m_oCurrFolder;
    private IPublishElements m_oPublishClassElements;
    private int m_nCurrPos = 0;
    protected int m_nCurrNumber = 1;
    private PublishTagContext m_nextRecordContext = null;
    private IPublishFolder m_oRoot = null;
    private IPublishElement m_oUpperHost = null;

    protected CMSBaseObjs findObjects(PublishTagContext _context) throws WCMException {
        this.makeCurrClassInfo(_context);
        boolean bReturnBottomClassInfos = _context.getAttribute("ReturnBottom", false);
        ClassInfos children = null;
        String bParent = _context.getAttribute("parent");
        if (!CMyString.isEmpty(bParent) && bParent.equalsIgnoreCase("true")) {
            this.m_oCurrClassInfo = this.m_oCurrClassInfo.getParent();
        }
        children = this.m_oCurrClassInfo != null ? this.m_oCurrClassInfo.getChildren(true) : ClassInfo.findRootClassInfos(true);
        if (!bReturnBottomClassInfos) {
            return children;
        }
        ClassInfos resultClassInfos = new ClassInfos(null);
        this.findBottomClassInfo(children, resultClassInfos);
        return resultClassInfos;
    }

    private void findBottomClassInfo(ClassInfos _children, ClassInfos _resultClassInfos) throws WCMException {
        int nSize = _children.size();
        for (int i = 0; i < nSize; ++i) {
            ClassInfo classInfo = (ClassInfo)_children.getAt(i);
            if (classInfo == null) continue;
            ClassInfos childrenTemp = classInfo.getChildren(true);
            if (childrenTemp == null || childrenTemp.isEmpty()) {
                _resultClassInfos.addElement(classInfo);
                continue;
            }
            this.findBottomClassInfo(childrenTemp, _resultClassInfos);
        }
    }

    protected boolean isValidate(PublishTagContext _context) throws WCMException {
        this.makeCurrClassInfo(_context);
        return true;
    }

    private void makeCurrClassInfo(PublishTagContext _context) throws WCMException {
        if (this.m_oCurrClassInfo != null) {
            return;
        }
        String sId = _context.getAttribute("Id");
        if (sId != null && (sId = sId.trim()).length() > 0) {
            int nId = -1;
            try {
                nId = Integer.parseInt(sId);
                this.m_oCurrClassInfo = ClassInfo.findById(nId);
                if (this.m_oCurrClassInfo == null) {
                    throw new WCMException(I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label1", "\u6307\u5b9a\u7684ClassInfo\u4e0d\u5b58\u5728\uff01[ID=") + nId + "]");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (nId == -1) {
                WCMFilter filter = new WCMFilter("", "CName=?", "");
                filter.addSearchValues(sId);
                ClassInfos classInfos = ClassInfos.openWCMObjs(null, filter);
                if (classInfos.isEmpty()) {
                    throw new WCMException(I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label2", "\u6307\u5b9a\u7684ClassInfo\u4e0d\u5b58\u5728\uff01[Name=") + sId + "]");
                }
                this.m_oCurrClassInfo = ClassInfo.findByName(sId);
            }
            return;
        }
        String sClassName = _context.getAttribute("ClassInfoName");
        if (!CMyString.isEmpty(sClassName)) {
            this.m_oCurrClassInfo = ClassInfo.findByName(sClassName);
            return;
        }
        if (_context.getUpperHost().getSubstance() instanceof ClassInfo) {
            this.m_oCurrClassInfo = (ClassInfo)_context.getUpperHost().getSubstance();
        }
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        String sAutoMore;
        if (!_context.getTagItem().hasChildren()) {
            return null;
        }
        if (!this.isValidate(_context)) {
            return null;
        }
        this.m_oRoot = _context.getRoot();
        this.m_oUpperHost = _context.getUpperHost();
        if (this.m_oUpperHost instanceof PublishFolderClassImpl) {
            this.m_oUpperHost = ((PublishFolderClassImpl)this.m_oUpperHost).getHost();
        }
        CMSBaseObjs oClassInfos = this.findObjects(_context);
        this.m_oPublishClassElements = PublishElementFactory.makeElementsFrom(oClassInfos);
        this.m_nextRecordContext = new PublishTagContext(_context, _context.getTagItem(), this);
        String[] results = TagParseHelper.parse4List(_context.getTagItem(), _context, this);
        if (results != null && results.length == 1 && _context.getAttribute("AUTOMORE", false) && (sAutoMore = this.parseAutoMore(this.m_oCurrFolder, _context)) != null) {
            results[0] = results[0] + sAutoMore;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseAutoMore(IPublishFolder _currFolder, PublishTagContext _context) throws WCMException {
        String sBegin = _context.getAttribute("BEGINMORE");
        String sEnd = _context.getAttribute("ENDMORE");
        String sText = _context.getAttribute("MORETEXT");
        String sTarget = _context.getAttribute("MORETARGET");
        String sExtra = _context.getAttribute("MOREEXTRA");
        if (sText == null || (sText = sText.trim()).length() == 0) {
            sText = I18NMessage.get(WCMTagParserClassInfos.class, "WCMTagParserClassInfos.label3", "\u66f4\u591a\u5185\u5bb9...");
        }
        if (sTarget == null || (sTarget = sTarget.trim()).length() == 0) {
            sTarget = "_blank";
        }
        StringBuffer buff = new StringBuffer();
        try {
            String sUrl = _context.getPathCompass().getAbsoluteHttpPath(_currFolder);
            sUrl = HtmlUtil.calRelativePath(sUrl, _context.getPageHttpPath());
            if (sBegin != null && sBegin.length() > 0) {
                buff.append(sBegin);
            }
            buff.append("<A href=\"").append(sUrl);
            buff.append("\" target=\"").append(sTarget).append("\" ");
            if (sExtra != null) {
                buff.append(sExtra);
            }
            buff.append('>').append(sText).append("</A>");
            if (sEnd != null && sEnd.length() > 0) {
                buff.append(sEnd);
            }
            String string = buff.toString();
            return string;
        }
        finally {
            buff.setLength(0);
        }
    }

    @Override
    public int getRecordSize() {
        return this.getObjectsSize();
    }

    private int getObjectsSize() {
        return this.m_oPublishClassElements.size();
    }

    @Override
    public void setStartPos(int _nPos) {
        this.m_nCurrPos = _nPos;
    }

    @Override
    public PublishTagContext getNextRecordContext() throws WCMException {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        try {
            PublishFolderClassImpl element = (PublishFolderClassImpl)this.m_oPublishClassElements.get(this.m_nCurrPos++);
            if (element == null) {
                return this.getNextRecordContext();
            }
            element.setRoot(this.m_oRoot);
            element.setHost(this.m_oUpperHost);
            this.m_nextRecordContext.setSequenceNumber(this.m_nCurrNumber++);
            this.m_nextRecordContext.setUpperHost(element);
            return this.m_nextRecordContext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }

    @Override
    public PublishTagContext getDelegatedContext() {
        if (this.m_nCurrPos >= this.getRecordSize()) {
            return null;
        }
        this.m_nextRecordContext.setUpperHost(null);
        return this.m_nextRecordContext;
    }

    @Override
    public PublishTagContext substantiateContext(PublishTagContext _tagConext) throws WCMException {
        try {
            PublishFolderClassImpl element = (PublishFolderClassImpl)this.m_oPublishClassElements.get(this.m_nCurrPos++);
            if (element == null) {
                return this.substantiateContext(_tagConext);
            }
            element.setRoot(this.m_oRoot);
            element.setHost(this.m_oUpperHost);
            _tagConext.setSequenceNumber(this.m_nCurrNumber++);
            _tagConext.setUpperHost(element);
            return _tagConext;
        }
        catch (Exception ex) {
            throw new WCMException(220, "Failed to get the tag context of next record at " + this.m_nCurrPos, ex);
        }
    }
}

