/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.publish.NewRuleOfDetailPageHelper;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyString;
import java.util.HashMap;

public class MetaDataLCListnerForSynPageName
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static final String sUpdateSQL = "update WCMDOCUMENT  set PublishFileName=? where DOCID=?";

    private static String getURLFieldDBName(int _nViewId) throws WCMException {
        IMetaDataDefCacheMgr oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        HashMap hFields = oDataDefCacheMgr.getMetaViewFields(_nViewId);
        for (MetaViewField field : hFields.values()) {
            if (field == null || !field.getPropertyAsBoolean("IsURLField", false)) continue;
            return field.getDBName();
        }
        return null;
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        this.synPageNameField(_oObjModified, false);
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        this.synPageNameField(_oObjAdded, true);
    }

    private void synPageNameField(BaseObj _oMetaData, boolean _bIsAddMode) throws WCMException {
        int nChannelId;
        Channel channel;
        if (!(_oMetaData instanceof CMSObjDefaultImpl)) {
            return;
        }
        CMSObjDefaultImpl oCurrObj = (CMSObjDefaultImpl)_oMetaData;
        int nViewId = oCurrObj.getViewId();
        if (nViewId <= 0) {
            return;
        }
        String sURLFieldDBName = MetaDataLCListnerForSynPageName.getURLFieldDBName(nViewId);
        if (CMyString.isEmpty(sURLFieldDBName)) {
            return;
        }
        String sPageName = null;
        if (_bIsAddMode) {
            sPageName = _oMetaData.getPropertyAsString(sURLFieldDBName);
            if (CMyString.isEmpty(sPageName)) {
                return;
            }
        } else {
            if (!_oMetaData.isChangeProperty(sURLFieldDBName)) {
                return;
            }
            sPageName = _oMetaData.getFinalPropertyAsString(sURLFieldDBName);
        }
        if ((channel = Channel.findById(nChannelId = _oMetaData.getPropertyAsInt("ChannelId", 0))) == null) {
            return;
        }
        if (!NewRuleOfDetailPageHelper.enableNewRule(channel.getSiteId())) {
            return;
        }
        Object[] pUpdateParameters = new Object[]{sPageName, _oMetaData.getProperty("MetaDataId")};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{sUpdateSQL}, pUpdateParameters);
    }
}

