/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.publish;

import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.publish.IClassInfoCountCacheForPublish;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ClassInfoCountCacheForPublishImpl
implements IClassInfoCountCacheForPublish {
    private static final Logger LOG = Logger.getLogger(ClassInfoCountCacheForPublishImpl.class);
    private Hashtable m_hSitesCountCache = new Hashtable();
    private Hashtable m_hChannelsCountCache = new Hashtable();

    @Override
    public int getClassInfoDataCountOfChannel(int _nChannelId, int _nClassInfoId) throws WCMException {
        Integer iCount;
        ClassInfo classInfo = ClassInfo.findById(_nClassInfoId);
        if (classInfo == null) {
            return 0;
        }
        int nRootClassInfoId = classInfo.getRootId();
        String sKey = _nChannelId + "_" + nRootClassInfoId;
        Hashtable hChannelDataCache = (Hashtable)this.m_hChannelsCountCache.get(sKey);
        if (hChannelDataCache == null) {
            hChannelDataCache = this.initChannelsDataCountCache(_nChannelId, nRootClassInfoId);
        }
        if ((iCount = (Integer)hChannelDataCache.get(new Integer(_nClassInfoId))) == null) {
            return 0;
        }
        return iCount;
    }

    @Override
    public int getClassInfoDataCountOfSite(int _nSiteId, int _nClassInfoId) throws WCMException {
        return this.getClassInfoDataCountOfSite(_nSiteId, _nClassInfoId, 0);
    }

    @Override
    public int getClassInfoDataCountOfSite(int _nSiteId, int _nClassInfoId, int _nChannelId) throws WCMException {
        Integer iCount;
        ClassInfo classInfo = ClassInfo.findById(_nClassInfoId);
        if (classInfo == null) {
            return 0;
        }
        int nRootClassInfoId = classInfo.getRootId();
        String sKey = _nSiteId + "_" + nRootClassInfoId;
        Hashtable hSiteDataCache = (Hashtable)this.m_hSitesCountCache.get(sKey);
        if (hSiteDataCache == null) {
            hSiteDataCache = this.initSitesDataCountCache(_nSiteId, nRootClassInfoId, _nChannelId);
        }
        if ((iCount = (Integer)hSiteDataCache.get(new Integer(_nClassInfoId))) == null) {
            return 0;
        }
        return iCount;
    }

    private synchronized Hashtable initSitesDataCountCache(int nSiteId, int _nRootId, int _nChannelId) throws WCMException {
        String sKey = nSiteId + "_" + _nRootId;
        Hashtable hSiteDataCache = (Hashtable)this.m_hSitesCountCache.get(sKey);
        if (hSiteDataCache != null) {
            return hSiteDataCache;
        }
        String sQuerySQL = "select count(distinct MetaDataId) datacount,ClassInfoId from XWCMClassInfoView where exists(select 1 from WCMChnlDoc where WCMChnlDoc.DocStatus=10 and Modal>0 and DocChannel>0 and exists(select 1 from WCMChannel where WCMChannel.SiteId=? and WCMChannel.ChannelId=WCMChnlDoc.ChnlId" + (_nChannelId == 0 ? "" : " and WCMChnlDoc.ChnlId=?") + " ) and WCMChnlDoc.DocId=XWCMClassInfoView.MetaDataId) and exists(select 1 from XWCMClassInfo where XWCMClassInfo.RootId=? and XWCMClassInfo.ClassInfoId=XWCMClassInfoView.ClassInfoId) group by ClassInfoId";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("init sitedata count cache: sql=" + sQuerySQL));
            LOG.debug((Object)("params: siteid=" + nSiteId + ", root=" + _nRootId));
        }
        Hashtable cachedData = this.queryData(nSiteId, _nRootId, _nChannelId, sQuerySQL);
        this.m_hSitesCountCache.put(sKey, cachedData);
        return cachedData;
    }

    private synchronized Hashtable initChannelsDataCountCache(int _nChannelId, int _nRootClassId) throws WCMException {
        String sKey = _nChannelId + "_" + _nRootClassId;
        Hashtable hChannelDataCache = (Hashtable)this.m_hChannelsCountCache.get(sKey);
        if (hChannelDataCache != null) {
            return hChannelDataCache;
        }
        String sQuerySQL = "select count(distinct MetaDataId) datacount,ClassInfoId from XWCMClassInfoView where exists(select 1 from WCMChnlDoc where WCMChnlDoc.DocStatus=10 and Modal>0 and DocChannel>0 and ChnlId=? and WCMChnlDoc.DocId=XWCMClassInfoView.MetaDataId) and exists(select 1 from XWCMClassInfo where XWCMClassInfo.RootId=? and XWCMClassInfo.ClassInfoId=XWCMClassInfoView.ClassInfoId) group by ClassInfoId";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("init channel count cache: sql=" + sQuerySQL));
            LOG.debug((Object)("params: channel=" + _nChannelId + ", root=" + _nRootClassId));
        }
        Hashtable cachedData = this.queryData(_nChannelId, _nRootClassId, 0, sQuerySQL);
        this.m_hChannelsCountCache.put(sKey, cachedData);
        return cachedData;
    }

    protected Hashtable queryData(int _nObjId, int _nRootId, int _nChannelId, String _sql) throws WCMException {
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        String strSQL = _sql;
        Hashtable cache = new Hashtable();
        DBManager dbMgr = DBManager.getDBManager();
        try {
            oConn = dbMgr.getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setInt(1, _nObjId);
            if (_nChannelId != 0) {
                oStmt.setInt(2, _nChannelId);
                oStmt.setInt(3, _nRootId);
            } else {
                oStmt.setInt(2, _nRootId);
            }
            oStmt.setFetchSize(500);
            rsData = oStmt.executeQuery();
            boolean bOnlyLeaf = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("CLASS_DOCUMENTS_ONLY_LEAF", "true"));
            while (rsData.next()) {
                int nDataCount = rsData.getInt(1);
                int nClassInfoId = rsData.getInt(2);
                ClassInfo classInfo = ClassInfo.findById(nClassInfoId);
                if (!classInfo.isLeaf() && bOnlyLeaf) continue;
                this.putInDataDataCache(cache, nClassInfoId, nDataCount);
                for (ClassInfo parent = classInfo.getParent(); parent != null; parent = parent.getParent()) {
                    this.putInDataDataCache(cache, parent.getId(), nDataCount);
                }
            }
        }
        catch (SQLException ex) {
            throw new WCMException(I18NMessage.get(ClassInfoCountCacheForPublishImpl.class, "ClassInfoCountCacheForPublishImpl.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(I18NMessage.get(ClassInfoCountCacheForPublishImpl.class, "ClassInfoCountCacheForPublishImpl.label1", "\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1aSQL=") + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                dbMgr.freeConnection(oConn);
            }
        }
        return cache;
    }

    private void putInDataDataCache(Hashtable _hDataCountCache, int _nClassInfoId, int _nDataCount) {
        Integer iClassInfoKey = new Integer(_nClassInfoId);
        Integer iDataCount = (Integer)_hDataCountCache.get(iClassInfoKey);
        if (iDataCount != null) {
            _nDataCount += iDataCount.intValue();
        }
        _hDataCountCache.put(iClassInfoKey, new Integer(_nDataCount));
    }
}

