/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.xml;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaDataDefMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.xml.XMLToMetaDBTablesConvertor;
import com.trs.components.metadata.service.MetaDataDefServiceProvider;
import com.trs.components.wcm.util.INameGenerator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MetaDataDDLImporter {
    private User m_oCurrUser = null;
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private HashMap m_hCurrDBFields = new HashMap();
    private MetaViews m_oMetaViews = MetaViews.createNewInstance(null);
    private HashMap m_hCurrMetaViewFieldGroup = new HashMap();
    private XMLToMetaDBTablesConvertor m_convertor = null;

    public MetaDataDDLImporter(User _currUser) {
        this.m_oCurrUser = _currUser;
    }

    private void processMetaDB(XmlObject _oXmlObject) throws WCMException {
        MetaDBTable metaDBTable = this.processMetaDBTable(_oXmlObject);
        XmlObject[] pDBFieldXMLObjects = _oXmlObject.getChild("XWCMDBFIELDINFOS");
        for (int j = 0; j < pDBFieldXMLObjects.length; ++j) {
            MetaDBField metaDBField = this.processDBField(metaDBTable, pDBFieldXMLObjects[j]);
            this.m_hCurrDBFields.put(metaDBField.getName().trim().toUpperCase(), metaDBField);
        }
    }

    private void processRSMetaDB(XmlObject _oXmlObject, int _nImportType, Reports _oReports) throws WCMException {
        MetaDBTable metaDBTable = this.processRSMetaDBTable(_oXmlObject, _nImportType, _oReports);
        XmlObject[] pDBFieldXMLObjects = _oXmlObject.getChild("XWCMDBFIELDINFOS");
        for (int j = 0; j < pDBFieldXMLObjects.length; ++j) {
            MetaDBField metaDBField = this.processDBField(metaDBTable, pDBFieldXMLObjects[j]);
            this.m_hCurrDBFields.put(metaDBField.getName().trim().toUpperCase(), metaDBField);
        }
    }

    private MetaDBTable processRSMetaDBTable(XmlObject _oXmlObject, int _nImportType, Reports _oReports) throws WCMException {
        MetaDBTable metaDBTable = (MetaDBTable)_oXmlObject.getCurrentObj();
        if (metaDBTable == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u89c6\u56fe\u6587\u4ef6."));
        }
        metaDBTable.removeProperty("TABLEINFOID");
        metaDBTable.removeProperty("CRUSER");
        metaDBTable.removeProperty("CRTIME");
        metaDBTable.removeProperty("OWNERTYPE");
        metaDBTable.removeProperty("OWNERID");
        String sTableName = metaDBTable.getName();
        MetaDBTable dbTableTemp = this.findMetaDBTableByName(sTableName);
        if (dbTableTemp == null) {
            metaDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable);
        } else {
            if (_nImportType == 0) {
                throw new WCMException(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label18", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u5143\u6570\u636e."));
            }
            if (_nImportType == 1) {
                try {
                    dbTableTemp.setProperty("CRUSER", this.m_oCurrUser.getName());
                    dbTableTemp.setProperty("CRTIME", CMyDateTime.now());
                    dbTableTemp.save(this.m_oCurrUser);
                    metaDBTable = dbTableTemp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
                String sNewName = m_oNameGenerator.generate(metaDBTable, "TABLENAME", metaDBTable.getName());
                metaDBTable.setName(sNewName);
                metaDBTable = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable);
            }
            metaDBTable = dbTableTemp;
        }
        return metaDBTable;
    }

    private String processMetaView(XmlObject _oXmlObject, int _nImportType, Reports _oReports) throws WCMException {
        XmlObject[] pMetaViewXMLObjects = _oXmlObject.getChild("XWCMVIEWINFOS");
        MetaDBTable metaDBTable = this.processMetaDBTable(_oXmlObject);
        String sResultIds = "";
        for (int j = 0; j < pMetaViewXMLObjects.length; ++j) {
            boolean bFailed = false;
            try {
                MetaView currMetaView = this.processView(metaDBTable, pMetaViewXMLObjects[j], _nImportType);
                if (currMetaView != null) {
                    sResultIds = CMyString.isEmpty(sResultIds) ? currMetaView.getId() + "" : sResultIds + "," + currMetaView.getId();
                }
            }
            catch (WCMException ex) {
                bFailed = true;
                if (ex.getErrNo() == 0) {
                    _oReports.addWarnedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label15", "\u5904\u7406\u89c6\u56fe\u5931\u8d25\uff01"), ex);
                }
                _oReports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label15", "\u5904\u7406\u89c6\u56fe\u5931\u8d25\uff01"), ex);
            }
            if (bFailed) continue;
            _oReports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDDLImporter.label17", "\u89c6\u56fe\u5bfc\u5165\u6210\u529f\uff01"));
        }
        return sResultIds;
    }

    public void importRSFromXML(String _sXMLFile, int _nImportType, Reports _oReports) throws WCMException {
        String sImportFile = _sXMLFile;
        if (!CMyFile.fileExists(sImportFile)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sImportFile = filesMan.mapFilePath(_sXMLFile, 0) + _sXMLFile;
        }
        if (!CMyFile.fileExists(sImportFile)) {
            _oReports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label14", "\u5b9a\u4e49\u5143\u6570\u636e\u7ed3\u6784\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + _sXMLFile + "][" + sImportFile + "]", null);
        }
        XMLToMetaDBTablesConvertor convertor = new XMLToMetaDBTablesConvertor(1);
        XmlObject[] pXmlObjects = convertor.convertXml(sImportFile, null, null);
        for (int i = 0; i < pXmlObjects.length; ++i) {
            XmlObject oXmlObject = pXmlObjects[i];
            this.processRSMetaDB(oXmlObject, _nImportType, _oReports);
            String sResultIds = this.processMetaView(oXmlObject, _nImportType, _oReports);
            String[] sResult = sResultIds.split(",");
            int[] nResult = new int[sResult.length];
            for (int j = 0; j < sResult.length; ++j) {
                if (CMyString.isEmpty(sResult[j])) {
                    sResult[j] = "0";
                }
                nResult[j] = Integer.parseInt(sResult[j]);
            }
            _oReports.setResultIds(nResult);
            this.m_hCurrDBFields.clear();
        }
    }

    public void importFromXML(String _sXMLFile, int _nImportType, Reports _oReports) throws WCMException {
        String sImportFile = _sXMLFile;
        if (!CMyFile.fileExists(sImportFile)) {
            FilesMan filesMan = FilesMan.getFilesMan();
            sImportFile = filesMan.mapFilePath(_sXMLFile, 0) + _sXMLFile;
        }
        if (!CMyFile.fileExists(sImportFile)) {
            _oReports.addFailedReport(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label14", "\u5b9a\u4e49\u5143\u6570\u636e\u7ed3\u6784\u7684XML\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[") + _sXMLFile + "][" + sImportFile + "]", null);
        }
        XMLToMetaDBTablesConvertor convertor = new XMLToMetaDBTablesConvertor(1);
        XmlObject[] pXmlObjects = convertor.convertXml(sImportFile, null, null);
        this.m_convertor = convertor;
        for (int i = 0; i < pXmlObjects.length; ++i) {
            XmlObject oXmlObject = pXmlObjects[i];
            this.processMetaDB(oXmlObject);
            String sResultIds = this.processMetaView(oXmlObject, _nImportType, _oReports);
            String[] sResult = sResultIds.split(",");
            int[] nResult = new int[sResult.length];
            for (int j = 0; j < sResult.length; ++j) {
                if (CMyString.isEmpty(sResult[j])) {
                    sResult[j] = "0";
                }
                nResult[j] = Integer.parseInt(sResult[j]);
            }
            _oReports.setResultIds(nResult);
            this.m_hCurrDBFields.clear();
        }
    }

    private MetaView processView(MetaDBTable _dbTable, XmlObject _oXmlObject, int _nImportType) throws WCMException {
        MetaView currView = (MetaView)_oXmlObject.getCurrentObj();
        currView.removeProperty("VIEWINFOID");
        currView.removeProperty("MainTableId");
        currView.removeProperty("CRUSER");
        currView.removeProperty("CRTIME");
        currView.removeProperty("OWNERTYPE");
        currView.removeProperty("OWNERID");
        MetaView oViewTemp = this.findViewByName(currView.getMainTableName(), currView.getName());
        if (oViewTemp == null) {
            currView.setMainTable(_dbTable);
            currView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, currView);
        } else {
            if (_nImportType == 0) {
                throw new WCMException(0, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDDLImporter.label16", "\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u82f1\u6587\u540d\u79f0\u7684\u89c6\u56fe."));
            }
            if (_nImportType == 1) {
                try {
                    oViewTemp.setProperty("CRUSER", this.m_oCurrUser.getName());
                    oViewTemp.setProperty("CRTIME", CMyDateTime.now());
                    oViewTemp.save(this.m_oCurrUser);
                    currView = oViewTemp;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                INameGenerator m_oNameGenerator = (INameGenerator)DreamFactory.createObjectById("INameGenerator");
                String sNewName = m_oNameGenerator.generate(currView, "VIEWNAME", currView.getName());
                String sNewShowName = m_oNameGenerator.generate(currView, "VIEWDESC", currView.getDesc());
                currView.setName(sNewName);
                currView.setDesc(sNewShowName);
                currView.setMainTable(_dbTable);
                currView = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, currView);
            }
        }
        this.m_oMetaViews.addElement(currView);
        XmlObject[] pViewGroupXMLObjects = _oXmlObject.getChild("XWCMMETAVIEWFIELDGROUPS");
        for (int j = 0; j < pViewGroupXMLObjects.length; ++j) {
            this.processMetaGroup(currView, pViewGroupXMLObjects[j]);
        }
        XmlObject[] pViewFieldXMLObjects = _oXmlObject.getChild("XWCMVIEWFIELDINFOS");
        for (int j = 0; j < pViewFieldXMLObjects.length; ++j) {
            this.processViewField(currView, pViewFieldXMLObjects[j]);
        }
        this.m_oMetaDataDefMgr.createViewApplication(currView);
        return currView;
    }

    private void processViewField(MetaView _view, XmlObject _oFieldXmlObject) throws WCMException {
        MetaViewField viewField = (MetaViewField)_oFieldXmlObject.getCurrentObj();
        viewField.removeProperty("VIEWFIELDINFOID");
        viewField.removeProperty("CRUSER");
        viewField.removeProperty("CRTIME");
        viewField.removeProperty("TABLEID");
        viewField.removeProperty("ViewId");
        viewField.removeProperty("DBFIELD");
        int nCurrFieldGroupId = viewField.getPropertyAsInt("FIELDGROUPID", 0);
        viewField.removeProperty("FIELDGROUPID");
        viewField.setProperty("FIELDGROUPID", this.m_hCurrMetaViewFieldGroup.get(nCurrFieldGroupId));
        String sFieldName = viewField.getName();
        MetaViewField viewFieldTemp = this.findMetaViewFieldByName(_view.getId(), sFieldName);
        if (viewFieldTemp == null) {
            MetaDBField dbField = (MetaDBField)this.m_hCurrDBFields.get(viewField.getDBName().trim().toUpperCase());
            if (dbField == null) {
                throw new WCMException(I18NMessage.get(MetaDataDDLImporter.class, "MetaDataDDLImporter.label19", "\u6307\u5b9a\u7684\u7269\u7406\u5b57\u6bb5\u4e0d\u5b58\u5728\uff01[") + viewField.getDBName() + "]");
            }
            viewField.setDBField(dbField.getId());
            viewField.setTableId(dbField.getTableId());
            viewField = this.m_oMetaDataDefMgr.save(this.m_oCurrUser, _view, viewField);
        } else {
            viewField = viewFieldTemp;
        }
    }

    private MetaDBField processDBField(MetaDBTable _metaDBTable, XmlObject _oFieldXmlObject) throws WCMException {
        MetaDBField metaDBField = (MetaDBField)_oFieldXmlObject.getCurrentObj();
        metaDBField.removeProperty("DBFIELDINFOID");
        metaDBField.removeProperty("CRUSER");
        metaDBField.removeProperty("CRTIME");
        metaDBField.removeProperty("TABLEID");
        String sFieldName = metaDBField.getName();
        MetaDBField dbFieldTemp = this.findMetaDBFieldByName(_metaDBTable.getId(), sFieldName);
        if (dbFieldTemp == null) {
            return this.m_oMetaDataDefMgr.save(this.m_oCurrUser, _metaDBTable, metaDBField);
        }
        return dbFieldTemp;
    }

    private MetaDBTable processMetaDBTable(XmlObject _oXmlObject) throws WCMException {
        MetaDBTable metaDBTable = (MetaDBTable)_oXmlObject.getCurrentObj();
        if (metaDBTable == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefMgr.class, "MetaDataDefMgr.label14", "\u5bfc\u5165\u7684\u6570\u636e\u4e0d\u6b63\u786e,XML\u6587\u4ef6\u4e0d\u662f\u4e00\u4e2a\u6709\u6548\u7684\u89c6\u56fe\u6587\u4ef6."));
        }
        metaDBTable.removeProperty("TABLEINFOID");
        metaDBTable.removeProperty("CRUSER");
        metaDBTable.removeProperty("CRTIME");
        metaDBTable.removeProperty("OWNERTYPE");
        metaDBTable.removeProperty("OWNERID");
        String sTableName = metaDBTable.getName();
        MetaDBTable dbTableTemp = this.findMetaDBTableByName(sTableName);
        metaDBTable = dbTableTemp == null ? this.m_oMetaDataDefMgr.save(this.m_oCurrUser, metaDBTable) : dbTableTemp;
        return metaDBTable;
    }

    private MetaDBTable findMetaDBTableByName(String _sTableName) throws WCMException {
        String sWhere = "TableName=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_sTableName);
        MetaDBTables dbTables = MetaDBTables.openWCMObjs(this.m_oCurrUser, filter);
        if (dbTables != null && !dbTables.isEmpty()) {
            return (MetaDBTable)dbTables.getAt(0);
        }
        return null;
    }

    private MetaDBField findMetaDBFieldByName(int _nTableId, String _sTableName) throws WCMException {
        String sWhere = "TableId=? and FieldName=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_nTableId);
        filter.addSearchValues(_sTableName);
        MetaDBFields dbFields = MetaDBFields.openWCMObjs(this.m_oCurrUser, filter);
        if (dbFields != null && !dbFields.isEmpty()) {
            return (MetaDBField)dbFields.getAt(0);
        }
        return null;
    }

    private MetaViewField findMetaViewFieldByName(int _nViewId, String _sFieldName) throws WCMException {
        String sWhere = "ViewId=? and FieldName=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_nViewId);
        filter.addSearchValues(_sFieldName);
        MetaViewFields viewFields = MetaViewFields.openWCMObjs(this.m_oCurrUser, filter);
        if (viewFields != null && !viewFields.isEmpty()) {
            return (MetaViewField)viewFields.getAt(0);
        }
        return null;
    }

    private MetaView findViewByName(String _sTableName, String _sViewName) throws WCMException {
        String sWhere = "MainTableName=? and ViewName=?";
        WCMFilter filter = new WCMFilter("", sWhere, "");
        filter.addSearchValues(_sTableName);
        filter.addSearchValues(_sViewName);
        MetaViews views = MetaViews.openWCMObjs(this.m_oCurrUser, filter);
        if (views != null && !views.isEmpty()) {
            return (MetaView)views.getAt(0);
        }
        return null;
    }

    private void processMetaGroup(MetaView _view, XmlObject _oXmlObject) throws WCMException {
        int nOldGroupId = 0;
        int nViewId = _view.getId();
        MetaViewFieldGroup currGroup = (MetaViewFieldGroup)_oXmlObject.getCurrentObj();
        nOldGroupId = (Integer)this.m_convertor.getObjIdMapping().get(currGroup);
        this.saveGroup(currGroup, nOldGroupId, nViewId);
    }

    private void saveGroup(MetaViewFieldGroup currGroup, int nOldGroupId, int nViewId) throws WCMException {
        int nNewGroupID = 0;
        int nParentId = currGroup.getParentId();
        if (nParentId != 0) {
            MetaViewFieldGroup oTempParentGrop = (MetaViewFieldGroup)((ArrayList)this.getKey(nParentId)).get(0);
            nOldGroupId = (Integer)this.m_convertor.getObjIdMapping().get(currGroup);
            this.saveGroup(oTempParentGrop, nOldGroupId, nViewId);
        }
        if (this.m_hCurrMetaViewFieldGroup.get(currGroup.getParentId()) != null) {
            currGroup.setProperty("PARENTID", this.m_hCurrMetaViewFieldGroup.get(currGroup.getParentId()));
        }
        if (currGroup.getId() == 0) {
            currGroup.removeProperty("METAVIEWFIELDGROUPID");
            currGroup.removeProperty("CRUSER");
            currGroup.removeProperty("CRTIME");
            currGroup.setProperty("METAVIEWID", nViewId);
            currGroup.save(this.m_oCurrUser);
            nNewGroupID = currGroup.getId();
            this.m_hCurrMetaViewFieldGroup.put(nOldGroupId, nNewGroupID);
        }
    }

    public Object getKey(Object value) {
        return this.getKey(null, value);
    }

    public Object getKey(HashMap map, Object value) {
        if (map == null) {
            map = (HashMap)this.m_convertor.getObjIdMapping();
        }
        Object o = null;
        ArrayList<Object> all = new ArrayList<Object>();
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            if (!entry.getValue().equals(value)) continue;
            o = entry.getKey();
            all.add(o);
        }
        return all;
    }
}

