/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class MetaView
extends CMSObj {
    private static final long serialVersionUID = 1L;
    public static final int OBJ_TYPE = 1874605631;
    public static final String DB_TABLE_NAME = "XWCMVIEWINFO";
    public static final String DB_ID_NAME = "VIEWINFOID";
    private MetaDBTable m_oMainTable = null;
    public static final int SPECIAL_VIEW = 1;
    private String m_sOtherTableIds = null;
    private static final String SQL_DELETE_OTHERTABLES = "delete from XWCMVIEWOtherTables where ViewId=?";
    private static final String SQL_INSERT_OTHERTABLES = "insert into XWCMVIEWOtherTables(ViewId, TableId) values(?, ?)";
    private static final String WHERE_QUERY_TABLEINFOS = "exists(select XWCMVIEWOtherTables.TableId from XWCMVIEWOtherTables where XWCMVIEWOtherTables.ViewId=? and XWCMVIEWOtherTables.TableId=XWCMTABLEINFO.TABLEINFOID)";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 1874605631;
    }

    public String getName() {
        return this.getPropertyAsString("VIEWNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty("VIEWNAME", _sName);
    }

    public String getDesc() {
        return this.getPropertyAsString("VIEWDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("VIEWDESC", _sDesc);
    }

    public String getMainTableName() {
        return this.getPropertyAsString("MAINTABLENAME");
    }

    private boolean setMainTableName(String _sMainTable) throws WCMException {
        return this.setProperty("MAINTABLENAME", _sMainTable);
    }

    public int getMainTableId() {
        return this.getPropertyAsInt("MAINTABLEID", 0);
    }

    public MetaDBTable getMainTable() throws WCMException {
        if (this.m_oMainTable == null) {
            this.m_oMainTable = MetaDBTable.findById(this.getMainTableId());
            if (this.m_oMainTable == null) {
                throw new WCMException(I18NMessage.get(MetaView.class, "MetaView.label1", "\u76f8\u5173\u7684\u7269\u7406\u8868\u4e0d\u5b58\u5728![ID=") + this.getMainTableId() + "]");
            }
        }
        return this.m_oMainTable;
    }

    private boolean setMainTableId(int _nTableId) throws WCMException {
        return this.setProperty("MAINTABLEID", _nTableId);
    }

    public boolean setMainTableId(int _nTableId, String _sTableName) throws WCMException {
        return this.setMainTableId(_nTableId) && this.setMainTableName(_sTableName);
    }

    public boolean setMainTable(MetaDBTable _dbTableInfo) throws WCMException {
        this.m_oMainTable = _dbTableInfo;
        return this.setMainTableId(_dbTableInfo.getId()) && this.setMainTableName(_dbTableInfo.getName());
    }

    public MetaDBTable getMainDBTableInfo() throws WCMException {
        return MetaDBTable.findById(this.getMainTableId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOtherTableIds() throws WCMException {
        if (this.id > 0 && this.isAddMode() && this.m_sOtherTableIds == null) {
            MetaView metaView = this;
            synchronized (metaView) {
                this.m_sOtherTableIds = this.getOtherTables(null, new WCMFilter("", "", "", "TableId")).getIdListAsString();
                if (this.m_sOtherTableIds == null) {
                    this.m_sOtherTableIds = "";
                }
            }
        }
        return this.m_sOtherTableIds;
    }

    public MetaDBTables getOtherTables(User _currUser, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", WHERE_QUERY_TABLEINFOS, "");
        filter.addSearchValues(this.getId());
        filter.mergeWith(_extraFilter);
        return MetaDBTables.openWCMObjs(_currUser, filter);
    }

    public void setOtherTableIds(String otherTableIds) {
        this.m_sOtherTableIds = otherTableIds;
        if (this.m_sOtherTableIds != null) {
            this.m_sOtherTableIds = this.m_sOtherTableIds.trim();
        }
    }

    public CMSObj getOwner() throws WCMException {
        switch (this.getOwnerType()) {
            case 1: {
                return new WCMSystemObject(this.getOwnerId());
            }
        }
        return (CMSObj)BaseObj.findById(this.getOwnerType(), this.getOwnerId());
    }

    public int getOwnerId() {
        return this.getPropertyAsInt("OWNERID", 0);
    }

    public int getOwnerType() {
        return this.getPropertyAsInt("OWNERTYPE", 0);
    }

    public boolean setOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        return this.setProperty("OwnerType", _nOwnerType) && this.setProperty("OwnerId", _nOwnerId);
    }

    public int getViewClassId() {
        return this.getPropertyAsInt("VIEWCLASSID", 0);
    }

    public boolean setRootId(int _nViewClassId) throws WCMException {
        return this.setProperty("VIEWCLASSID", _nViewClassId);
    }

    public int getSpecialValue() {
        return this.getPropertyAsInt("ISSPECIAL", 0);
    }

    public boolean setSpecialValue(int _nSpecialValue) throws WCMException {
        return this.setProperty("ISSPECIAL", _nSpecialValue);
    }

    public boolean isSpecialView() {
        return this.getSpecialValue() == 1;
    }

    public String getViewDescCon() {
        return this.getPropertyAsString("VIEWDESCCON");
    }

    public boolean setViewDescCon(String _sViewDescCon) throws WCMException {
        return this.setProperty("VIEWDESCCON", _sViewDescCon);
    }

    public String getTemplatePath() {
        return this.getPropertyAsString("TEMPLATEPATH");
    }

    public boolean setTemplatePath(String _sTemplatePath) throws WCMException {
        return this.setProperty("TEMPLATEPATH", _sTemplatePath);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("VIEWNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaView.class, "MetaView.label2", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(ViewInfo.isValid)"));
            }
            if (this.getProperty("MAINTABLEID") == null) {
                throw new WCMException(1106, I18NMessage.get(MetaView.class, "MetaView.label3", "\u5c5e\u6027MAINTABLEID\u6ca1\u6709\u8bbe\u7f6e(ViewInfo.isValid)"));
            }
            if (this.getProperty("OWNERTYPE") == null) {
                this.setOwner(1, 1);
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(MetaView.class, "MetaView.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ViewInfo.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
        }
    }

    public MetaViewFields getViewFields(User _currUser, WCMFilter _extraFilter) throws WCMException {
        WCMFilter filter = new WCMFilter("", "viewId = ?", "");
        filter.addSearchValues(this.getId());
        filter.mergeWith(_extraFilter);
        return MetaViewFields.openWCMObjs(_currUser, filter);
    }

    public MetaViewField getTitleField() throws WCMException {
        MetaViewFields oViewFields = this.getViewFields(null, null);
        int nSize = oViewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField oViewField = (MetaViewField)oViewFields.getAt(i);
            if (oViewField == null || !oViewField.isTitleField()) continue;
            return oViewField;
        }
        return null;
    }

    public static final MetaView findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MetaView)BaseObj.findById(MetaView.class, _nId);
    }

    public static final MetaView findByIdentity(String sIdentityName, String sIdentityValue) throws WCMException {
        WCMFilter filter = new WCMFilter();
        filter.setWhere(sIdentityName + "=?");
        filter.addSearchValues(sIdentityValue);
        MetaViews oMetaViews = MetaViews.openWCMObjs(null, filter);
        if (oMetaViews == null || oMetaViews.size() <= 0) {
            return null;
        }
        int nSize = oMetaViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oMetaView = (MetaView)oMetaViews.getAt(i);
            if (oMetaView == null) continue;
            return oMetaView;
        }
        return null;
    }

    public static final MetaView createNewInstance() throws WCMException {
        return (MetaView)BaseObj.createNewInstance(MetaView.class);
    }

    public static final MetaView findByKey(Object _oKey) throws WCMException {
        return (MetaView)BaseObj.findByKey(MetaView.class, _oKey);
    }

    @Override
    public void save(User _currUser) throws WCMException {
        boolean bEditMode = !this.isAddMode();
        super.save(_currUser);
        if (bEditMode) {
            if (this.m_sOtherTableIds == null) {
                return;
            }
            if (this.m_sOtherTableIds != null && this.m_sOtherTableIds.length() > 0) {
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{"delete from XWCMVIEWOtherTables where ViewId=? and TableId not in(" + this.m_sOtherTableIds + ")"}, new int[]{this.getId()});
                this.maintenaceOtherTables(this.getOtherTables(_currUser, null));
            } else {
                DBManager.getDBManager().sqlExecuteUpdate(new String[]{SQL_DELETE_OTHERTABLES}, new int[]{this.getId()});
            }
        } else if (this.m_sOtherTableIds != null && this.m_sOtherTableIds.length() > 0) {
            this.maintenaceOtherTables(null);
        }
    }

    private void maintenaceOtherTables(MetaDBTables _oExistTableInfos) throws WCMException {
        int[] pIds = CMyString.splitToInt(this.m_sOtherTableIds, ",");
        int[] pParameters = new int[2];
        pParameters[0] = this.getId();
        DBManager dbManager = DBManager.getDBManager();
        for (int i = 0; i < pIds.length; ++i) {
            if (_oExistTableInfos != null && _oExistTableInfos.indexOf(pIds[i]) >= 0) continue;
            pParameters[1] = pIds[i];
            dbManager.sqlExecuteUpdate(new String[]{SQL_INSERT_OTHERTABLES}, pParameters);
        }
    }

    @Override
    public boolean isModified(boolean zDeep) {
        if (this.isAddMode()) {
            return super.isModified(zDeep);
        }
        return this.m_sOtherTableIds != null || super.isModified(zDeep);
    }

    public String getTrueTableName() {
        if (!this.isMultiTable()) {
            return MetaDataConstants.makeTrueTableName(this.getName());
        }
        return this.getName();
    }

    public boolean isMultiTable() {
        return !this.getName().trim().equalsIgnoreCase(this.getMainTableName().trim());
    }

    public boolean isHiddenAppendix() {
        return this.getPropertyAsBoolean("HIDDENAPPENDIX", false);
    }

    public boolean setHiddenAppendix(boolean _zHide) throws WCMException {
        return this.setProperty("HIDDENAPPENDIX", _zHide);
    }

    public String getRepositoryIcon() {
        return this.getPropertyAsString("REPOSITORYICON");
    }

    public boolean setRepositoryIcon(String _sRepositoryIcon) throws WCMException {
        return this.setProperty("REPOSITORYICON", _sRepositoryIcon);
    }

    public int getRepositoryTypeId() {
        return this.getPropertyAsInt("REPOSITORYTYPEID", 0);
    }

    public boolean setRepositoryTypeId(int _nRepositoryTypeId) throws WCMException {
        return this.setProperty("REPOSITORYTYPEID", _nRepositoryTypeId);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(64);
        buff.append(this.getDesc());
        buff.append("[DBName=");
        buff.append(this.getTrueTableName());
        buff.append(",Id=");
        buff.append(this.getId());
        buff.append("] ");
        return buff.toString();
    }
}

