/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.xml.MetaViewDataToXML;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjToXmlConverterForSpecialProperty;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.ObjToXmlConverter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MetaViewDataToExcel
extends BaseObjToXmlConverterForSpecialProperty {
    private static Logger logger = Logger.getLogger(MetaViewDataToXML.class);
    private IMetaDataDefCacheMgr m_oCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
    private MetaView m_oView = null;
    private ArrayList m_arAppFiles = new ArrayList();
    private Map m_FieldMap = new HashMap();

    public MetaViewDataToExcel(MetaView _view) {
        this.m_oView = _view;
    }

    public ArrayList getAppFiles() {
        return this.m_arAppFiles;
    }

    @Override
    protected void registerHostSpecialProperties() {
        try {
            int index = 1;
            HashMap oFieldsMap = this.m_oCacheMgr.getMetaViewFields(this.m_oView.getId());
            for (Map.Entry entry : oFieldsMap.entrySet()) {
                MetaViewField oViewField = (MetaViewField)entry.getValue();
                String excelConfig = ConfigServer.getServer().getSysConfigValue("METADATA_EXPORTEXCEL_FIELD_ISCNNAME", "true");
                String fieldName = oViewField.getName().toUpperCase();
                if (Boolean.parseBoolean(excelConfig)) {
                    this.registerHostSpecialProperty(oViewField.getName(), index++, oViewField.getAnotherName());
                    this.m_FieldMap.put(fieldName, oViewField.getAnotherName());
                    continue;
                }
                this.registerHostSpecialProperty(oViewField.getName(), index++);
                this.m_FieldMap.put(fieldName, fieldName);
            }
        }
        catch (WCMException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String[][] getSpecialProperty(BaseObj _currObj, int propertyId, String _sPropertyName, Object _currValue) throws ConvertException {
        try {
            MetaViewField viewField = this.m_oCacheMgr.getMetaViewField(this.m_oView.getId(), _sPropertyName);
            if (viewField == null) {
                return null;
            }
            switch (viewField.getType()) {
                case 8: {
                    MetaViewData.FieldAppendix[] oFieldAppendixes = MetaViewData.getFieldAppendixes(_currValue.toString());
                    for (int i = 0; i < oFieldAppendixes.length; ++i) {
                        this.m_arAppFiles.add(oFieldAppendixes[i].getName());
                    }
                    break;
                }
                case 12: 
                case 16: {
                    HTMLContent htmlContent = new HTMLContent(_currValue.toString());
                    this.m_arAppFiles.addAll(htmlContent.getWCMFiles());
                    MetaViewData viewData = (MetaViewData)_currObj;
                    String textValue = viewData.getRealProperty(_sPropertyName);
                    boolean bExcludeStyle4HTML = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("EXPORT_METADATA_WITHOUTSTYLE", "false"));
                    if (bExcludeStyle4HTML) {
                        textValue = CMyString.excludeTag("style", textValue);
                    }
                    return new String[][]{{textValue}};
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception to record files!", (Throwable)e);
        }
        try {
            MetaViewData viewData = (MetaViewData)_currObj;
            return new String[][]{{CMyString.showNull(viewData.getPropertyAsString(_sPropertyName), "")}};
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label1", "\u8f6c\u6362[") + _sPropertyName + I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label2", "]\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected Element[] getChildElement(BaseObj _baseObj) throws WCMException {
        MetaViewData viewData = (MetaViewData)_baseObj;
        Document document = Document.findById(viewData.getMetaDataId());
        if (document == null) {
            logger.error((Object)(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label3", "\u6570\u636e\u53ef\u80fd\u6709\u8bef\uff0c\u6240\u5c5e\u6587\u6863\u4e0d\u5b58\u5728\uff01[ID=") + viewData.getMetaDataId() + "]"));
            return null;
        }
        AppendixMgr appendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        Appendixes appendixes = appendixMgr.getAppendixes(document, -1);
        if (appendixes == null || appendixes.size() <= 0) {
            return null;
        }
        appendixes.setMaxBufferSize(appendixes.size());
        int nSize = appendixes.size();
        for (int i = 0; i < nSize; ++i) {
            Appendix appendix = (Appendix)appendixes.getAt(i);
            if (appendix == null || appendix.getFlag() == 40) continue;
            this.m_arAppFiles.add(appendix.getFile());
        }
        ObjToXmlConverter convertor = new ObjToXmlConverter();
        return new Element[]{convertor.toXmlElement(appendixes, null)};
    }

    @Override
    public Element toXmlElement(BaseObjs _baseObjs, String _sFieldsList) throws WCMException {
        int i;
        Element element = super.toXmlElement(_baseObjs, _sFieldsList);
        if (_baseObjs != null && _baseObjs.size() >= 2) {
            return element;
        }
        BaseObj baseObj = null;
        for (i = 0; i < _baseObjs.size() && (baseObj = _baseObjs.getAt(i)) == null; ++i) {
        }
        if (baseObj == null) {
            return element;
        }
        for (i = 0; i < 2; ++i) {
            element.add(this.appendBlankRecord(baseObj, _sFieldsList));
        }
        return element;
    }

    private Element appendBlankRecord(BaseObj _baseObj, String _sFieldsList) throws WCMException {
        StringTokenizer enumKeys = null;
        String sKey = null;
        Hashtable<String, Object> hProperty = _baseObj.getAllProperty();
        Element currElement = DocumentHelper.createElement((String)this.getElementTag(_baseObj));
        Element eleProperties = currElement.addElement("PROPERTIES");
        Element eleItem = null;
        String sFieldList = _sFieldsList;
        if (sFieldList == null || sFieldList.trim().length() == 0) {
            sFieldList = this.getFieldList(_baseObj);
        }
        enumKeys = sFieldList != null && sFieldList.trim().length() > 0 ? new StringTokenizer(sFieldList.toUpperCase(), ",") : hProperty.keys();
        while (enumKeys.hasMoreElements()) {
            try {
                sKey = enumKeys.nextElement().trim();
                String sNewTagName = (String)this.m_FieldMap.get(sKey);
                if (sNewTagName == null) {
                    sNewTagName = sKey;
                }
                eleItem = eleProperties.addElement(sNewTagName);
                eleItem.setText("");
            }
            catch (Throwable ex) {
                throw new WCMException(I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label4", "\u5904\u7406[") + sKey + I18NMessage.get(MetaViewDataToExcel.class, "MetaViewDataToExcel.label5", "]\u5b57\u6bb5\u5931\u8d25!"), ex);
            }
        }
        return currElement;
    }

    @Override
    public String getElementTag(BaseObj _baseObj) {
        return "MetaViewData";
    }

    @Override
    public String getElementTag(BaseObjs _baseObjs) {
        return "MetaDataS";
    }

    @Override
    public boolean isAddVersion() {
        return false;
    }
}

