/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.HTMLContent;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.MetaDataCenterClassInfoHelper;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.center.xml.XMLToMetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.XmlObject;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyUnZipFile;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class MetaViewDataImporter {
    private static Logger logger = Logger.getLogger(MetaViewDataImporter.class);
    private static final String CHILD_TAG_APPENDIXES = "WCMAPPENDIXS";
    private MetaView m_oDstView = null;
    private Channel m_oDstChannel = null;
    private User m_oCurrUser = null;
    private String m_sCurrImportFile = null;
    private String m_sCurrXSLFile = null;
    private String m_sUnZIPTempPath = null;
    private boolean bImportToCurrChannel = true;
    private boolean bImportByChnlName = true;
    private int m_nImportType = 1;
    private Reports m_oCurrReports = null;
    private static IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private static IMetaViewEmployerMgr m_oMetaViewEmployerMgr = null;
    private CMyUnZipFile m_oZIPUtil = null;

    public MetaViewDataImporter(User _currUser, MetaView _dstView, Channel _dstChannel) {
        this.m_oCurrUser = _currUser;
        this.m_oDstView = _dstView;
        this.m_oDstChannel = _dstChannel;
        m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    }

    public Reports importFromFile(int _nImportType, String _sImportFile, String _sXslFile) throws WCMException {
        this.m_oCurrReports = new Reports(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label2", "\u5bfc\u5165\u8bb0\u5f55!"));
        String sFileExt = CMyFile.extractFileExt(_sImportFile);
        if (sFileExt == null || (sFileExt = sFileExt.trim()).length() == 0) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label3", "\u53c2\u6570[ImportFile=") + _sImportFile + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label4", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return this.m_oCurrReports;
        }
        sFileExt = sFileExt.toUpperCase();
        String sAbsolutXMLFileName = null;
        try {
            sAbsolutXMLFileName = MetaViewDataImporter.converToAbsoluteFileName(_sImportFile);
        }
        catch (Exception e) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label5", "\u5bfc\u5165\u7684\u6587\u4ef6\u6709\u8bef\uff01\uff08\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u89c4\u5219\u4e0d\u5bf9\uff09"), e);
            return this.m_oCurrReports;
        }
        String sAbsolutXSLFileName = _sXslFile;
        try {
            if (!CMyString.isEmpty(sAbsolutXSLFileName)) {
                sAbsolutXSLFileName = MetaViewDataImporter.converToAbsoluteFileName(sAbsolutXSLFileName);
            }
        }
        catch (Exception e) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label6", "XSL\u6587\u4ef6\u6709\u8bef\uff01\uff08\u4e0d\u5b58\u5728\u6216\u8005\u6587\u4ef6\u540d\u89c4\u5219\u4e0d\u5bf9\uff09"), e);
            return this.m_oCurrReports;
        }
        this.m_sCurrImportFile = sAbsolutXMLFileName;
        this.m_sCurrXSLFile = sAbsolutXSLFileName;
        this.m_nImportType = _nImportType;
        if (sFileExt.equals("XML")) {
            this.importFromXML(sAbsolutXMLFileName);
        } else if (sFileExt.equals("ZIP")) {
            this.importFromZip();
        } else {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label7", "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b[FileExt=") + sFileExt + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label8", "]\u4e0d\u6b63\u786e\uff01"), null);
            return this.m_oCurrReports;
        }
        if (this.m_oCurrReports.getSucessedReporter().size() > 0 && this.m_oCurrReports.getFailedReporter().isEmpty()) {
            this.m_oCurrReports.setTitle(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label9", "\u5bfc\u5165\u8bb0\u5f55\u6210\u529f!"));
            CMyFile.deleteDir(sAbsolutXMLFileName);
        } else {
            this.m_oCurrReports.setTitle(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label10", "\u5bfc\u5165\u8bb0\u5f55\u65f6\u51fa\u73b0\u9519\u8bef!"));
            if (this.m_oCurrReports.getFailedReporter().isEmpty()) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label21", "\u5bfc\u5165\u7684\u64cd\u4f5c\u65b9\u5f0f\u9009\u62e9\u9519\u8bef\u3002"));
            }
        }
        return this.m_oCurrReports;
    }

    public void setImportToCurrChannel(boolean bImportToCurrChannel) {
        this.bImportToCurrChannel = bImportToCurrChannel;
    }

    public boolean isImportToCurrChannel() {
        return this.bImportToCurrChannel;
    }

    public void setImportByChnlName(boolean _bImportByChnlName) {
        this.bImportByChnlName = _bImportByChnlName;
    }

    public boolean isImportByChnlName() {
        return this.bImportByChnlName;
    }

    private void importFromXML(String _sImportXMLFile) {
        XMLToMetaViewData oCurrXMLToObjConvertor = new XMLToMetaViewData(this.m_nImportType);
        oCurrXMLToObjConvertor.registPersistentObj("WCMAPPENDIX", Appendix.class);
        XmlObject[] pXMLObjects = null;
        try {
            pXMLObjects = oCurrXMLToObjConvertor.convertXml(_sImportXMLFile, this.m_sCurrXSLFile, null);
        }
        catch (Throwable e) {
            this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label11", "\u5c06XML\u8f6c\u6362\u6210Obj\u5931\u8d25\uff01[XML=") + _sImportXMLFile + "]", e);
            return;
        }
        int nSize = pXMLObjects.length;
        HashMap hmOutfiles = new HashMap(10, 1.0f);
        if (this.m_oZIPUtil != null) {
            Hashtable hNames = this.m_oZIPUtil.getAllFileNameIndex();
            Enumeration enKeys = hNames.keys();
            while (enKeys.hasMoreElements()) {
                String sFileName = (String)enKeys.nextElement();
                String sExt = CMyFile.extractFileExt(sFileName);
                if (sExt.equalsIgnoreCase("xml")) continue;
                hmOutfiles.put(sFileName.toLowerCase(), hNames.get(sFileName));
            }
        }
        for (int i = nSize - 1; i >= 0; --i) {
            try {
                MetaViewData viewData = (MetaViewData)pXMLObjects[i].getCurrentObj();
                viewData.removeProperty("MetaDataId");
                viewData.setMetaDataId(0);
                if (this.isImportToCurrChannel()) {
                    viewData.setProperty("CHANNELID", this.m_oDstChannel.getId());
                    viewData.setView(this.m_oDstView);
                } else {
                    Channel desChnl = null;
                    if (this.isImportByChnlName()) {
                        int nSiteId = this.m_oDstChannel.getSiteId();
                        String sChnlName = viewData.getPropertyAsString("CHNLNAME");
                        desChnl = Channel.findByName(nSiteId, sChnlName);
                    } else {
                        int nChnlId = viewData.getPropertyAsInt("ChannelId", 0);
                        desChnl = Channel.findById(nChnlId);
                    }
                    if (desChnl != null) {
                        this.m_oDstView = m_oMetaViewEmployerMgr.getViewOfEmployer(desChnl);
                        viewData.setProperty("CHANNELID", desChnl.getId());
                        viewData.setView(this.m_oDstView);
                    } else {
                        logger.warn((Object)"omited a metaviewdata import because the original channel do not existed!");
                        this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label15", "]\u6761\u8bb0\u5f55\u5165\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), new WCMException(I18NMessage.makeObjectNotFound(new String[]{String.valueOf(viewData.getPropertyAsString("CHNLNAME")), String.valueOf(viewData.getPropertyAsInt("ChannelId", 0)), WCMTypes.getLowerObjName(101)})));
                        continue;
                    }
                }
                if (this.m_oDstView.isMultiTable()) {
                    this.dowithOtherDatasOfOtherTable(viewData);
                }
                this.rendHtmlFields(viewData, hmOutfiles);
                MetaDataCenterClassInfoHelper.renderClassInfoFields(viewData);
                this.rendAppendixFields(viewData);
                this.rendDateFields(viewData);
                this.rendSpecialFields4Excel(viewData);
                viewData.translateFields();
                viewData.save(this.m_oCurrUser);
                this.m_oCurrReports.addSucessedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label14", "]\u6761\u8bb0\u5f55\u5165\u5e93\u6210\u529f\uff01"));
                this.processAppendix(pXMLObjects[i], viewData.getId());
                String sDocIntoFlow = ConfigServer.getServer().getSysConfigValue("DOCIMPORT_INTO_FLOW", "false");
                if (!"true".equalsIgnoreCase(sDocIntoFlow)) continue;
                Document documentNew = viewData.getDocument();
                WCMProcessServiceHelper.startDocumentInFlow(documentNew.getCrUser(), documentNew, true);
                continue;
            }
            catch (Throwable e) {
                this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label13", "\u5c06\u7b2c[") + (i + 1) + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label15", "]\u6761\u8bb0\u5f55\u5165\u5e93\u65f6\u51fa\u73b0\u9519\u8bef\uff01"), e);
            }
        }
        MetaDataCenterClassInfoHelper.destory();
    }

    private void dowithOtherDatasOfOtherTable(MetaViewData _viewData) throws WCMException, CMyException {
        HashMap<String, WCMFilter> hQueryOtherMetaDataIdFilters = new HashMap<String, WCMFilter>();
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(this.m_oDstView.getId());
        boolean clearFlag = false;
        for (MetaViewField field : hFields.values()) {
            if (field == null || field.isFromMainTable()) continue;
            if (clearFlag) {
                _viewData.removeProperty(field.getName());
                continue;
            }
            int nFieldType = field.getType();
            if (field.getLength() >= 500 || nFieldType == 12 || nFieldType == 16 || nFieldType == 8) {
                _viewData.removeProperty(field.getName());
                continue;
            }
            if (field.getDBType() == 2005) continue;
            String sOtherTableName = field.getTableName().toUpperCase();
            WCMFilter filter = (WCMFilter)hQueryOtherMetaDataIdFilters.get(sOtherTableName);
            if ((filter = this.makeQueryOtherDataIdFilter(field, filter, _viewData)) != null) {
                hQueryOtherMetaDataIdFilters.put(sOtherTableName, filter);
            } else {
                clearFlag = true;
            }
            _viewData.removeProperty(field.getName());
        }
        if (clearFlag) {
            hQueryOtherMetaDataIdFilters.clear();
        }
        Iterator itKeys = hQueryOtherMetaDataIdFilters.keySet().iterator();
        DBManager dbManager = DBManager.getDBManager();
        while (itKeys.hasNext()) {
            String sTableName = (String)itKeys.next();
            WCMFilter filter = (WCMFilter)hQueryOtherMetaDataIdFilters.get(sTableName);
            int nOtherMetaDataId = dbManager.sqlExecuteIntQuery(filter);
            if (nOtherMetaDataId <= 0) continue;
            _viewData.setProperty(filter.getFrom() + "ID", nOtherMetaDataId);
        }
    }

    private WCMFilter makeQueryOtherDataIdFilter(MetaViewField _field, WCMFilter _filter, MetaViewData _viewData) throws CMyException {
        String sViewFieldName = _field.getName();
        String sValue = _viewData.getPropertyAsString(sViewFieldName);
        if (CMyString.isEmpty(sValue)) {
            return _filter;
        }
        String sWhere = null;
        if (_filter == null) {
            sWhere = _field.getDBName() + "=?";
            _filter = new WCMFilter(MetaDataConstants.makeTrueTableName(_field.getTableName()).toUpperCase(), sWhere, "", "MetaDataId");
        } else {
            sWhere = _filter.getWhere() + " and " + _field.getDBName() + "=?";
        }
        _filter.setWhere(sWhere);
        switch (_field.getDBType()) {
            case 93: {
                CMyDateTime dtValue = new CMyDateTime();
                if (!dtValue.testDateFormat(sValue)) {
                    return null;
                }
                dtValue.setDateTimeWithString(sValue);
                _filter.addSearchValues(dtValue);
                break;
            }
            case 4: {
                int intSearchValue;
                try {
                    intSearchValue = Integer.parseInt(sValue);
                }
                catch (Throwable e) {
                    return null;
                }
                _filter.addSearchValues(intSearchValue);
                break;
            }
            case 6: {
                float floatSearchValue;
                try {
                    floatSearchValue = Float.parseFloat(sValue);
                }
                catch (Throwable e) {
                    return null;
                }
                _filter.addSearchValues(floatSearchValue);
                break;
            }
            case 8: {
                double doubleSearchValue;
                try {
                    doubleSearchValue = Double.parseDouble(sValue);
                }
                catch (Throwable e) {
                    return null;
                }
                _filter.addSearchValues(doubleSearchValue);
                break;
            }
            default: {
                _filter.addSearchValues(sValue);
            }
        }
        return _filter;
    }

    private void rendAppendixFields(MetaViewData oViewData) throws WCMException {
        if (this.m_sUnZIPTempPath == null) {
            return;
        }
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || field.getType() != 8 || CMyString.isEmpty(sFieldValue = oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = sFieldValue.trim();
            MetaViewData.FieldAppendix[] oFieldAppendixes = MetaViewData.getFieldAppendixes(sFieldValue);
            for (int i = 0; i < oFieldAppendixes.length; ++i) {
                String sFileName = oFieldAppendixes[i].getName();
                if (!CMyFile.fileExists(this.m_sUnZIPTempPath + sFileName)) {
                    logger.debug((Object)(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label16", "\u9644\u4ef6[") + this.m_sUnZIPTempPath + sFieldValue + I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label17", "]\u4e0d\u5b58\u5728\uff0c\u6240\u4ee5\u5ffd\u7565")));
                    oFieldAppendixes[i].setName("");
                    continue;
                }
                FilesMan filesMan = FilesMan.getFilesMan();
                String sNewFileName = filesMan.getNextFileName("P0", CMyFile.extractFileExt(sFileName));
                String sPathInfo = filesMan.mapFilePath(sNewFileName, 0);
                try {
                    CMyFile.copyFile(this.m_sUnZIPTempPath + sFileName, sPathInfo + sNewFileName);
                    oFieldAppendixes[i].setName(sNewFileName);
                    continue;
                }
                catch (CMyException e) {
                    this.m_oCurrReports.addWarnedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label18", "\u5904\u7406\u9644\u4ef6\u5931\u8d25\uff01[DocId=") + this.m_sUnZIPTempPath + sFileName + "]", e);
                }
            }
            oViewData.setPropertyWithString(sFieldName, MetaViewData.getTransformFieldAppendixes(oFieldAppendixes));
        }
    }

    private void rendDateFields(MetaViewData oViewData) throws CMyException {
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || field.getType() != 11 || CMyString.isEmpty(sFieldValue = oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = sFieldValue.trim();
            int nFieldValue = 0;
            try {
                nFieldValue = Integer.parseInt(sFieldValue);
            }
            catch (NumberFormatException e) {
                return;
            }
            oViewData.setPropertyWithString(sFieldName, "1900-01-01");
            oViewData.getPropertyAsDateTime(sFieldName).dateAdd(3, nFieldValue - 2);
        }
    }

    private void rendSpecialFields4Excel(MetaViewData _oViewData) throws WCMException {
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || !field.isFromMainTable() || CMyString.isEmpty(sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = sFieldValue.trim();
            switch (MetaDataConstants.formatOfEnumValue(field.getType())) {
                case 5: {
                    try {
                        Integer.parseInt(sFieldValue);
                    }
                    catch (NumberFormatException e) {
                        if (sFieldValue.equals(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label23", "\u662f"))) {
                            sFieldValue = "1";
                        }
                        if (!sFieldValue.equals(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label24", "\u5426"))) break;
                        sFieldValue = "0";
                    }
                    break;
                }
                case -1: {
                    HashMap hashLabelKey = field.getEnmValueMap(false);
                    Object[] arrLabelOrValue = sFieldValue.split(",");
                    if (arrLabelOrValue != null && arrLabelOrValue.length > 0) {
                        for (int i = 0; i < arrLabelOrValue.length; ++i) {
                            Object iv = arrLabelOrValue[i];
                            if (!hashLabelKey.containsKey(iv) || hashLabelKey.containsValue(iv)) continue;
                            arrLabelOrValue[i] = (String)hashLabelKey.get(iv);
                        }
                    }
                    sFieldValue = CMyString.join(arrLabelOrValue, ",");
                    break;
                }
            }
            _oViewData.setProperty(sFieldName, sFieldValue);
        }
    }

    private void rendHtmlFields(MetaViewData _oViewData, HashMap _hmOutFiles) throws WCMException {
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(_oViewData.getMetaView().getId());
        Iterator iter = hFields.values().iterator();
        if (!_hmOutFiles.isEmpty()) {
            while (iter.hasNext()) {
                String sFieldName;
                String sFieldValue;
                MetaViewField field = (MetaViewField)iter.next();
                if (field == null || field.getType() != 12 && field.getType() != 16 || CMyString.isEmpty(sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
                sFieldValue = HTMLContent.saveHTMLContentFromOut(sFieldValue, _hmOutFiles);
                _oViewData.setPropertyWithString(sFieldName, sFieldValue);
            }
        } else {
            while (iter.hasNext()) {
                String sFieldName;
                String sFieldValue;
                MetaViewField field = (MetaViewField)iter.next();
                if (field == null || field.getType() != 12 && field.getType() != 16 || CMyString.isEmpty(sFieldValue = _oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
                _oViewData.setPropertyWithString(sFieldName, sFieldValue);
            }
        }
    }

    void rendHTMLFields(MetaViewData oViewData) throws WCMException {
        if (this.m_oZIPUtil == null) {
            return;
        }
        Hashtable hNames = this.m_oZIPUtil.getAllFileNameIndex();
        HashMap<String, String> hmOutFiles = new HashMap<String, String>(hNames.size());
        Enumeration enKeys = hNames.keys();
        while (enKeys.hasMoreElements()) {
            String sFileName = (String)enKeys.nextElement();
            String sExt = CMyFile.extractFileExt(sFileName);
            if (sExt.equalsIgnoreCase("xml")) continue;
            hmOutFiles.put(sFileName.toLowerCase(), (String)hNames.get(sFileName));
        }
        if (hmOutFiles.isEmpty()) {
            return;
        }
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || field.getType() != 12 && field.getType() != 16 || CMyString.isEmpty(sFieldValue = oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = HTMLContent.saveHTMLContentFromOut(sFieldValue, hmOutFiles);
            oViewData.setPropertyWithString(sFieldName, sFieldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importFromZip() {
        this.m_sUnZIPTempPath = CMyFile.extractFilePath(this.m_sCurrImportFile);
        this.m_sUnZIPTempPath = this.m_sUnZIPTempPath + "temp" + System.currentTimeMillis() + File.separator;
        try {
            this.m_oZIPUtil = new CMyUnZipFile(this.m_sCurrImportFile, this.m_sUnZIPTempPath);
            try {
                this.m_oZIPUtil.addFileExtFilters("XML");
                this.m_oZIPUtil.doUnZipAnd();
            }
            catch (CMyException e) {
                this.m_sUnZIPTempPath = null;
                this.m_oCurrReports.addFailedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label19", "Zip\u6587\u4ef6\u89e3\u538b\u5931\u8d25![File=") + this.m_sCurrImportFile + ",DstPath=" + this.m_sUnZIPTempPath + "]", e);
                if ((this.m_oCurrReports.getFailedReporter() == null || this.m_oCurrReports.getFailedReporter().isEmpty()) && !logger.isDebugEnabled()) {
                    CMyFile.deleteFile(this.m_sCurrImportFile);
                    if (this.m_sUnZIPTempPath != null) {
                        CMyFile.deleteDir(this.m_sUnZIPTempPath);
                    }
                }
                return;
            }
            ArrayList allXmlFiles = this.m_oZIPUtil.getFilteredFiles();
            if (allXmlFiles == null || allXmlFiles.isEmpty()) {
                return;
            }
            String sXmlFile = null;
            for (int i = allXmlFiles.size() - 1; i >= 0; --i) {
                sXmlFile = (String)allXmlFiles.get(i);
                if (this.isExportedFileForOfflineView(CMyFile.extractFileName(sXmlFile)) || FilesMan.isValidFile(CMyFile.extractFileName(sXmlFile), "P0")) continue;
                this.importFromXML(sXmlFile);
            }
        }
        finally {
            if ((this.m_oCurrReports.getFailedReporter() == null || this.m_oCurrReports.getFailedReporter().isEmpty()) && !logger.isDebugEnabled()) {
                CMyFile.deleteFile(this.m_sCurrImportFile);
                if (this.m_sUnZIPTempPath != null) {
                    CMyFile.deleteDir(this.m_sUnZIPTempPath);
                }
            }
        }
    }

    public static String converToAbsoluteFileName(String _sFileName) throws WCMException {
        String sAbsolutFileName = null;
        FileService file = new FileService(_sFileName);
        if (file.exists()) {
            sAbsolutFileName = file.getAbsolutePath();
        } else {
            FilesMan filesMan = FilesMan.getFilesMan();
            String[] pFlag = new String[]{"U0", "ST"};
            for (int i = 0; i < pFlag.length; ++i) {
                if (!FilesMan.isValidFile(_sFileName, pFlag[i])) continue;
                sAbsolutFileName = filesMan.mapFilePath(_sFileName, 0) + _sFileName;
                break;
            }
            if (sAbsolutFileName == null) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + _sFileName + "]");
            }
            if (!CMyFile.fileExists(sAbsolutFileName)) {
                throw new WCMException(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label20", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff01[FileName=") + sAbsolutFileName + "]");
            }
        }
        return sAbsolutFileName;
    }

    private boolean isExportedFileForOfflineView(String _sFileName) {
        return "trs_wcm_viewer_index.htm".equals(_sFileName) || "trs_wcm_viewer_doview.htm".equals(_sFileName) || "resource.xml".equals(_sFileName) || "reference.xml".equals(_sFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAppendix(XmlObject _xmlObj, int _nDocId) throws WCMException {
        if (this.m_sUnZIPTempPath == null) {
            return;
        }
        XmlObject[] children = _xmlObj.getChild(CHILD_TAG_APPENDIXES);
        if (children == null || children.length == 0) {
            return;
        }
        Appendix appendix = null;
        String sNewFileName = null;
        String sPathInfo = null;
        FilesMan filesMan = FilesMan.getFilesMan();
        String sPath = this.m_sUnZIPTempPath;
        boolean hasPicAppendix = false;
        for (int i = 0; i < children.length; ++i) {
            appendix = (Appendix)children[i].getCurrentObj();
            appendix.setDocId(_nDocId);
            int nFlag = appendix.getFlag();
            if (nFlag != 40) {
                if (nFlag == 30) continue;
                String sFile = appendix.getFile();
                if (!CMyFile.fileExists(this.m_sUnZIPTempPath + sFile)) continue;
                appendix.setSrcFile(sFile);
                appendix.setFileExt(CMyFile.extractFileExt(sFile));
                String strDesc = appendix.getDesc();
                if (strDesc == null || strDesc.length() == 0) {
                    appendix.setDesc(appendix.getFile());
                }
                if (nFlag == 20) {
                    sNewFileName = filesMan.getNextFileName("W0", appendix.getFileExt());
                    hasPicAppendix = true;
                } else {
                    sNewFileName = filesMan.getNextFileName("P0", appendix.getFileExt());
                }
                appendix.setUsedVersions(1L);
                sPathInfo = filesMan.mapFilePath(sNewFileName, 0);
                try {
                    CMyFile.copyFile(sPath + sFile, sPathInfo + sNewFileName);
                }
                catch (CMyException e) {
                    this.m_oCurrReports.addWarnedReport(I18NMessage.get(MetaViewDataImporter.class, "MetaViewDataImporter.label18", "\u5904\u7406\u9644\u4ef6\u5931\u8d25\uff01[DocId=") + _nDocId + ",File=" + sFile + "]", e);
                    continue;
                }
                appendix.setFile(sNewFileName);
            }
            appendix.save(this.m_oCurrUser);
        }
        if (hasPicAppendix) {
            DBManager dbman = DBManager.getDBManager();
            String sql = "update WCMDOCUMENT set ATTACHPIC=? where DOCID=?";
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = dbman.getConnection();
                pstmt = conn.prepareStatement(sql);
                pstmt.setInt(1, 1);
                pstmt.setInt(2, _nDocId);
                pstmt.executeUpdate();
                if (dbman.getFieldInfo("WCMCHNLDOC", "ATTACHPIC") != null) {
                    sql = "update WCMCHNLDOC set ATTACHPIC=? where DOCID=?";
                    pstmt.close();
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setInt(1, 1);
                    pstmt.setInt(2, _nDocId);
                    pstmt.executeUpdate();
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (conn != null) {
                    dbman.freeConnection(conn);
                }
            }
        }
    }
}

