/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center;

import com.trs.DreamFactory;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IClassInfoMgr;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;

public class MetaDataCenterClassInfoHelper {
    private static Map mCacheClassInfo = null;
    private static IMetaDataDefCacheMgr m_oDataDefCacheMgr = null;
    private static IClassInfoMgr m_oClassInfoMgr = null;
    private static boolean isInited = false;

    public static void init() {
        if (isInited) {
            return;
        }
        mCacheClassInfo = new HashMap();
        m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
        m_oClassInfoMgr = (IClassInfoMgr)DreamFactory.createObjectById("IClassInfoMgr");
    }

    public static MetaViewData renderClassInfoFields(MetaViewData oViewData) throws WCMException {
        MetaDataCenterClassInfoHelper.init();
        HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(oViewData.getMetaView().getId());
        for (MetaViewField field : hFields.values()) {
            String sFieldName;
            String sFieldValue;
            if (field == null || !field.isFromMainTable() || field.getType() != 10 || CMyString.isEmpty(sFieldValue = oViewData.getFinalPropertyAsString(sFieldName = field.getName()))) continue;
            sFieldValue = sFieldValue.trim();
            String sClassInfoId = MetaDataCenterClassInfoHelper.getClassInfo(field.getClassId(), sFieldValue);
            if (sClassInfoId == null) {
                throw new WCMException(I18NMessage.get(MetaDataCenterClassInfoHelper.class, "MetaDataCenterClassInfoHelper.label1", "\u975e\u6cd5\u7684\u5206\u7c7b\u503c[") + sFieldName + "=" + sFieldValue + "]");
            }
            oViewData.setProperty(sFieldName, sClassInfoId);
        }
        return oViewData;
    }

    private static String getClassInfo(int nClassInfoRootId, String sKey) throws WCMException {
        if (sKey == null) {
            return null;
        }
        String oClassInfoId = (String)mCacheClassInfo.get(sKey);
        if (oClassInfoId != null) {
            return oClassInfoId;
        }
        String[] aClassInfoId = sKey.split(",|;");
        if (aClassInfoId.length > 1) {
            String sResult = "";
            for (int i = 0; i < aClassInfoId.length; ++i) {
                String sTempResult = MetaDataCenterClassInfoHelper.getClassInfo(nClassInfoRootId, aClassInfoId[i].trim());
                if (CMyString.isEmpty(sTempResult)) continue;
                sResult = sResult + sTempResult + ",";
            }
            if (sResult.length() > 0) {
                sResult = sResult.substring(0, sResult.length() - 1);
            }
            mCacheClassInfo.put(sKey, sResult);
            return sResult;
        }
        int nClassInfoId = -1;
        try {
            nClassInfoId = Integer.parseInt(sKey);
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        if (nClassInfoId != -1) {
            mCacheClassInfo.put(sKey, String.valueOf(nClassInfoId));
            return String.valueOf(nClassInfoId);
        }
        ClassInfo oClassInfo = null;
        if (sKey.indexOf(92) >= 0) {
            oClassInfo = m_oClassInfoMgr.getClassInfo(sKey);
            if (oClassInfo != null) {
                mCacheClassInfo.put(sKey, String.valueOf(oClassInfo.getId()));
                return String.valueOf(oClassInfo.getId());
            }
            return null;
        }
        ClassInfos oClassInfos = m_oClassInfoMgr.getClassInfosByName(nClassInfoRootId, sKey);
        if (oClassInfos != null && oClassInfos.size() > 0) {
            String sClassInfoId = String.valueOf(oClassInfos.getIdAt(0));
            mCacheClassInfo.put(sKey, sClassInfoId);
            return sClassInfoId;
        }
        return null;
    }

    public static void destory() {
        if (!isInited) {
            return;
        }
        isInited = false;
        mCacheClassInfo.clear();
        mCacheClassInfo = null;
        m_oDataDefCacheMgr = null;
        m_oClassInfoMgr = null;
    }
}

