/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class InfoViewSerial {
    private int m_nNextSerial;
    private int m_nMaxSerial;
    private int m_nInfoViewId;
    private int m_nBaseSerial;
    private String m_sPeriodPart;
    private static final int CACHE_SIZE = 5;
    public static final int SERIAL_PERIOD_DAY = 0;
    public static final int SERIAL_PERIOD_MONTH = 1;
    public static final int SERIAL_PERIOD_YEAR = 2;
    public static final int SERIAL_PERIOD_FORERVER = -1;
    private final String INSERT_SQL = "INSERT INTO WCMInfoviewSerial(PeriodPart,InfoViewId,NextSerial,BaseSerial) VALUES(?,?,?,?)";
    private final String UPDATE_SQL = "UPDATE WCMInfoviewSerial SET NextSerial=? WHERE PeriodPart=? AND InfoViewId=?";
    private final String SELECT_SQL = "SELECT NextSerial FROM WCMInfoviewSerial WHERE PeriodPart=? AND InfoViewId=?";

    InfoViewSerial(int nInfoViewId, int nSerialPeriod, int nBaseSerial) {
        if (nBaseSerial <= 0) {
            throw new IllegalArgumentException("The BaseSerial must be larger than zero!");
        }
        this.m_nInfoViewId = nInfoViewId;
        this.m_nBaseSerial = nBaseSerial;
        this.m_sPeriodPart = this.getPeriodPart(nSerialPeriod);
        this.m_nNextSerial = 0;
        this.m_nMaxSerial = 0;
    }

    private String getPeriodPart(int nSerialPeriod) {
        CMyDateTime period = CMyDateTime.now();
        String periodPart = null;
        switch (nSerialPeriod) {
            case 0: {
                periodPart = period.toString("yyyyMMdd");
                break;
            }
            case 1: {
                periodPart = period.toString("yyyyMM");
                break;
            }
            case 2: {
                periodPart = period.toString("yyyy");
                break;
            }
            case -1: {
                periodPart = "Forerver";
                break;
            }
            default: {
                periodPart = period.toString("yyyyMM");
            }
        }
        return periodPart;
    }

    public synchronized Integer getNextSerial() throws WCMException {
        if (this.m_nNextSerial == this.m_nMaxSerial) {
            this.reloadSerial();
        }
        return new Integer(this.m_nNextSerial++);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reloadSerial() throws WCMException {
        PreparedStatement selectStmt = null;
        PreparedStatement updateStmt = null;
        Connection conn = null;
        DBManager dbman = DBManager.getDBManager();
        try {
            conn = dbman.getConnection();
            conn.setAutoCommit(false);
            selectStmt = conn.prepareStatement("SELECT NextSerial FROM WCMInfoviewSerial WHERE PeriodPart=? AND InfoViewId=?");
            selectStmt.setString(1, this.m_sPeriodPart);
            selectStmt.setInt(2, this.m_nInfoViewId);
            selectStmt.executeQuery();
            ResultSet resultSet2332 = selectStmt.getResultSet();
            boolean zNewSerial = false;
            if (resultSet2332 != null && resultSet2332.next()) {
                this.m_nNextSerial = resultSet2332.getInt(1);
                resultSet2332.close();
            } else {
                this.m_nNextSerial = this.m_nBaseSerial;
                zNewSerial = true;
            }
            this.m_nMaxSerial = this.m_nNextSerial + 5;
            if (zNewSerial) {
                updateStmt = conn.prepareStatement("INSERT INTO WCMInfoviewSerial(PeriodPart,InfoViewId,NextSerial,BaseSerial) VALUES(?,?,?,?)");
                updateStmt.setString(1, this.m_sPeriodPart);
                updateStmt.setInt(2, this.m_nInfoViewId);
                updateStmt.setInt(3, this.m_nMaxSerial);
                updateStmt.setInt(4, this.m_nBaseSerial);
            } else {
                updateStmt = conn.prepareStatement("UPDATE WCMInfoviewSerial SET NextSerial=? WHERE PeriodPart=? AND InfoViewId=?");
                updateStmt.setInt(1, this.m_nMaxSerial);
                updateStmt.setString(2, this.m_sPeriodPart);
                updateStmt.setInt(3, this.m_nInfoViewId);
            }
            updateStmt.executeUpdate();
            conn.commit();
            this.freeStatment(selectStmt);
            this.freeStatment(updateStmt);
        }
        catch (SQLException e) {
            try {
                throw new WCMException("Reload SerialNum failed!", e);
            }
            catch (Throwable throwable) {
                this.freeStatment(selectStmt);
                this.freeStatment(updateStmt);
                try {
                    conn.setAutoCommit(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dbman.freeConnection(conn);
                throw throwable;
            }
        }
        try {
            conn.setAutoCommit(true);
        }
        catch (Exception resultSet2332) {
            // empty catch block
        }
        dbman.freeConnection(conn);
    }

    private void freeStatment(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(64);
        buff.append("[SerialNum:");
        buff.append("InfoViewId=").append(this.m_nInfoViewId).append(";");
        buff.append("NextSerial=").append(this.m_nNextSerial).append(";");
        buff.append("PeriodPart=").append(this.m_sPeriodPart).append(";");
        buff.append("BaseSerial=").append(this.m_nBaseSerial);
        buff.append("]");
        return buff.toString();
    }

    public static void main(String[] args) {
        try {
            InfoViewSerial serial = new InfoViewSerial(1, 1, 10);
            for (int i = 0; i < 8; ++i) {
                System.out.println(serial.getNextSerial());
            }
            InfoViewSerial s2 = new InfoViewSerial(1, -1, 1);
            for (int i = 0; i < 7; ++i) {
                System.out.println(s2.getNextSerial());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

