/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.content.CMSObj;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.db.InfoViewDataType;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import org.apache.log4j.Logger;

public class InfoViewField
extends CMSObj {
    private static final Logger logger = Logger.getLogger(InfoViewField.class);
    public static final int OBJ_TYPE = 1105;
    public static final String DB_TABLE_NAME = "WCMINFOVIEWFIELD";
    public static final String DB_ID_NAME = "IVFIELDID";
    private InfoView m_oOwner;

    public static final InfoViewField findById(int id) throws WCMException {
        if (id <= 0) {
            return null;
        }
        return (InfoViewField)BaseObj.findById(InfoViewField.class, id);
    }

    public static final InfoViewField createNewInstance() throws WCMException {
        return (InfoViewField)BaseObj.createNewInstance(InfoViewField.class);
    }

    @Override
    public int getWCMType() {
        return 1105;
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("INFOVIEWID") == null && this.m_oOwner != null && this.m_oOwner.getId() > 0) {
                this.setProperty("INFOVIEWID", this.m_oOwner.getId());
            }
            if (this.getProperty("INFOVIEWID") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label1", "\u5c5e\u6027INFOVIEWID\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("FIELDNAME") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label2", "\u5c5e\u6027FIELDNAME\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (this.getProperty("DATATYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(InfoViewField.class, "InfoViewField.label3", "\u5c5e\u6027DATATYPE\u6ca1\u6709\u8bbe\u7f6e"));
            }
            if (!this.containsProperty("DataControl")) {
                switch (this.getDataType()) {
                    case 12: {
                        this.setDataControl("type:'string',max_len:" + this.getMaxLength());
                        break;
                    }
                    case 91: {
                        this.setDataControl("type:'date'");
                        break;
                    }
                    case 4: {
                        this.setDataControl("type:'int',value_range:'-2147483648,2147483647'");
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            switch (this.getNewPropertyAsInt("DATATYPE", 0)) {
                case 93: {
                    String sCurrDataControl = this.getNewPropertyAsString("DATACONTROL");
                    if (sCurrDataControl != null && sCurrDataControl.indexOf("type:'date'") >= 0) {
                        sCurrDataControl.replaceAll("type:'date'", "");
                    }
                    this.setDataControl(sCurrDataControl);
                    break;
                }
            }
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[InfoViewField,");
        sb.append("Name:").append(this.getName()).append(',');
        sb.append("Desc:").append(this.getDesc()).append(',');
        sb.append("Type:").append(this.getDataType()).append(',');
        sb.append(']');
        return sb.toString();
    }

    InfoView getOwner() {
        return this.m_oOwner;
    }

    void setOwner(InfoView _oInfoView) {
        this.m_oOwner = _oInfoView;
    }

    public String getName() {
        return (String)this.getProperty("FIELDNAME");
    }

    public boolean setName(String _sName) throws WCMException {
        return this.setProperty("FIELDNAME", _sName);
    }

    public String getXPath() {
        return (String)this.getProperty("XSLTXPATH");
    }

    public boolean setXPath(String _sXPath) throws WCMException {
        return this.setProperty("XSLTXPATH", _sXPath);
    }

    public String getDesc() {
        return (String)this.getProperty("FIELDDESC");
    }

    public boolean setDesc(String _sDesc) throws WCMException {
        return this.setProperty("FIELDDESC", _sDesc);
    }

    public int getInfoViewID() {
        return this.getPropertyAsInt("INFOVIEWID", 0);
    }

    public boolean setInfoViewID(int _iInfoViewID) throws WCMException {
        return this.setProperty("INFOVIEWID", _iInfoViewID);
    }

    public boolean isSpecialRight() {
        return this.getPropertyAsBoolean("SPECIALRIGHT", false);
    }

    public boolean setSpecialRight(boolean _zSpecialRight) throws WCMException {
        return this.setProperty("SPECIALRIGHT", _zSpecialRight);
    }

    public boolean isPublicFill() {
        return this.getPropertyAsBoolean("PUBLICFILL", false);
    }

    public boolean setPublicFill(boolean _zPublicFill) throws WCMException {
        return this.setProperty("PUBLICFILL", _zPublicFill);
    }

    public boolean isPublicView() {
        return this.getPropertyAsBoolean("PUBLICVIEW", false);
    }

    public boolean setPublicView(boolean _zPublicView) throws WCMException {
        return this.setProperty("PUBLICVIEW", _zPublicView);
    }

    public boolean isNillable() {
        return this.getPropertyAsBoolean("NILLABLE", false);
    }

    public boolean setNillable(boolean _zNillable) throws WCMException {
        return this.setProperty("NILLABLE", _zNillable);
    }

    public int getDataType() {
        return this.getPropertyAsInt("DATATYPE", 0);
    }

    public String getDataTypeAsString() {
        InfoViewDataType oDataType = InfoViewConstants.DB_DATA_TYPES.getDataTypeById(this.getDataType());
        if (oDataType == null) {
            logger.warn((Object)(I18NMessage.get(InfoViewField.class, "InfoViewField.label4", "\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1f") + this.getDataType()));
            oDataType = InfoViewConstants.DB_DATA_TYPES.getDataTypeById(12);
        }
        return oDataType.getKey();
    }

    public boolean setDataType(int _nDataType) throws WCMException {
        return this.setProperty("DATATYPE", _nDataType);
    }

    public String getDataControl() {
        return (String)this.getProperty("DATACONTROL");
    }

    public boolean setDataControl(String _sDataControl) throws WCMException {
        return this.setProperty("DATACONTROL", _sDataControl);
    }

    public String getDataPattern() {
        return (String)this.getProperty("DATAPATTERN");
    }

    public boolean setDataPattern(String _sDataPattern) throws WCMException {
        return this.setProperty("DATAPATTERN", _sDataPattern);
    }

    public int getFixLength() {
        return this.getPropertyAsInt("FIXLENGTH", 0);
    }

    public boolean setFixLength(int _iFixLength) throws WCMException {
        return this.setProperty("FIXLENGTH", _iFixLength);
    }

    public int getMaxLength() {
        return this.getPropertyAsInt("MAXLENGTH", 0);
    }

    public boolean setMaxLength(int _iMaxLength) throws WCMException {
        return this.setProperty("MAXLENGTH", _iMaxLength);
    }

    public int getMinLength() {
        return this.getPropertyAsInt("MINLENGTH", 0);
    }

    public boolean setMinLength(int _iMinLength) throws WCMException {
        return this.setProperty("MINLENGTH", _iMinLength);
    }

    public String getFieldType() {
        return this.getPropertyAsString("FIELDTYPE");
    }

    public boolean setFieldType(String _sFieldType) throws WCMException {
        return this.setProperty("FIELDTYPE", _sFieldType);
    }

    public String getDefaultValue() {
        return (String)this.getProperty("DEFAULTVALUE");
    }

    public boolean setDefaultValue(String _sDefaultValue) throws WCMException {
        return this.setProperty("DEFAULTVALUE", _sDefaultValue);
    }

    public String getEnumValue() {
        return (String)this.getProperty("ENUMVALUE");
    }

    public boolean setEnumValue(String _sEnumValue) throws WCMException {
        return this.setProperty("ENUMVALUE", _sEnumValue);
    }

    public int getClassId() {
        return this.getPropertyAsInt("ClassId", 0);
    }

    public boolean setClassId(int _nClassId) throws WCMException {
        return this.setProperty("ClassId", _nClassId);
    }

    public boolean isOutlineField() {
        return this.getPropertyAsInt("InOutline", 0) != 0;
    }

    public boolean setOutlineField(boolean _bInOutline) throws WCMException {
        return this.setProperty("InOutline", _bInOutline ? 1L : 0L);
    }

    public boolean isSearchField() {
        return this.getPropertyAsInt("InSearch", 0) != 0;
    }

    public boolean setSearchField(boolean _bInSearch) throws WCMException {
        return this.setProperty("InSearch", _bInSearch ? 1L : 0L);
    }

    public String getGateWayBinding() {
        return (String)this.getProperty("GateWayBinding");
    }

    public boolean setGateWayBinding(String _sGateWayBinding) throws WCMException {
        return this.setProperty("GateWayBinding", _sGateWayBinding);
    }

    public boolean isReadOnly() {
        return this.getPropertyAsInt("ReadOnly", 0) != 0;
    }

    public boolean setReadOnly(boolean _bReadOnly) throws WCMException {
        return this.setProperty("ReadOnly", _bReadOnly ? 1L : 0L);
    }

    public boolean isBackReadOnly() {
        return this.getPropertyAsInt("BackReadOnly", 0) != 0;
    }

    public boolean setBackReadOnly(boolean _bBackReadOnly) throws WCMException {
        return this.setProperty("BackReadOnly", _bBackReadOnly ? 1L : 0L);
    }

    public boolean isBackShowAble() {
        return this.getPropertyAsInt("BackShowAble", 1) != 0;
    }

    public boolean setBackShowAble(boolean _bBackShowAble) throws WCMException {
        return this.setProperty("BackShowAble", _bBackShowAble ? 1L : 0L);
    }

    public String getTrueFieldName() throws WCMException {
        return this.getPropertyAsString("TrueFieldName");
    }

    public boolean setTrueFieldName(String _sTrueFieldName) throws WCMException {
        return this.setProperty("TrueFieldName", _sTrueFieldName);
    }
}

